/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.fop.fonts.type1.PFBData;

public class PFBParser {
    private static final byte[] CURRENTFILE_EEXEC;
    private static final byte[] CLEARTOMARK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PFBData parsePFB(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            PFBData pFBData = this.parsePFB(inputStream);
            return pFBData;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PFBData parsePFB(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            PFBData pFBData = this.parsePFB(fileInputStream);
            return pFBData;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public PFBData parsePFB(InputStream inputStream) throws IOException {
        PFBData pFBData = new PFBData();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        dataInputStream.mark(32);
        int n = dataInputStream.readUnsignedByte();
        dataInputStream.reset();
        if (n == 128) {
            pFBData.setPFBFormat(1);
            this.parsePCFormat(pFBData, dataInputStream);
        } else {
            pFBData.setPFBFormat(0);
            this.parseRAWFormat(pFBData, bufferedInputStream);
        }
        return pFBData;
    }

    private static int swapInteger(int n) {
        return ((n >> 0 & 0xFF) << 24) + ((n >> 8 & 0xFF) << 16) + ((n >> 16 & 0xFF) << 8) + ((n >> 24 & 0xFF) << 0);
    }

    private void parsePCFormat(PFBData pFBData, DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        if (n != 128) {
            throw new IOException("Invalid file format. Expected ASCII 80hex");
        }
        int n2 = dataInputStream.readUnsignedByte();
        int n3 = PFBParser.swapInteger(dataInputStream.readInt());
        byte[] byArray = new byte[n3];
        dataInputStream.readFully(byArray);
        pFBData.setHeaderSegment(byArray);
        n = dataInputStream.readUnsignedByte();
        if (n != 128) {
            throw new IOException("Invalid file format. Expected ASCII 80hex");
        }
        n2 = dataInputStream.readUnsignedByte();
        int n4 = PFBParser.swapInteger(dataInputStream.readInt());
        byte[] byArray2 = new byte[n4];
        dataInputStream.readFully(byArray2);
        pFBData.setEncryptedSegment(byArray2);
        n = dataInputStream.readUnsignedByte();
        if (n != 128) {
            throw new IOException("Invalid file format. Expected ASCII 80hex");
        }
        n2 = dataInputStream.readUnsignedByte();
        int n5 = PFBParser.swapInteger(dataInputStream.readInt());
        byte[] byArray3 = new byte[n5];
        dataInputStream.readFully(byArray3);
        pFBData.setTrailerSegment(byArray3);
        n = dataInputStream.readUnsignedByte();
        if (n != 128) {
            throw new IOException("Invalid file format. Expected ASCII 80hex");
        }
        n2 = dataInputStream.readUnsignedByte();
        if (n2 != 3) {
            throw new IOException("Expected segment type 3, but found: " + n2);
        }
    }

    private static boolean byteCmp(byte[] byArray, int n, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private void calcLengths(PFBData pFBData, byte[] byArray) {
        int n = 30;
        while (!PFBParser.byteCmp(byArray, n - CURRENTFILE_EEXEC.length, CURRENTFILE_EEXEC)) {
            ++n;
        }
        ++n;
        int n2 = 0;
        n2 -= CLEARTOMARK.length;
        while (!PFBParser.byteCmp(byArray, byArray.length + n2, CLEARTOMARK)) {
            --n2;
        }
        n2 = -n2;
        ++n2;
        int n3 = 0;
        byte[] byArray2 = new byte[]{13};
        byte[] byArray3 = new byte[]{10};
        byte[] byArray4 = new byte[]{48};
        while ((byArray[byArray.length - n2] == byArray2[0] || byArray[byArray.length - n2] == byArray3[0] || byArray[byArray.length - n2] == byArray4[0]) && n3 < 512) {
            if (byArray[byArray.length - ++n2] != byArray4[0]) continue;
            ++n3;
        }
        byte[] byArray5 = new byte[n];
        System.arraycopy(byArray, 0, byArray5, 0, n);
        pFBData.setHeaderSegment(byArray5);
        int n4 = byArray.length - n2 - n;
        byArray5 = new byte[n4];
        System.arraycopy(byArray, n, byArray5, 0, n4);
        pFBData.setEncryptedSegment(byArray5);
        byArray5 = new byte[n2];
        System.arraycopy(byArray, n + n4, byArray5, 0, n2);
        pFBData.setTrailerSegment(byArray5);
    }

    private void parseRAWFormat(PFBData pFBData, BufferedInputStream bufferedInputStream) throws IOException {
        this.calcLengths(pFBData, IOUtils.toByteArray((InputStream)bufferedInputStream));
    }

    static {
        try {
            CURRENTFILE_EEXEC = "currentfile eexec".getBytes("US-ASCII");
            CLEARTOMARK = "cleartomark".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Incompatible VM. It doesn't support the US-ASCII encoding");
        }
    }
}

