/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.transcoder.wmf.tosvg.WMFPainter;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.image.loader.batik.ImageWMF;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;

public class ImageConverterWMF2G2D
extends AbstractImageConverter {
    private static Log log = LogFactory.getLog(ImageConverterWMF2G2D.class);

    public Image convert(Image image, Map map) {
        this.checkSourceFlavor(image);
        ImageWMF imageWMF = (ImageWMF)image;
        Graphics2DImagePainterWMF graphics2DImagePainterWMF = new Graphics2DImagePainterWMF(imageWMF);
        ImageGraphics2D imageGraphics2D = new ImageGraphics2D(image.getInfo(), (Graphics2DImagePainter)graphics2DImagePainterWMF);
        return imageGraphics2D;
    }

    public ImageFlavor getSourceFlavor() {
        return ImageWMF.WMF_IMAGE;
    }

    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.GRAPHICS2D;
    }

    private static class Graphics2DImagePainterWMF
    implements Graphics2DImagePainter {
        private ImageWMF wmf;

        public Graphics2DImagePainterWMF(ImageWMF imageWMF) {
            this.wmf = imageWMF;
        }

        public Dimension getImageSize() {
            return this.wmf.getSize().getDimensionMpt();
        }

        public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            WMFRecordStore wMFRecordStore = this.wmf.getRecordStore();
            double d = rectangle2D.getWidth();
            double d2 = rectangle2D.getHeight();
            graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
            double d3 = d / (double)wMFRecordStore.getWidthPixels();
            double d4 = d2 / (double)wMFRecordStore.getHeightPixels();
            if (d3 != 1.0 || d4 != 1.0) {
                graphics2D.scale(d3, d4);
            }
            WMFPainter wMFPainter = new WMFPainter(wMFRecordStore, 1.0f);
            long l = System.currentTimeMillis();
            wMFPainter.paint((Graphics)graphics2D);
            if (log.isDebugEnabled()) {
                long l2 = System.currentTimeMillis() - l;
                log.debug((Object)("Painting WMF took " + l2 + " ms."));
            }
        }
    }
}

