/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.parser.UnitProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.image.loader.batik.BatikImageFlavors;
import org.apache.fop.svg.SimpleSVGUserAgent;
import org.apache.fop.util.UnclosableInputStream;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PreloaderSVG
extends AbstractImagePreloader {
    private static Log log = LogFactory.getLog(PreloaderSVG.class);
    private boolean batikAvailable = true;

    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) throws IOException {
        ImageInfo imageInfo = null;
        if (this.batikAvailable) {
            try {
                Loader loader = new Loader();
                if (!loader.isSupportedSource(source)) {
                    return null;
                }
                imageInfo = loader.getImage(string, source, imageContext);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.batikAvailable = false;
                log.warn((Object)"Batik not in class path", (Throwable)noClassDefFoundError);
                return null;
            }
        }
        if (imageInfo != null) {
            ImageUtil.closeQuietly((Source)source);
        }
        return imageInfo;
    }

    public static String getParserName() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            return sAXParserFactory.newSAXParser().getXMLReader().getClass().getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static double px2mpt(double d, double d2) {
        return d * 1000.0 * 72.0 / d2;
    }

    private final class Loader {
        private Loader() {
        }

        private ImageInfo getImage(String string, Source source, ImageContext imageContext) {
            InputStream inputStream = null;
            try {
                SVGDocument sVGDocument;
                DOMSource dOMSource;
                if (source instanceof DOMSource) {
                    dOMSource = (DOMSource)source;
                    sVGDocument = (SVGDocument)dOMSource.getNode();
                } else {
                    inputStream = new UnclosableInputStream(ImageUtil.needInputStream((Source)source));
                    int n = inputStream.available();
                    inputStream.mark(n + 1);
                    SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(PreloaderSVG.getParserName());
                    sVGDocument = sAXSVGDocumentFactory.createSVGDocument(source.getSystemId(), inputStream);
                }
                dOMSource = this.createImageInfo(string, imageContext, sVGDocument);
                return dOMSource;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (inputStream != null) {
                    try {
                        inputStream.reset();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                PreloaderSVG.this.batikAvailable = false;
                log.warn((Object)"Batik not in class path", (Throwable)noClassDefFoundError);
                return null;
            }
            catch (IOException iOException) {
                log.debug((Object)("Error while trying to load stream as an SVG file: " + iOException.getMessage()));
                try {
                    inputStream.reset();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return null;
            }
        }

        private ImageInfo createImageInfo(String string, ImageContext imageContext, SVGDocument sVGDocument) {
            SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
            float f = 25.4f / imageContext.getSourceResolution();
            SimpleSVGUserAgent simpleSVGUserAgent = new SimpleSVGUserAgent(f, new AffineTransform()){

                public void displayMessage(String string) {
                    log.debug((Object)string);
                }
            };
            BridgeContext bridgeContext = new BridgeContext((UserAgent)simpleSVGUserAgent);
            UnitProcessor.Context context = UnitProcessor.createContext((BridgeContext)bridgeContext, (Element)sVGSVGElement);
            String string2 = sVGSVGElement.getAttributeNS(null, "width");
            if (string2.length() == 0) {
                string2 = "100%";
            }
            float f2 = UnitProcessor.svgHorizontalLengthToUserSpace((String)string2, (String)"width", (UnitProcessor.Context)context);
            string2 = sVGSVGElement.getAttributeNS(null, "height");
            if (string2.length() == 0) {
                string2 = "100%";
            }
            float f3 = UnitProcessor.svgVerticalLengthToUserSpace((String)string2, (String)"height", (UnitProcessor.Context)context);
            int n = (int)Math.round(PreloaderSVG.px2mpt(f2, imageContext.getSourceResolution()));
            int n2 = (int)Math.round(PreloaderSVG.px2mpt(f3, imageContext.getSourceResolution()));
            ImageInfo imageInfo = new ImageInfo(string, "image/svg+xml");
            ImageSize imageSize = new ImageSize();
            imageSize.setSizeInMillipoints(n, n2);
            imageSize.setResolution((double)imageContext.getSourceResolution());
            imageSize.calcPixelsFromSize();
            imageInfo.setSize(imageSize);
            ImageXMLDOM imageXMLDOM = new ImageXMLDOM(imageInfo, (Document)sVGDocument, BatikImageFlavors.SVG_DOM);
            imageInfo.getCustomObjects().put(ImageInfo.ORIGINAL_IMAGE, imageXMLDOM);
            return imageInfo;
        }

        private boolean isSupportedSource(Source source) {
            if (source instanceof DOMSource) {
                DOMSource dOMSource = (DOMSource)source;
                return dOMSource.getNode() instanceof SVGDocument;
            }
            return ImageUtil.hasInputStream((Source)source);
        }
    }
}

