/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.Trait;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.properties.CommonAbsolutePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakOpportunity;
import org.apache.fop.layoutmgr.BreakOpportunityHelper;
import org.apache.fop.layoutmgr.ConditionalElementListener;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockContainerLayoutManager
extends BlockStackingLayoutManager
implements ConditionalElementListener,
BreakOpportunity {
    private static Log log = LogFactory.getLog(BlockContainerLayoutManager.class);
    private BlockViewport viewportBlockArea;
    private Block referenceArea;
    private CommonAbsolutePosition abProps;
    private FODimension relDims;
    private CTM absoluteCTM;
    private Length width;
    private Length height;
    private int vpContentBPD;
    private boolean autoHeight = true;
    private boolean inlineElementList = false;
    private MinOptMax foBlockSpaceBefore;
    private MinOptMax foBlockSpaceAfter;
    private boolean discardBorderBefore;
    private boolean discardBorderAfter;
    private boolean discardPaddingBefore;
    private boolean discardPaddingAfter;
    private MinOptMax effSpaceBefore;
    private MinOptMax effSpaceAfter;
    private int horizontalOverflow;
    private double contentRectOffsetX = 0.0;
    private double contentRectOffsetY = 0.0;

    public BlockContainerLayoutManager(BlockContainer blockContainer) {
        super(blockContainer);
    }

    @Override
    public void initialize() {
        this.abProps = this.getBlockContainerFO().getCommonAbsolutePosition();
        this.foBlockSpaceBefore = new SpaceVal(this.getBlockContainerFO().getCommonMarginBlock().spaceBefore, this).getSpace();
        this.foBlockSpaceAfter = new SpaceVal(this.getBlockContainerFO().getCommonMarginBlock().spaceAfter, this).getSpace();
        this.startIndent = this.getBlockContainerFO().getCommonMarginBlock().startIndent.getValue(this);
        this.endIndent = this.getBlockContainerFO().getCommonMarginBlock().endIndent.getValue(this);
        if (this.blockProgressionDirectionChanges()) {
            this.height = this.getBlockContainerFO().getInlineProgressionDimension().getOptimum(this).getLength();
            this.width = this.getBlockContainerFO().getBlockProgressionDimension().getOptimum(this).getLength();
        } else {
            this.height = this.getBlockContainerFO().getBlockProgressionDimension().getOptimum(this).getLength();
            this.width = this.getBlockContainerFO().getInlineProgressionDimension().getOptimum(this).getLength();
        }
        this.adjustedSpaceBefore = this.getBlockContainerFO().getCommonMarginBlock().spaceBefore.getSpace().getOptimum(this).getLength().getValue(this);
        this.adjustedSpaceAfter = this.getBlockContainerFO().getCommonMarginBlock().spaceAfter.getSpace().getOptimum(this).getLength().getValue(this);
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    protected int getRotatedIPD() {
        return this.getBlockContainerFO().getInlineProgressionDimension().getOptimum(this).getLength().getValue(this);
    }

    private boolean needClip() {
        int n = this.getBlockContainerFO().getOverflow();
        return n == 57 || n == 42;
    }

    private int getBPIndents() {
        int n = 0;
        return n += this.getBlockContainerFO().getCommonBorderPaddingBackground().getBPPaddingAndBorder(false, this);
    }

    private boolean isAbsoluteOrFixed() {
        return this.abProps.absolutePosition == 1 || this.abProps.absolutePosition == 51;
    }

    private boolean isFixed() {
        return this.abProps.absolutePosition == 51;
    }

    @Override
    public int getContentAreaBPD() {
        if (this.autoHeight) {
            return -1;
        }
        return this.vpContentBPD;
    }

    @Override
    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        return this.getNextKnuthElements(layoutContext, n, null, null, null);
    }

    @Override
    protected LayoutContext makeChildLayoutContext(LayoutContext layoutContext) {
        LayoutContext layoutContext2 = new LayoutContext(0);
        layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP().minus(MinOptMax.getInstance(this.relDims.bpd)));
        layoutContext2.setRefIPD(this.relDims.ipd);
        layoutContext2.setWritingMode(this.getBlockContainerFO().getWritingMode());
        return layoutContext2;
    }

    @Override
    public List getNextKnuthElements(LayoutContext layoutContext, int n, Stack stack, Position position, LayoutManager layoutManager) {
        this.resetSpaces();
        if (this.isAbsoluteOrFixed()) {
            return this.getNextKnuthElementsAbsolute(layoutContext);
        }
        boolean bl = stack != null;
        boolean bl2 = !bl || stack.isEmpty();
        this.setupAreaDimensions(layoutContext);
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        LinkedList<ListElement> linkedList2 = new LinkedList<ListElement>();
        if (!this.breakBeforeServed(layoutContext, linkedList2)) {
            return linkedList2;
        }
        this.addFirstVisibleMarks(linkedList2, layoutContext, n);
        if (this.autoHeight && this.inlineElementList) {
            LayoutManager layoutManager2;
            LayoutManager layoutManager3 = null;
            if (bl) {
                if (bl2) {
                    assert (layoutManager != null && layoutManager.getParent() == this);
                    layoutManager2 = layoutManager;
                } else {
                    layoutManager2 = (LayoutManager)stack.pop();
                }
                this.setCurrentChildLM(layoutManager2);
            } else {
                layoutManager2 = this.getChildLM();
            }
            while (layoutManager2 != null) {
                List<ListElement> list;
                LayoutContext layoutContext2 = this.makeChildLayoutContext(layoutContext);
                if (!bl || bl2) {
                    if (bl) {
                        layoutManager2.reset();
                    }
                    list = this.getNextChildElements(layoutManager2, layoutContext, layoutContext2, n, null, null, null);
                } else {
                    list = this.getNextChildElements(layoutManager2, layoutContext, layoutContext2, n, stack, position, layoutManager);
                    bl2 = true;
                }
                if (linkedList.isEmpty() && layoutContext2.isKeepWithPreviousPending()) {
                    layoutContext.updateKeepWithPreviousPending(layoutContext2.getKeepWithPreviousPending());
                    layoutContext2.clearKeepWithPreviousPending();
                }
                if (list.size() == 1 && ElementListUtils.startsWithForcedBreak(list)) {
                    linkedList.addAll(list);
                    this.wrapPositionElements(linkedList, linkedList2);
                    return linkedList2;
                }
                if (layoutManager3 != null) {
                    this.addInBetweenBreak(linkedList, layoutContext, layoutContext2);
                }
                linkedList.addAll(list);
                if (list.isEmpty()) continue;
                if (ElementListUtils.endsWithForcedBreak(list)) {
                    if (layoutManager2.isFinished() && !this.hasNextChildLM()) {
                        this.setFinished(true);
                    }
                    this.wrapPositionElements(linkedList, linkedList2);
                    return linkedList2;
                }
                layoutContext.updateKeepWithNextPending(layoutContext2.getKeepWithNextPending());
                layoutContext2.clearKeepsPending();
                layoutManager3 = layoutManager2;
                layoutManager2 = this.getChildLM();
            }
            this.wrapPositionElements(linkedList, linkedList2);
        } else {
            linkedList2.add(this.generateNonInlinedBox());
        }
        this.addLastVisibleMarks(linkedList2, layoutContext, n);
        this.addKnuthElementsForBreakAfter(linkedList2, layoutContext);
        layoutContext.updateKeepWithNextPending(this.getKeepWithNext());
        this.setFinished(true);
        return linkedList2;
    }

    private void setupAreaDimensions(LayoutContext layoutContext) {
        int n;
        int n2;
        this.autoHeight = false;
        int n3 = layoutContext.getStackLimitBP().getOpt();
        BlockContainer blockContainer = this.getBlockContainerFO();
        if (this.height.getEnum() == 9 || !this.height.isAbsolute() && this.getAncestorBlockAreaBPD() <= 0) {
            n2 = n3;
            this.autoHeight = true;
            this.inlineElementList = blockContainer.getReferenceOrientation() == 0;
        } else {
            n2 = this.height.getValue(this);
            n2 += this.getBPIndents();
        }
        this.vpContentBPD = n2 - this.getBPIndents();
        this.referenceIPD = layoutContext.getRefIPD();
        if (this.width.getEnum() == 9) {
            this.updateContentAreaIPDwithOverconstrainedAdjust();
        } else {
            n = this.width.getValue(this);
            this.updateContentAreaIPDwithOverconstrainedAdjust(n);
        }
        this.contentRectOffsetX = 0.0;
        this.contentRectOffsetY = 0.0;
        n = blockContainer.getBidiLevel();
        this.contentRectOffsetX = n < 0 || (n & 1) == 0 ? (this.contentRectOffsetX += (double)blockContainer.getCommonMarginBlock().startIndent.getValue(this)) : (this.contentRectOffsetX += (double)blockContainer.getCommonMarginBlock().endIndent.getValue(this));
        this.contentRectOffsetY += (double)blockContainer.getCommonBorderPaddingBackground().getBorderBeforeWidth(false);
        this.contentRectOffsetY += (double)blockContainer.getCommonBorderPaddingBackground().getPaddingBefore(false, this);
        this.updateRelDims();
        int n4 = this.referenceIPD - this.getIPIndents();
        if (this.getContentAreaIPD() > n4) {
            BlockLevelEventProducer blockLevelEventProducer = BlockLevelEventProducer.Provider.get(blockContainer.getUserAgent().getEventBroadcaster());
            blockLevelEventProducer.objectTooWide(this, blockContainer.getName(), this.getContentAreaIPD(), layoutContext.getRefIPD(), blockContainer.getLocator());
        }
    }

    private KnuthBox generateNonInlinedBox() {
        MinOptMax minOptMax = MinOptMax.getInstance(this.relDims.ipd);
        BlockContainerBreaker blockContainerBreaker = new BlockContainerBreaker(this, minOptMax);
        blockContainerBreaker.doLayout(this.relDims.bpd, this.autoHeight);
        boolean bl = blockContainerBreaker.isOverflow();
        if (this.autoHeight) {
            int n = ((BlockContainerBreaker)blockContainerBreaker).deferredAlg.totalWidth;
            if (this.blockProgressionDirectionChanges()) {
                this.setContentAreaIPD(n);
            } else {
                this.vpContentBPD = n;
            }
            this.updateRelDims();
        }
        BlockContainerPosition blockContainerPosition = new BlockContainerPosition(this, blockContainerBreaker);
        KnuthBox knuthBox = new KnuthBox(this.vpContentBPD, this.notifyPos(blockContainerPosition), false);
        if (bl) {
            BlockLevelEventProducer blockLevelEventProducer = BlockLevelEventProducer.Provider.get(this.getBlockContainerFO().getUserAgent().getEventBroadcaster());
            boolean bl2 = this.getBlockContainerFO().getOverflow() != 42;
            blockLevelEventProducer.viewportBPDOverflow(this, this.getBlockContainerFO().getName(), blockContainerBreaker.getOverflowAmount(), this.needClip(), bl2, this.getBlockContainerFO().getLocator());
        }
        return knuthBox;
    }

    private boolean blockProgressionDirectionChanges() {
        return this.getBlockContainerFO().getReferenceOrientation() % 180 != 0;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    private List<ListElement> getNextKnuthElementsAbsolute(LayoutContext layoutContext) {
        int n;
        int n2;
        int n3;
        this.autoHeight = false;
        boolean bl = this.blockProgressionDirectionChanges();
        Point point = this.getAbsOffset();
        if (this.height.getEnum() == 9 || !this.height.isAbsolute() && this.getAncestorBlockAreaBPD() <= 0) {
            n3 = 0;
            if (this.abProps.bottom.getEnum() != 9) {
                n2 = this.isFixed() ? (int)this.getCurrentPV().getViewArea().getHeight() : layoutContext.getStackLimitBP().getOpt();
                n3 = n2;
                n3 -= point.y;
                if (this.abProps.bottom.getEnum() != 9) {
                    if ((n3 -= this.abProps.bottom.getValue(this)) < 0) {
                        n3 = 0;
                    }
                } else if (n3 < 0) {
                    n3 = 0;
                }
            } else {
                n3 = layoutContext.getStackLimitBP().getOpt();
                if (!bl) {
                    this.autoHeight = true;
                }
            }
        } else {
            n3 = this.height.getValue(this);
            n3 += this.getBPIndents();
        }
        if (this.width.getEnum() == 9) {
            n2 = this.isFixed() ? (int)this.getCurrentPV().getViewArea().getWidth() : layoutContext.getRefIPD();
            n = n2;
            if (this.abProps.left.getEnum() != 9) {
                n -= this.abProps.left.getValue(this);
            }
            if (this.abProps.right.getEnum() != 9) {
                if ((n -= this.abProps.right.getValue(this)) < 0) {
                    n = 0;
                }
            } else {
                if (n < 0) {
                    n = 0;
                }
                if (bl) {
                    this.autoHeight = true;
                }
            }
        } else {
            n = this.width.getValue(this);
            n += this.getIPIndents();
        }
        this.vpContentBPD = n3 - this.getBPIndents();
        this.setContentAreaIPD(n - this.getIPIndents());
        this.contentRectOffsetX = 0.0;
        this.contentRectOffsetY = 0.0;
        this.updateRelDims();
        MinOptMax minOptMax = MinOptMax.getInstance(this.relDims.ipd);
        BlockContainerBreaker blockContainerBreaker = new BlockContainerBreaker(this, minOptMax);
        blockContainerBreaker.doLayout(this.autoHeight ? 0 : this.relDims.bpd, this.autoHeight);
        boolean bl2 = blockContainerBreaker.isOverflow();
        if (this.autoHeight) {
            int n4 = ((BlockContainerBreaker)blockContainerBreaker).deferredAlg.totalWidth;
            if (bl) {
                this.setContentAreaIPD(n4);
            } else {
                this.vpContentBPD = n4;
            }
            this.updateRelDims();
        }
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        if (!blockContainerBreaker.isEmpty()) {
            boolean bl3;
            BlockLevelEventProducer blockLevelEventProducer;
            BlockContainerPosition blockContainerPosition = new BlockContainerPosition(this, blockContainerBreaker);
            linkedList.add(new KnuthBox(0, this.notifyPos(blockContainerPosition), false));
            if (!this.autoHeight & bl2) {
                blockLevelEventProducer = BlockLevelEventProducer.Provider.get(this.getBlockContainerFO().getUserAgent().getEventBroadcaster());
                bl3 = this.getBlockContainerFO().getOverflow() != 42;
                blockLevelEventProducer.viewportBPDOverflow(this, this.getBlockContainerFO().getName(), blockContainerBreaker.getOverflowAmount(), this.needClip(), bl3, this.getBlockContainerFO().getLocator());
            }
            if (this.horizontalOverflow > 0) {
                blockLevelEventProducer = BlockLevelEventProducer.Provider.get(this.getBlockContainerFO().getUserAgent().getEventBroadcaster());
                bl3 = this.getBlockContainerFO().getOverflow() != 42;
                blockLevelEventProducer.viewportIPDOverflow(this, this.getBlockContainerFO().getName(), this.horizontalOverflow, this.needClip(), bl3, this.getBlockContainerFO().getLocator());
            }
        }
        this.setFinished(true);
        return linkedList;
    }

    private void updateRelDims() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.contentRectOffsetX, this.contentRectOffsetY, this.getContentAreaIPD(), this.vpContentBPD);
        this.relDims = new FODimension(0, 0);
        this.absoluteCTM = CTM.getCTMandRelDims(this.getBlockContainerFO().getReferenceOrientation(), this.getBlockContainerFO().getWritingMode(), double_, this.relDims);
    }

    private Point getAbsOffset() {
        int n = 0;
        int n2 = 0;
        if (this.abProps.left.getEnum() != 9) {
            n = this.abProps.left.getValue(this);
        } else if (this.abProps.right.getEnum() != 9 && this.width.getEnum() != 9) {
            n = this.getReferenceAreaIPD() - this.abProps.right.getValue(this) - this.width.getValue(this);
        }
        if (this.abProps.top.getEnum() != 9) {
            n2 = this.abProps.top.getValue(this);
        } else if (this.abProps.bottom.getEnum() != 9 && this.height.getEnum() != 9) {
            n2 = this.getReferenceAreaBPD() - this.abProps.bottom.getValue(this) - this.height.getValue(this);
        }
        return new Point(n, n2);
    }

    @Override
    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        this.getParentArea(null);
        if (layoutContext.getSpaceBefore() > 0) {
            this.addBlockSpacing(0.0, MinOptMax.getInstance(layoutContext.getSpaceBefore()));
        }
        LayoutManager layoutManager = null;
        LayoutContext layoutContext2 = new LayoutContext(0);
        layoutContext2.setSpaceAdjust(layoutContext.getSpaceAdjust());
        if (layoutContext.getSpaceAfter() > 0) {
            layoutContext2.setSpaceAfter(layoutContext.getSpaceAfter());
        }
        BlockContainerPosition blockContainerPosition = null;
        LinkedList<Position> linkedList = new LinkedList<Position>();
        Position position = null;
        Position position2 = null;
        while (positionIterator.hasNext()) {
            Position position3 = positionIterator.next();
            if (position3.getIndex() >= 0) {
                if (position == null) {
                    position = position3;
                }
                position2 = position3;
            }
            Position position4 = position3;
            if (position3 instanceof NonLeafPosition) {
                position4 = position3.getPosition();
            }
            if (position3 instanceof BlockContainerPosition) {
                if (blockContainerPosition != null) {
                    throw new IllegalStateException("Only one BlockContainerPosition allowed");
                }
                blockContainerPosition = (BlockContainerPosition)position3;
                continue;
            }
            if (position4 == null || position4.getLM() == this && !(position4 instanceof BlockStackingLayoutManager.MappingPosition)) continue;
            linkedList.add(position4);
            layoutManager = position4.getLM();
        }
        this.addId();
        this.addMarkersToPage(true, this.isFirst(position), this.isLast(position2));
        if (blockContainerPosition == null) {
            LayoutManager layoutManager2;
            PositionIterator positionIterator2 = new PositionIterator(linkedList.listIterator());
            while ((layoutManager2 = positionIterator2.getNextChildLM()) != null) {
                layoutContext2.setFlags(128, layoutContext.isLastArea() && layoutManager2 == layoutManager);
                layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
                layoutManager2.addAreas(positionIterator2, layoutContext2);
            }
        } else {
            blockContainerPosition.getBreaker().addContainedAreas();
        }
        this.addMarkersToPage(false, this.isFirst(position), this.isLast(position2));
        TraitSetter.addSpaceBeforeAfter(this.viewportBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        this.flush();
        this.viewportBlockArea = null;
        this.referenceArea = null;
        this.resetSpaces();
        this.notifyEndOfLayout();
    }

    @Override
    public Area getParentArea(Area area) {
        if (this.referenceArea == null) {
            boolean bl = this.blockProgressionDirectionChanges();
            boolean bl2 = this.autoHeight && !bl;
            int n = this.getBlockContainerFO().getBidiLevel();
            this.viewportBlockArea = new BlockViewport(bl2);
            this.viewportBlockArea.addTrait(Trait.IS_VIEWPORT_AREA, Boolean.TRUE);
            if (n >= 0) {
                this.viewportBlockArea.setBidiLevel(n);
            }
            this.viewportBlockArea.setIPD(this.getContentAreaIPD());
            if (bl2) {
                this.viewportBlockArea.setBPD(0);
            } else {
                this.viewportBlockArea.setBPD(this.vpContentBPD);
            }
            this.transferForeignAttributes(this.viewportBlockArea);
            TraitSetter.setProducerID(this.viewportBlockArea, this.getBlockContainerFO().getId());
            TraitSetter.addBorders(this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, this);
            TraitSetter.addPadding(this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, this);
            TraitSetter.addMargins(this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), this.startIndent, this.endIndent, this);
            this.viewportBlockArea.setCTM(this.absoluteCTM);
            this.viewportBlockArea.setClip(this.needClip());
            if (this.abProps.absolutePosition == 1 || this.abProps.absolutePosition == 51) {
                Point point = this.getAbsOffset();
                this.viewportBlockArea.setXOffset(point.x);
                this.viewportBlockArea.setYOffset(point.y);
            }
            this.referenceArea = new Block();
            this.referenceArea.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
            if (n >= 0) {
                this.referenceArea.setBidiLevel(n);
            }
            TraitSetter.setProducerID(this.referenceArea, this.getBlockContainerFO().getId());
            if (this.abProps.absolutePosition == 1) {
                this.viewportBlockArea.setPositioning(2);
            } else if (this.abProps.absolutePosition == 51) {
                this.viewportBlockArea.setPositioning(3);
            }
            this.parentLayoutManager.getParentArea(this.referenceArea);
            this.referenceArea.setIPD(this.relDims.ipd);
            this.setCurrentArea(this.viewportBlockArea);
        }
        return this.referenceArea;
    }

    @Override
    public void addChildArea(Area area) {
        if (this.referenceArea != null) {
            this.referenceArea.addBlock((Block)area);
        }
    }

    @Override
    protected void flush() {
        this.viewportBlockArea.addBlock(this.referenceArea, this.autoHeight);
        TraitSetter.addBackground(this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), this);
        super.flush();
    }

    @Override
    public int negotiateBPDAdjustment(int n, KnuthElement knuthElement) {
        return 0;
    }

    @Override
    public void discardSpace(KnuthGlue knuthGlue) {
    }

    @Override
    public KeepProperty getKeepTogetherProperty() {
        return this.getBlockContainerFO().getKeepTogether();
    }

    @Override
    public KeepProperty getKeepWithPreviousProperty() {
        return this.getBlockContainerFO().getKeepWithPrevious();
    }

    @Override
    public KeepProperty getKeepWithNextProperty() {
        return this.getBlockContainerFO().getKeepWithNext();
    }

    protected BlockContainer getBlockContainerFO() {
        return (BlockContainer)this.fobj;
    }

    @Override
    public boolean getGeneratesReferenceArea() {
        return true;
    }

    @Override
    public boolean getGeneratesBlockArea() {
        return true;
    }

    @Override
    public void notifySpace(RelSide relSide, MinOptMax minOptMax) {
        if (RelSide.BEFORE == relSide) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + relSide + ", " + this.effSpaceBefore + "-> " + minOptMax));
            }
            this.effSpaceBefore = minOptMax;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + relSide + ", " + this.effSpaceAfter + "-> " + minOptMax));
            }
            this.effSpaceAfter = minOptMax;
        }
    }

    @Override
    public void notifyBorder(RelSide relSide, MinOptMax minOptMax) {
        if (minOptMax == null) {
            if (RelSide.BEFORE == relSide) {
                this.discardBorderBefore = true;
            } else {
                this.discardBorderAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Border " + relSide + " -> " + minOptMax));
        }
    }

    @Override
    public void notifyPadding(RelSide relSide, MinOptMax minOptMax) {
        if (minOptMax == null) {
            if (RelSide.BEFORE == relSide) {
                this.discardPaddingBefore = true;
            } else {
                this.discardPaddingAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Padding " + relSide + " -> " + minOptMax));
        }
    }

    @Override
    public boolean handleOverflow(int n) {
        if (n > this.horizontalOverflow) {
            this.horizontalOverflow = n;
        }
        return true;
    }

    @Override
    public int getBreakBefore() {
        return BreakOpportunityHelper.getBreakBefore(this);
    }

    private class BlockContainerBreaker
    extends AbstractBreaker {
        private BlockContainerLayoutManager bclm;
        private MinOptMax ipd;
        private PageBreakingAlgorithm deferredAlg;
        private AbstractBreaker.BlockSequence deferredOriginalList;
        private AbstractBreaker.BlockSequence deferredEffectiveList;

        public BlockContainerBreaker(BlockContainerLayoutManager blockContainerLayoutManager2, MinOptMax minOptMax) {
            this.bclm = blockContainerLayoutManager2;
            this.ipd = minOptMax;
        }

        protected void observeElementList(List list) {
            ElementListObserver.observe(list, "block-container", this.bclm.getBlockContainerFO().getId());
        }

        protected boolean isPartOverflowRecoveryActivated() {
            return false;
        }

        protected boolean isSinglePartFavored() {
            return true;
        }

        public int getDifferenceOfFirstPart() {
            AbstractBreaker.PageBreakPosition pageBreakPosition = this.deferredAlg.getPageBreaks().getFirst();
            return pageBreakPosition.difference;
        }

        public boolean isOverflow() {
            return !this.isEmpty() && (this.deferredAlg.getPageBreaks().size() > 1 || this.deferredAlg.totalWidth - this.deferredAlg.totalShrink > this.deferredAlg.getLineWidth());
        }

        public int getOverflowAmount() {
            return this.deferredAlg.totalWidth - this.deferredAlg.totalShrink - this.deferredAlg.getLineWidth();
        }

        protected LayoutManager getTopLevelLM() {
            return this.bclm;
        }

        protected LayoutContext createLayoutContext() {
            LayoutContext layoutContext = super.createLayoutContext();
            layoutContext.setRefIPD(this.ipd.getOpt());
            layoutContext.setWritingMode(BlockContainerLayoutManager.this.getBlockContainerFO().getWritingMode());
            return layoutContext;
        }

        protected List getNextKnuthElements(LayoutContext layoutContext, int n) {
            LayoutManager layoutManager;
            LinkedList linkedList = new LinkedList();
            while ((layoutManager = BlockContainerLayoutManager.this.getChildLM()) != null) {
                LayoutContext layoutContext2 = BlockContainerLayoutManager.this.makeChildLayoutContext(layoutContext);
                List list = null;
                if (!layoutManager.isFinished()) {
                    list = layoutManager.getNextKnuthElements(layoutContext2, n);
                }
                if (list == null) continue;
                this.bclm.wrapPositionElements(list, linkedList);
            }
            SpaceResolver.resolveElementList(linkedList);
            BlockContainerLayoutManager.this.setFinished(true);
            return linkedList;
        }

        protected int getCurrentDisplayAlign() {
            return BlockContainerLayoutManager.this.getBlockContainerFO().getDisplayAlign();
        }

        protected boolean hasMoreContent() {
            return !BlockContainerLayoutManager.this.isFinished();
        }

        protected void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
            AreaAdditionUtil.addAreas(this.bclm, positionIterator, layoutContext);
        }

        protected void doPhase3(PageBreakingAlgorithm pageBreakingAlgorithm, int n, AbstractBreaker.BlockSequence blockSequence, AbstractBreaker.BlockSequence blockSequence2) {
            this.deferredAlg = pageBreakingAlgorithm;
            this.deferredOriginalList = blockSequence;
            this.deferredEffectiveList = blockSequence2;
        }

        protected void finishPart(PageBreakingAlgorithm pageBreakingAlgorithm, AbstractBreaker.PageBreakPosition pageBreakPosition) {
        }

        protected LayoutManager getCurrentChildLM() {
            return BlockContainerLayoutManager.this.curChildLM;
        }

        public void addContainedAreas() {
            if (this.isEmpty()) {
                return;
            }
            this.deferredAlg.removeAllPageBreaks();
            this.addAreas(this.deferredAlg, this.deferredAlg.getPageBreaks().size(), this.deferredOriginalList, this.deferredEffectiveList);
        }
    }

    private class BlockContainerPosition
    extends NonLeafPosition {
        private BlockContainerBreaker breaker;

        public BlockContainerPosition(LayoutManager layoutManager, BlockContainerBreaker blockContainerBreaker) {
            super(layoutManager, null);
            this.breaker = blockContainerBreaker;
        }

        public BlockContainerBreaker getBreaker() {
            return this.breaker;
        }
    }
}

