/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.LineArea;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakOpportunity;
import org.apache.fop.layoutmgr.BreakOpportunityHelper;
import org.apache.fop.layoutmgr.ConditionalElementListener;
import org.apache.fop.layoutmgr.LMiter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.LineLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockLayoutManager
extends BlockStackingLayoutManager
implements ConditionalElementListener,
BreakOpportunity {
    private static Log log = LogFactory.getLog(BlockLayoutManager.class);
    private Block curBlockArea;
    protected ListIterator<LayoutManager> proxyLMiter = new ProxyLMiter();
    private int lead = 12000;
    private Length lineHeight;
    private int follow = 2000;
    private boolean discardBorderBefore;
    private boolean discardBorderAfter;
    private boolean discardPaddingBefore;
    private boolean discardPaddingAfter;
    private MinOptMax effSpaceBefore;
    private MinOptMax effSpaceAfter;

    public BlockLayoutManager(org.apache.fop.fo.flow.Block block) {
        super(block);
    }

    @Override
    public void initialize() {
        super.initialize();
        org.apache.fop.fo.flow.Block block = this.getBlockFO();
        FontInfo fontInfo = block.getFOEventHandler().getFontInfo();
        FontTriplet[] fontTripletArray = block.getCommonFont().getFontState(fontInfo);
        Font font = fontInfo.getFontInstance(fontTripletArray[0], this.getBlockFO().getCommonFont().fontSize.getValue(this));
        this.lead = font.getAscender();
        this.follow = -font.getDescender();
        this.lineHeight = block.getLineHeight().getOptimum(this).getLength();
        this.startIndent = block.getCommonMarginBlock().startIndent.getValue(this);
        this.endIndent = block.getCommonMarginBlock().endIndent.getValue(this);
        this.foSpaceBefore = new SpaceVal(block.getCommonMarginBlock().spaceBefore, this).getSpace();
        this.foSpaceAfter = new SpaceVal(block.getCommonMarginBlock().spaceAfter, this).getSpace();
        this.adjustedSpaceBefore = block.getCommonMarginBlock().spaceBefore.getSpace().getOptimum(this).getLength().getValue(this);
        this.adjustedSpaceAfter = block.getCommonMarginBlock().spaceAfter.getSpace().getOptimum(this).getLength().getValue(this);
    }

    @Override
    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        return this.getNextKnuthElements(layoutContext, n, null, null, null);
    }

    @Override
    public List getNextKnuthElements(LayoutContext layoutContext, int n, Stack stack, Position position, LayoutManager layoutManager) {
        this.resetSpaces();
        return super.getNextKnuthElements(layoutContext, n, stack, position, layoutManager);
    }

    protected List<ListElement> getNextChildElements(LayoutManager layoutManager, LayoutContext layoutContext, LayoutContext layoutContext2, int n, Stack stack, Position position, LayoutManager layoutManager2) {
        layoutContext2.copyPendingMarksFrom(layoutContext);
        if (layoutManager instanceof LineLayoutManager) {
            layoutContext2.setRefIPD(this.getContentAreaIPD());
        }
        if (layoutManager == this.childLMs.get(0)) {
            layoutContext2.setFlags(16);
        }
        if (stack == null) {
            return layoutManager.getNextKnuthElements(layoutContext2, n);
        }
        if (layoutManager instanceof LineLayoutManager) {
            assert (position instanceof LeafPosition);
            return ((LineLayoutManager)layoutManager).getNextKnuthElements(layoutContext2, n, (LeafPosition)position);
        }
        return layoutManager.getNextKnuthElements(layoutContext2, n, stack, position, layoutManager2);
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    @Override
    public boolean createNextChildLMs(int n) {
        while (this.proxyLMiter.hasNext()) {
            LayoutManager layoutManager = this.proxyLMiter.next();
            if (layoutManager instanceof InlineLevelLayoutManager) {
                LineLayoutManager lineLayoutManager = this.createLineManager(layoutManager);
                this.addChildLM(lineLayoutManager);
            } else {
                this.addChildLM(layoutManager);
            }
            if (n >= this.childLMs.size()) continue;
            return true;
        }
        return false;
    }

    private LineLayoutManager createLineManager(LayoutManager layoutManager) {
        LineLayoutManager lineLayoutManager = new LineLayoutManager(this.getBlockFO(), this.lineHeight, this.lead, this.follow);
        ArrayList<LayoutManager> arrayList = new ArrayList<LayoutManager>();
        arrayList.add(layoutManager);
        while (this.proxyLMiter.hasNext()) {
            LayoutManager layoutManager2 = this.proxyLMiter.next();
            if (layoutManager2 instanceof InlineLevelLayoutManager) {
                arrayList.add(layoutManager2);
                continue;
            }
            this.proxyLMiter.previous();
            break;
        }
        lineLayoutManager.addChildLMs(arrayList);
        return lineLayoutManager;
    }

    @Override
    public KeepProperty getKeepTogetherProperty() {
        return this.getBlockFO().getKeepTogether();
    }

    @Override
    public KeepProperty getKeepWithPreviousProperty() {
        return this.getBlockFO().getKeepWithPrevious();
    }

    @Override
    public KeepProperty getKeepWithNextProperty() {
        return this.getBlockFO().getKeepWithNext();
    }

    @Override
    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        LayoutManager layoutManager;
        this.getParentArea(null);
        if (layoutContext.getSpaceBefore() > 0) {
            this.addBlockSpacing(0.0, MinOptMax.getInstance(layoutContext.getSpaceBefore()));
        }
        LayoutManager layoutManager2 = null;
        LayoutContext layoutContext2 = new LayoutContext(0);
        layoutContext2.setSpaceAdjust(layoutContext.getSpaceAdjust());
        if (layoutContext.getSpaceAfter() > 0) {
            layoutContext2.setSpaceAfter(layoutContext.getSpaceAfter());
        }
        LinkedList<Position> linkedList = new LinkedList<Position>();
        Position position = null;
        Position position2 = null;
        while (positionIterator.hasNext()) {
            Position position3 = positionIterator.next();
            if (position3.getIndex() >= 0) {
                if (position == null) {
                    position = position3;
                }
                position2 = position3;
            }
            Position position4 = position3;
            if (position3 instanceof NonLeafPosition) {
                position4 = position3.getPosition();
            }
            if (position4 == null || position4.getLM() == this && !(position4 instanceof BlockStackingLayoutManager.MappingPosition)) continue;
            linkedList.add(position4);
            layoutManager2 = position4.getLM();
        }
        this.addId();
        this.addMarkersToPage(true, this.isFirst(position), this.isLast(position2));
        PositionIterator positionIterator2 = new PositionIterator(linkedList.listIterator());
        while ((layoutManager = positionIterator2.getNextChildLM()) != null) {
            layoutContext2.setFlags(128, layoutContext.isLastArea() && layoutManager == layoutManager2);
            layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
            layoutManager.addAreas(positionIterator2, layoutContext2);
        }
        this.addMarkersToPage(false, this.isFirst(position), this.isLast(position2));
        TraitSetter.addSpaceBeforeAfter(this.curBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        this.flush();
        this.curBlockArea = null;
        this.resetSpaces();
        this.checkEndOfLayout(position2);
    }

    @Override
    public Area getParentArea(Area area) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.setIPD(super.getContentAreaIPD());
            this.curBlockArea.setBidiLevel(this.getBlockFO().getBidiLevel());
            TraitSetter.addBreaks(this.curBlockArea, this.getBlockFO().getBreakBefore(), this.getBlockFO().getBreakAfter());
            this.parentLayoutManager.getParentArea(this.curBlockArea);
            TraitSetter.setProducerID(this.curBlockArea, this.getBlockFO().getId());
            TraitSetter.addBorders(this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, this);
            TraitSetter.addPadding(this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, this);
            TraitSetter.addMargins(this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground(), this.startIndent, this.endIndent, this);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    @Override
    public void addChildArea(Area area) {
        if (this.curBlockArea != null) {
            if (area instanceof LineArea) {
                this.curBlockArea.addLineArea((LineArea)area);
            } else {
                this.curBlockArea.addBlock((Block)area);
            }
        }
    }

    @Override
    protected void flush() {
        if (this.curBlockArea != null) {
            TraitSetter.addBackground(this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground(), this);
            super.flush();
        }
    }

    protected org.apache.fop.fo.flow.Block getBlockFO() {
        return (org.apache.fop.fo.flow.Block)this.fobj;
    }

    @Override
    public int getContentAreaIPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getIPD();
        }
        return super.getContentAreaIPD();
    }

    @Override
    public int getContentAreaBPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getBPD();
        }
        return -1;
    }

    @Override
    public boolean getGeneratesBlockArea() {
        return true;
    }

    @Override
    public void notifySpace(RelSide relSide, MinOptMax minOptMax) {
        if (RelSide.BEFORE == relSide) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + relSide + ", " + this.effSpaceBefore + "-> " + minOptMax));
            }
            this.effSpaceBefore = minOptMax;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + relSide + ", " + this.effSpaceAfter + "-> " + minOptMax));
            }
            this.effSpaceAfter = minOptMax;
        }
    }

    @Override
    public void notifyBorder(RelSide relSide, MinOptMax minOptMax) {
        if (minOptMax == null) {
            if (RelSide.BEFORE == relSide) {
                this.discardBorderBefore = true;
            } else {
                this.discardBorderAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Border " + relSide + " -> " + minOptMax));
        }
    }

    @Override
    public void notifyPadding(RelSide relSide, MinOptMax minOptMax) {
        if (minOptMax == null) {
            if (RelSide.BEFORE == relSide) {
                this.discardPaddingBefore = true;
            } else {
                this.discardPaddingAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Padding " + relSide + " -> " + minOptMax));
        }
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public int getBreakBefore() {
        return BreakOpportunityHelper.getBreakBefore(this);
    }

    protected class ProxyLMiter
    extends LMiter {
        public ProxyLMiter() {
            super(BlockLayoutManager.this);
            this.listLMs = new ArrayList(10);
        }

        public boolean hasNext() {
            return this.curPos < this.listLMs.size() || this.createNextChildLMs(this.curPos);
        }

        protected boolean createNextChildLMs(int n) {
            List<LayoutManager> list = BlockLayoutManager.this.createChildLMs(n + 1 - this.listLMs.size());
            if (list != null) {
                this.listLMs.addAll(list);
            }
            return n < this.listLMs.size();
        }
    }
}

