/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.area.Block;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.CTM;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.extensions.ExternalDocument;
import org.apache.fop.layoutmgr.AbstractPageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.ImageLayout;
import org.apache.fop.traits.WritingMode;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class ExternalDocumentLayoutManager
extends AbstractPageSequenceLayoutManager {
    private static Log log = LogFactory.getLog(ExternalDocumentLayoutManager.class);
    private ImageLayout imageLayout;

    public ExternalDocumentLayoutManager(AreaTreeHandler areaTreeHandler, ExternalDocument externalDocument) {
        super(areaTreeHandler, externalDocument);
    }

    protected ExternalDocument getExternalDocument() {
        return (ExternalDocument)this.pageSeq;
    }

    public PageSequenceLayoutManager getPSLM() {
        throw new IllegalStateException("getPSLM() is illegal for " + this.getClass().getName());
    }

    public void activateLayout() {
        block10: {
            this.initialize();
            FOUserAgent fOUserAgent = this.pageSeq.getUserAgent();
            ImageManager imageManager = fOUserAgent.getFactory().getImageManager();
            String string = URISpecification.getURL(this.getExternalDocument().getSrc());
            Integer n = ImageUtil.getPageIndexFromURI((String)string);
            boolean bl = n != null;
            try {
                ImageInfo imageInfo = imageManager.getImageInfo(string, fOUserAgent.getImageSessionContext());
                Object v = imageInfo.getCustomObjects().get(ImageInfo.HAS_MORE_IMAGES);
                boolean bl2 = v != null && !Boolean.FALSE.equals(v);
                Dimension dimension = imageInfo.getSize().getDimensionMpt();
                ImageLayout imageLayout = new ImageLayout(this.getExternalDocument(), this, dimension);
                PageSequence pageSequence = new PageSequence(null);
                this.transferExtensions(pageSequence);
                this.areaTreeHandler.getAreaTreeModel().startPageSequence(pageSequence);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Starting layout");
                }
                this.makePageForImage(imageInfo, imageLayout);
                if (bl || !bl2) break block10;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Starting multi-page processing...");
                }
                try {
                    URI uRI = new URI(URISpecification.escapeURI(string));
                    int n2 = 1;
                    while (bl2) {
                        ImageInfo imageInfo2;
                        URI uRI2 = new URI(uRI.getScheme(), uRI.getSchemeSpecificPart(), "page=" + Integer.toString(n2 + 1));
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Subimage: " + uRI2.toASCIIString()));
                        }
                        bl2 = (v = (imageInfo2 = imageManager.getImageInfo(uRI2.toASCIIString(), fOUserAgent.getImageSessionContext())).getCustomObjects().get(ImageInfo.HAS_MORE_IMAGES)) != null && !Boolean.FALSE.equals(v);
                        dimension = imageInfo2.getSize().getDimensionMpt();
                        imageLayout = new ImageLayout(this.getExternalDocument(), this, dimension);
                        this.makePageForImage(imageInfo2, imageLayout);
                        ++n2;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.getResourceEventProducer().uriError(this, string, uRISyntaxException, this.getExternalDocument().getLocator());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.getResourceEventProducer().imageNotFound(this, string, fileNotFoundException, this.getExternalDocument().getLocator());
            }
            catch (IOException iOException) {
                this.getResourceEventProducer().imageIOError(this, string, iOException, this.getExternalDocument().getLocator());
            }
            catch (ImageException imageException) {
                this.getResourceEventProducer().imageError(this, string, imageException, this.getExternalDocument().getLocator());
            }
        }
    }

    private ResourceEventProducer getResourceEventProducer() {
        return ResourceEventProducer.Provider.get(this.getExternalDocument().getUserAgent().getEventBroadcaster());
    }

    private void makePageForImage(ImageInfo imageInfo, ImageLayout imageLayout) {
        this.imageLayout = imageLayout;
        this.curPage = this.makeNewPage(false);
        this.fillPage(imageInfo.getOriginalURI());
        this.finishPage();
    }

    private void fillPage(String string) {
        Dimension dimension = this.imageLayout.getViewportSize();
        Block block = new Block();
        block.setIPD(dimension.width);
        LineArea lineArea = new LineArea();
        Image image = new Image(string);
        TraitSetter.setProducerID(image, this.fobj.getId());
        this.transferForeignAttributes(image);
        InlineViewport inlineViewport = new InlineViewport(image, this.fobj.getBidiLevel());
        TraitSetter.setProducerID(inlineViewport, this.fobj.getId());
        inlineViewport.setIPD(dimension.width);
        inlineViewport.setBPD(dimension.height);
        inlineViewport.setContentPosition(this.imageLayout.getPlacement());
        inlineViewport.setBlockProgressionOffset(0);
        lineArea.addInlineArea(inlineViewport);
        lineArea.updateExtentsFromChildren();
        block.addLineArea(lineArea);
        this.curPage.getPageViewport().getCurrentFlow().addBlock(block);
        this.curPage.getPageViewport().getCurrentSpan().notifyFlowsFinished();
    }

    public void finishPageSequence() {
        if (this.pageSeq.hasId()) {
            this.idTracker.signalIDProcessed(this.pageSeq.getId());
        }
        this.pageSeq.getRoot().notifyPageSequenceFinished(this.currentPageNum, this.currentPageNum - this.startPageNum + 1);
        this.areaTreeHandler.notifyPageSequenceFinished(this.pageSeq, this.currentPageNum - this.startPageNum + 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Ending layout");
        }
    }

    protected Page createPage(int n, boolean bl) {
        String string = this.pageSeq.makeFormattedPageNumber(n);
        Dimension dimension = this.imageLayout.getViewportSize();
        Rectangle rectangle = this.pageSeq.getReferenceOrientation() % 180 == 0 ? new Rectangle(0, 0, dimension.width, dimension.height) : new Rectangle(0, 0, dimension.height, dimension.width);
        FODimension fODimension = new FODimension(0, 0);
        CTM cTM = CTM.getCTMandRelDims(this.pageSeq.getReferenceOrientation(), WritingMode.LR_TB, rectangle, fODimension);
        Page page = new Page(rectangle, n, string, bl);
        PageViewport pageViewport = page.getPageViewport();
        org.apache.fop.area.Page page2 = new org.apache.fop.area.Page();
        pageViewport.setPage(page2);
        RegionViewport regionViewport = new RegionViewport(rectangle);
        regionViewport.setIPD(rectangle.width);
        regionViewport.setBPD(rectangle.height);
        regionViewport.setClip(true);
        BodyRegion bodyRegion = new BodyRegion(58, "fop-image-region", regionViewport, 1, 0);
        bodyRegion.setIPD(dimension.width);
        bodyRegion.setBPD(dimension.height);
        bodyRegion.setCTM(cTM);
        regionViewport.setRegionReference(bodyRegion);
        page2.setRegionViewport(58, regionViewport);
        pageViewport.setKey(this.areaTreeHandler.generatePageViewportKey());
        pageViewport.createSpan(false);
        return page;
    }
}

