/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.Locale;
import org.apache.fop.events.Event;
import org.apache.fop.events.EventExceptionManager;
import org.apache.fop.events.EventFormatter;
import org.apache.fop.layoutmgr.LayoutManager;

public class LayoutException
extends RuntimeException {
    private static final long serialVersionUID = 5157080040923740433L;
    private String localizedMessage;
    private LayoutManager layoutManager;

    public LayoutException(String string) {
        this(string, (LayoutManager)null);
    }

    public LayoutException(String string, LayoutManager layoutManager) {
        super(string);
        this.layoutManager = layoutManager;
    }

    public void setLocalizedMessage(String string) {
        this.localizedMessage = string;
    }

    public String getLocalizedMessage() {
        if (this.localizedMessage != null) {
            return this.localizedMessage;
        }
        return super.getLocalizedMessage();
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LayoutExceptionFactory
    implements EventExceptionManager.ExceptionFactory {
        @Override
        public Throwable createException(Event event) {
            Object object = event.getSource();
            LayoutManager layoutManager = object instanceof LayoutManager ? (LayoutManager)object : null;
            String string = EventFormatter.format(event, Locale.ENGLISH);
            LayoutException layoutException = new LayoutException(string, layoutManager);
            if (!Locale.ENGLISH.equals(Locale.getDefault())) {
                layoutException.setLocalizedMessage(EventFormatter.format(event));
            }
            return layoutException;
        }

        public Class<LayoutException> getExceptionClass() {
            return LayoutException.class;
        }
    }
}

