/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.LinkResolver;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.BasicLinkArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;

public class BasicLinkLayoutManager
extends InlineLayoutManager {
    public BasicLinkLayoutManager(BasicLink basicLink) {
        super(basicLink);
    }

    protected InlineArea createArea(boolean bl) {
        InlineArea inlineArea = super.createArea(bl);
        this.setupBasicLinkArea(inlineArea);
        return inlineArea;
    }

    private void setupBasicLinkArea(InlineArea inlineArea) {
        BasicLink basicLink = (BasicLink)this.fobj;
        TraitSetter.addStructureTreeElement(inlineArea, basicLink.getStructureTreeElement());
        if (basicLink.hasInternalDestination()) {
            String string = basicLink.getInternalDestination();
            PageSequenceLayoutManager pageSequenceLayoutManager = this.getPSLM();
            LinkResolver linkResolver = new LinkResolver(string, inlineArea);
            linkResolver.resolveIDRef(string, pageSequenceLayoutManager.getFirstPVWithID(string));
            if (!linkResolver.isResolved()) {
                pageSequenceLayoutManager.addUnresolvedArea(string, linkResolver);
                if (inlineArea instanceof BasicLinkArea) {
                    ((BasicLinkArea)inlineArea).setResolver(linkResolver);
                }
            }
        } else if (basicLink.hasExternalDestination()) {
            boolean bl;
            String string = URISpecification.getURL(basicLink.getExternalDestination());
            boolean bl2 = bl = basicLink.getShowDestination() == 190;
            if (string.length() > 0) {
                inlineArea.addTrait(Trait.EXTERNAL_LINK, new Trait.ExternalLink(string, bl));
            }
        }
    }

    protected InlineParent createInlineParent() {
        return new BasicLinkArea();
    }
}

