/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.Space;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.BreakOpportunity;
import org.apache.fop.layoutmgr.BreakOpportunityHelper;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.traits.MinOptMax;

public abstract class InlineStackingLayoutManager
extends AbstractLayoutManager
implements InlineLevelLayoutManager,
BreakOpportunity {
    protected MinOptMax extraBPD = MinOptMax.ZERO;
    private Area currentArea;
    protected LayoutContext childLC;

    protected InlineStackingLayoutManager(FObj fObj) {
        super(fObj);
    }

    public void setLMiter(ListIterator listIterator) {
        this.childLMiter = listIterator;
    }

    protected MinOptMax getExtraIPD(boolean bl, boolean bl2) {
        return MinOptMax.ZERO;
    }

    protected boolean hasLeadingFence(boolean bl) {
        return false;
    }

    protected boolean hasTrailingFence(boolean bl) {
        return false;
    }

    protected SpaceProperty getSpaceStart() {
        return null;
    }

    protected SpaceProperty getSpaceEnd() {
        return null;
    }

    protected Area getCurrentArea() {
        return this.currentArea;
    }

    protected void setCurrentArea(Area area) {
        this.currentArea = area;
    }

    protected void setTraits(boolean bl, boolean bl2) {
    }

    protected void setChildContext(LayoutContext layoutContext) {
        this.childLC = layoutContext;
    }

    protected LayoutContext getContext() {
        return this.childLC;
    }

    protected void addSpace(Area area, MinOptMax minOptMax, double d) {
        if (minOptMax != null) {
            int n = minOptMax.getOpt();
            if (d > 0.0) {
                n += (int)((double)minOptMax.getStretch() * d);
            } else if (d < 0.0) {
                n += (int)((double)minOptMax.getShrink() * d);
            }
            if (n != 0) {
                Space space = new Space();
                space.setIPD(n);
                int n2 = area.getBidiLevel();
                if (n2 >= 0) {
                    space.setBidiLevel(n2);
                }
                area.addChildArea(space);
            }
        }
    }

    public List addALetterSpaceTo(List list) {
        return this.addALetterSpaceTo(list, 0);
    }

    public List addALetterSpaceTo(List list, int n) {
        ListIterator listIterator = list.listIterator(list.size());
        KnuthElement knuthElement = (KnuthElement)listIterator.previous();
        int n2 = n + 1;
        Position position = knuthElement.getPosition();
        InlineLevelLayoutManager inlineLevelLayoutManager = null;
        if (position != null) {
            inlineLevelLayoutManager = (InlineLevelLayoutManager)position.getLM(n2);
        }
        if (inlineLevelLayoutManager == null) {
            return list;
        }
        list = inlineLevelLayoutManager.addALetterSpaceTo(list, n2);
        listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            knuthElement = (KnuthElement)listIterator.next();
            position = knuthElement.getPosition();
            inlineLevelLayoutManager = null;
            if (position != null) {
                inlineLevelLayoutManager = (InlineLevelLayoutManager)position.getLM(n);
            }
            if (inlineLevelLayoutManager == this) continue;
            knuthElement.setPosition(this.notifyPos(new NonLeafPosition((LayoutManager)this, knuthElement.getPosition())));
        }
        return list;
    }

    public String getWordChars(Position position) {
        Position position2 = position.getPosition();
        return ((InlineLevelLayoutManager)position2.getLM()).getWordChars(position2);
    }

    public void hyphenate(Position position, HyphContext hyphContext) {
        Position position2 = position.getPosition();
        ((InlineLevelLayoutManager)position2.getLM()).hyphenate(position2, hyphContext);
    }

    public boolean applyChanges(List list) {
        return this.applyChanges(list, 0);
    }

    public boolean applyChanges(List list, int n) {
        ListIterator listIterator = list.listIterator();
        ++n;
        InlineLevelLayoutManager inlineLevelLayoutManager = null;
        int n2 = 0;
        boolean bl = false;
        while (listIterator.hasNext()) {
            KnuthElement knuthElement = (KnuthElement)listIterator.next();
            Position position = knuthElement.getPosition();
            InlineLevelLayoutManager inlineLevelLayoutManager2 = position == null ? null : (InlineLevelLayoutManager)position.getLM(n);
            if (inlineLevelLayoutManager == null) {
                inlineLevelLayoutManager = inlineLevelLayoutManager2;
            }
            if (inlineLevelLayoutManager2 == inlineLevelLayoutManager && listIterator.hasNext()) continue;
            if (inlineLevelLayoutManager == this || inlineLevelLayoutManager2 == this) {
                inlineLevelLayoutManager = inlineLevelLayoutManager2;
                continue;
            }
            if (listIterator.hasNext()) {
                bl = inlineLevelLayoutManager.applyChanges(list.subList(n2, listIterator.previousIndex()), n) || bl;
                inlineLevelLayoutManager = inlineLevelLayoutManager2;
                n2 = listIterator.previousIndex();
                continue;
            }
            if (inlineLevelLayoutManager2 == inlineLevelLayoutManager) {
                bl = inlineLevelLayoutManager != null && inlineLevelLayoutManager.applyChanges(list.subList(n2, list.size()), n) || bl;
                continue;
            }
            boolean bl2 = bl = inlineLevelLayoutManager.applyChanges(list.subList(n2, listIterator.previousIndex()), n) || bl;
            if (inlineLevelLayoutManager2 == null) continue;
            bl = inlineLevelLayoutManager2.applyChanges(list.subList(listIterator.previousIndex(), list.size()), n) || bl;
        }
        return bl;
    }

    public List getChangedKnuthElements(List list, int n) {
        return this.getChangedKnuthElements(list, n, 0);
    }

    public List getChangedKnuthElements(List list, int n, int n2) {
        Object object;
        ListIterator listIterator = list.listIterator();
        ++n2;
        LinkedList linkedList = new LinkedList();
        LinkedList<KnuthElement> linkedList2 = new LinkedList<KnuthElement>();
        InlineLevelLayoutManager inlineLevelLayoutManager = null;
        int n3 = 0;
        while (listIterator.hasNext()) {
            KnuthElement knuthElement = (KnuthElement)listIterator.next();
            object = knuthElement.getPosition();
            InlineLevelLayoutManager inlineLevelLayoutManager2 = object == null ? null : (InlineLevelLayoutManager)((Position)object).getLM(n2);
            if (inlineLevelLayoutManager == null) {
                inlineLevelLayoutManager = inlineLevelLayoutManager2;
            }
            if (inlineLevelLayoutManager2 == inlineLevelLayoutManager && listIterator.hasNext()) continue;
            if (listIterator.hasNext()) {
                linkedList.addAll(inlineLevelLayoutManager.getChangedKnuthElements(list.subList(n3, listIterator.previousIndex()), n, n2));
                inlineLevelLayoutManager = inlineLevelLayoutManager2;
                n3 = listIterator.previousIndex();
                continue;
            }
            if (inlineLevelLayoutManager2 == inlineLevelLayoutManager) {
                linkedList.addAll(inlineLevelLayoutManager.getChangedKnuthElements(list.subList(n3, list.size()), n, n2));
                continue;
            }
            linkedList.addAll(inlineLevelLayoutManager.getChangedKnuthElements(list.subList(n3, listIterator.previousIndex()), n, n2));
            if (inlineLevelLayoutManager2 == null) continue;
            linkedList.addAll(inlineLevelLayoutManager2.getChangedKnuthElements(list.subList(listIterator.previousIndex(), list.size()), n, n2));
        }
        object = linkedList.listIterator();
        while (object.hasNext()) {
            KnuthElement knuthElement = (KnuthElement)object.next();
            knuthElement.setPosition(this.notifyPos(new NonLeafPosition((LayoutManager)this, knuthElement.getPosition())));
            linkedList2.add(knuthElement);
        }
        return linkedList2;
    }

    public int getBreakBefore() {
        return BreakOpportunityHelper.getBreakBefore(this);
    }
}

