/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.traits.MinOptMax;

public class PageNumberLayoutManager
extends LeafNodeLayoutManager {
    private PageNumber fobj;
    private Font font;

    public PageNumberLayoutManager(PageNumber pageNumber) {
        super(pageNumber);
        this.fobj = pageNumber;
    }

    public void initialize() {
        FontInfo fontInfo = this.fobj.getFOEventHandler().getFontInfo();
        FontTriplet[] fontTripletArray = this.fobj.getCommonFont().getFontState(fontInfo);
        this.font = fontInfo.getFontInstance(fontTripletArray[0], this.fobj.getCommonFont().fontSize.getValue(this));
        this.setCommonBorderPaddingBackground(this.fobj.getCommonBorderPaddingBackground());
    }

    protected AlignmentContext makeAlignmentContext(LayoutContext layoutContext) {
        return new AlignmentContext(this.font, this.fobj.getLineHeight().getOptimum(this).getLength().getValue(this), this.fobj.getAlignmentAdjust(), this.fobj.getAlignmentBaseline(), this.fobj.getBaselineShift(), this.fobj.getDominantBaseline(), layoutContext.getAlignmentContext());
    }

    public InlineArea get(LayoutContext layoutContext) {
        TextArea textArea = new TextArea();
        String string = this.getCurrentPV().getPageNumberString();
        int n = this.getStringWidth(string);
        textArea.addWord(string, 0);
        textArea.setIPD(n);
        textArea.setBPD(this.font.getAscender() - this.font.getDescender());
        textArea.setBaselineOffset(this.font.getAscender());
        TraitSetter.addFontTraits(textArea, this.font);
        textArea.addTrait(Trait.COLOR, this.fobj.getColor());
        TraitSetter.addStructureTreeElement(textArea, this.fobj.getStructureTreeElement());
        TraitSetter.addTextDecoration(textArea, this.fobj.getTextDecoration());
        return textArea;
    }

    protected InlineArea getEffectiveArea() {
        TextArea textArea = (TextArea)this.curArea;
        TextArea textArea2 = new TextArea();
        TraitSetter.setProducerID(textArea2, this.fobj.getId());
        textArea2.setIPD(textArea.getIPD());
        textArea2.setBPD(textArea.getBPD());
        textArea2.setBlockProgressionOffset(textArea.getBlockProgressionOffset());
        textArea2.setBaselineOffset(textArea.getBaselineOffset());
        textArea2.addTrait(Trait.COLOR, this.fobj.getColor());
        textArea2.getTraits().putAll(textArea.getTraits());
        this.updateContent(textArea2);
        return textArea2;
    }

    private void updateContent(TextArea textArea) {
        textArea.removeText();
        textArea.addWord(this.getCurrentPV().getPageNumberString(), 0);
        textArea.handleIPDVariation(this.getStringWidth(textArea.getText()) - textArea.getIPD());
        this.areaInfo.ipdArea = MinOptMax.getInstance(textArea.getIPD());
    }

    private int getStringWidth(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += this.font.getCharWidth(string.charAt(i));
        }
        return n;
    }
}

