/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;

public class PDFCIELabColorSpace
extends PDFArray
implements PDFColorSpace {
    public PDFCIELabColorSpace(float[] fArray, float[] fArray2) {
        this.add(new PDFName("Lab"));
        PDFDictionary pDFDictionary = new PDFDictionary();
        pDFDictionary.put("WhitePoint", this.toPDFArray("White point", fArray));
        if (fArray[1] != 1.0f) {
            throw new IllegalArgumentException("The white point's Y coordinate must be 1.0");
        }
        if (fArray2 != null) {
            pDFDictionary.put("BlackPoint", this.toPDFArray("Black point", fArray2));
        }
        pDFDictionary.put("Range", new PDFArray((PDFObject)pDFDictionary, new int[]{-128, 128, -128, 128}));
        this.add(pDFDictionary);
    }

    private PDFArray toPDFArray(String string, float[] fArray) {
        PDFArray pDFArray = new PDFArray();
        if (fArray == null || fArray.length != 3) {
            throw new IllegalArgumentException(string + " must be given an have 3 components");
        }
        for (int i = 0; i < 3; ++i) {
            pDFArray.add(fArray[i]);
        }
        return pDFArray;
    }

    public String getName() {
        return "CS" + this.getObjectNumber();
    }

    public int getNumComponents() {
        return 3;
    }

    public boolean isCMYKColorSpace() {
        return false;
    }

    public boolean isDeviceColorSpace() {
        return false;
    }

    public boolean isGrayColorSpace() {
        return false;
    }

    public boolean isRGBColorSpace() {
        return false;
    }
}

