/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFObject;

public class PDFDestination
extends PDFObject {
    private String idRef;
    private Object goToReference;

    public PDFDestination(String string, Object object) {
        this.goToReference = object;
        this.idRef = string;
    }

    public int output(OutputStream outputStream) throws IOException {
        CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream);
        StringBuilder stringBuilder = new StringBuilder(64);
        this.formatObject(this.getIDRef(), (OutputStream)countingOutputStream, stringBuilder);
        stringBuilder.append(' ');
        this.formatObject(this.goToReference, (OutputStream)countingOutputStream, stringBuilder);
        PDFDocument.flushTextBuffer(stringBuilder, (OutputStream)countingOutputStream);
        return countingOutputStream.getCount();
    }

    @Deprecated
    public void setGoToReference(String string) {
        this.goToReference = string;
    }

    public void setGoToReference(Object object) {
        this.goToReference = object;
    }

    public Object getGoToReference() {
        return this.goToReference;
    }

    public String getIDRef() {
        return this.idRef;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof PDFDestination)) {
            return false;
        }
        PDFDestination pDFDestination = (PDFDestination)object;
        return pDFDestination.getIDRef().equals(this.getIDRef());
    }

    public int hashCode() {
        return this.getIDRef().hashCode();
    }
}

