/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.traits.BorderProps;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.util.UnitConv;
import org.w3c.dom.Document;

public abstract class AbstractPathOrientedRenderer
extends PrintRenderer {
    private static final int TOP = 0;
    private static final int RIGHT = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;
    protected static final QName FOX_TRANSFORM = new QName("http://xmlgraphics.apache.org/fop/extensions", "fox:transform");

    public AbstractPathOrientedRenderer(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
    }

    protected void handleBlockTraits(Block block) {
        float f = (float)block.getBorderAndPaddingWidthStart() / 1000.0f;
        float f2 = (float)block.getBorderAndPaddingWidthEnd() / 1000.0f;
        float f3 = (float)block.getBorderAndPaddingWidthBefore() / 1000.0f;
        float f4 = (float)block.getBorderAndPaddingWidthAfter() / 1000.0f;
        float f5 = (float)this.currentIPPosition / 1000.0f;
        float f6 = (float)this.currentBPPosition / 1000.0f;
        float f7 = (float)block.getIPD() / 1000.0f;
        float f8 = (float)block.getBPD() / 1000.0f;
        int n = block.getBidiLevel();
        if (n == -1 || (n & 1) == 0) {
            f5 += (float)block.getStartIndent() / 1000.0f;
            f5 -= f;
        } else {
            f5 += (float)block.getEndIndent() / 1000.0f;
            f5 -= f2;
        }
        f7 += f;
        f8 += f3;
        this.drawBackAndBorders(block, f5, f6, f7 += f2, f8 += f4);
    }

    protected void handleRegionTraits(RegionViewport regionViewport) {
        Rectangle2D rectangle2D = regionViewport.getViewArea();
        RegionReference regionReference = regionViewport.getRegionReference();
        float f = (float)(rectangle2D.getX() / 1000.0);
        float f2 = (float)(rectangle2D.getY() / 1000.0);
        float f3 = (float)(rectangle2D.getWidth() / 1000.0);
        float f4 = (float)(rectangle2D.getHeight() / 1000.0);
        this.currentBPPosition = regionReference.getBorderAndPaddingWidthBefore();
        int n = regionViewport.getBidiLevel();
        this.currentIPPosition = n == -1 || (n & 1) == 0 ? regionReference.getBorderAndPaddingWidthStart() : regionReference.getBorderAndPaddingWidthEnd();
        this.drawBackAndBorders(regionViewport, regionReference, f, f2, f3, f4);
    }

    protected void drawBackAndBorders(Area area, float f, float f2, float f3, float f4) {
        this.drawBackAndBorders(area, area, f, f2, f3, f4);
    }

    protected void drawBackAndBorders(Area area, Area area2, float f, float f2, float f3, float f4) {
        BorderProps borderProps = (BorderProps)area2.getTrait(Trait.BORDER_BEFORE);
        BorderProps borderProps2 = (BorderProps)area2.getTrait(Trait.BORDER_AFTER);
        BorderProps borderProps3 = (BorderProps)area2.getTrait(Trait.BORDER_START);
        BorderProps borderProps4 = (BorderProps)area2.getTrait(Trait.BORDER_END);
        this.drawBackground(f, f2, f3, f4, (Trait.Background)area.getTrait(Trait.BACKGROUND), borderProps, borderProps2, borderProps3, borderProps4, area.getBidiLevel());
        this.drawBorders(f, f2, f3, f4, borderProps, borderProps2, borderProps3, borderProps4, area2.getBidiLevel());
    }

    protected void drawBackground(float f, float f2, float f3, float f4, Trait.Background background, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4, int n) {
        BorderProps borderProps5;
        BorderProps borderProps6;
        BorderProps borderProps7 = borderProps;
        BorderProps borderProps8 = borderProps2;
        if (n == -1 || (n & 1) == 0) {
            borderProps6 = borderProps3;
            borderProps5 = borderProps4;
        } else {
            borderProps6 = borderProps4;
            borderProps5 = borderProps3;
        }
        this.drawBackground(f, f2, f3, f4, background, borderProps7, borderProps8, borderProps6, borderProps5);
    }

    protected void drawBackground(float f, float f2, float f3, float f4, Trait.Background background, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4) {
        if (background != null) {
            this.endTextObject();
            float f5 = f;
            float f6 = f2;
            float f7 = f3;
            float f8 = f4;
            if (borderProps3 != null) {
                f5 += (float)borderProps3.width / 1000.0f;
                f7 -= (float)borderProps3.width / 1000.0f;
            }
            if (borderProps != null) {
                f6 += (float)borderProps.width / 1000.0f;
                f8 -= (float)borderProps.width / 1000.0f;
            }
            if (borderProps4 != null) {
                f7 -= (float)borderProps4.width / 1000.0f;
            }
            if (borderProps2 != null) {
                f8 -= (float)borderProps2.width / 1000.0f;
            }
            if (background.getColor() != null) {
                this.updateColor(background.getColor(), true);
                this.fillRect(f5, f6, f7, f8);
            }
            if (background.getImageInfo() != null) {
                ImageSize imageSize = background.getImageInfo().getSize();
                this.saveGraphicsState();
                this.clipRect(f5, f6, f7, f8);
                int n = (int)(f7 * 1000.0f / (float)imageSize.getWidthMpt() + 1.0f);
                int n2 = (int)(f8 * 1000.0f / (float)imageSize.getHeightMpt() + 1.0f);
                if (background.getRepeat() == 96) {
                    n = 1;
                    n2 = 1;
                } else if (background.getRepeat() == 113) {
                    n2 = 1;
                } else if (background.getRepeat() == 114) {
                    n = 1;
                }
                f5 *= 1000.0f;
                f6 *= 1000.0f;
                if (n == 1) {
                    f5 += (float)background.getHoriz();
                }
                if (n2 == 1) {
                    f6 += (float)background.getVertical();
                }
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        Rectangle2D.Float float_ = new Rectangle2D.Float(f5 - (float)this.currentIPPosition + (float)(i * imageSize.getWidthMpt()), f6 - (float)this.currentBPPosition + (float)(j * imageSize.getHeightMpt()), imageSize.getWidthMpt(), imageSize.getHeightMpt());
                        this.drawImage(background.getURL(), float_);
                    }
                }
                this.restoreGraphicsState();
            }
        }
    }

    protected void drawBorders(float f, float f2, float f3, float f4, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4, int n) {
        BorderProps borderProps5;
        BorderProps borderProps6;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
        BorderProps borderProps7 = borderProps;
        BorderProps borderProps8 = borderProps2;
        if (n == -1 || (n & 1) == 0) {
            borderProps6 = borderProps3;
            borderProps5 = borderProps4;
        } else {
            borderProps6 = borderProps4;
            borderProps5 = borderProps3;
        }
        this.drawBorders(float_, borderProps7, borderProps8, borderProps6, borderProps5);
    }

    protected void drawBorders(Rectangle2D.Float float_, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        boolean[] blArray = new boolean[]{borderProps != null, borderProps4 != null, borderProps2 != null, borderProps3 != null};
        float f10 = float_.x;
        float f11 = float_.y;
        float f12 = float_.width;
        float f13 = float_.height;
        float[] fArray = new float[]{blArray[0] ? (float)borderProps.width / 1000.0f : 0.0f, blArray[1] ? (float)borderProps4.width / 1000.0f : 0.0f, blArray[2] ? (float)borderProps2.width / 1000.0f : 0.0f, blArray[3] ? (float)borderProps3.width / 1000.0f : 0.0f};
        float[] fArray2 = new float[]{(float)BorderProps.getClippedWidth(borderProps) / 1000.0f, (float)BorderProps.getClippedWidth(borderProps4) / 1000.0f, (float)BorderProps.getClippedWidth(borderProps2) / 1000.0f, (float)BorderProps.getClippedWidth(borderProps3) / 1000.0f};
        f11 += fArray2[0];
        f13 -= fArray2[0];
        f13 -= fArray2[2];
        f10 += fArray2[3];
        f12 -= fArray2[3];
        f12 -= fArray2[1];
        boolean[] blArray2 = new boolean[]{blArray[3] && blArray[0], blArray[0] && blArray[1], blArray[1] && blArray[2], blArray[2] && blArray[3]};
        if (borderProps != null) {
            this.endTextObject();
            f9 = f10;
            f8 = blArray2[0] ? f9 + fArray[3] - fArray2[3] : f9;
            f7 = f10 + f12;
            f6 = blArray2[1] ? f7 - fArray[1] + fArray2[1] : f7;
            f5 = f11 - fArray2[0];
            f4 = f5 + fArray2[0];
            f3 = f5 + fArray[0];
            this.saveGraphicsState();
            this.moveTo(f9, f4);
            f2 = f9;
            f = f7;
            if (borderProps.mode == 2) {
                if (borderProps3 != null && borderProps3.mode == 2) {
                    f2 -= fArray2[3];
                }
                if (borderProps4 != null && borderProps4.mode == 2) {
                    f += fArray2[1];
                }
                this.lineTo(f2, f5);
                this.lineTo(f, f5);
            }
            this.lineTo(f7, f4);
            this.lineTo(f6, f3);
            this.lineTo(f8, f3);
            this.closePath();
            this.clip();
            this.drawBorderLine(f2, f5, f, f3, true, true, borderProps.style, borderProps.color);
            this.restoreGraphicsState();
        }
        if (borderProps4 != null) {
            this.endTextObject();
            f9 = f11;
            f8 = blArray2[1] ? f9 + fArray[0] - fArray2[0] : f9;
            f7 = f11 + f13;
            f6 = blArray2[2] ? f7 - fArray[2] + fArray2[2] : f7;
            f5 = f10 + f12 + fArray2[1];
            f4 = f5 - fArray2[1];
            f3 = f5 - fArray[1];
            this.saveGraphicsState();
            this.moveTo(f4, f9);
            f2 = f9;
            f = f7;
            if (borderProps4.mode == 2) {
                if (borderProps != null && borderProps.mode == 2) {
                    f2 -= fArray2[0];
                }
                if (borderProps2 != null && borderProps2.mode == 2) {
                    f += fArray2[2];
                }
                this.lineTo(f5, f2);
                this.lineTo(f5, f);
            }
            this.lineTo(f4, f7);
            this.lineTo(f3, f6);
            this.lineTo(f3, f8);
            this.closePath();
            this.clip();
            this.drawBorderLine(f3, f2, f5, f, false, false, borderProps4.style, borderProps4.color);
            this.restoreGraphicsState();
        }
        if (borderProps2 != null) {
            this.endTextObject();
            f9 = f10;
            f8 = blArray2[3] ? f9 + fArray[3] - fArray2[3] : f9;
            f7 = f10 + f12;
            f6 = blArray2[2] ? f7 - fArray[1] + fArray2[1] : f7;
            f5 = f11 + f13 + fArray2[2];
            f4 = f5 - fArray2[2];
            f3 = f5 - fArray[2];
            this.saveGraphicsState();
            this.moveTo(f7, f4);
            f2 = f9;
            f = f7;
            if (borderProps2.mode == 2) {
                if (borderProps3 != null && borderProps3.mode == 2) {
                    f2 -= fArray2[3];
                }
                if (borderProps4 != null && borderProps4.mode == 2) {
                    f += fArray2[1];
                }
                this.lineTo(f, f5);
                this.lineTo(f2, f5);
            }
            this.lineTo(f9, f4);
            this.lineTo(f8, f3);
            this.lineTo(f6, f3);
            this.closePath();
            this.clip();
            this.drawBorderLine(f2, f3, f, f5, true, false, borderProps2.style, borderProps2.color);
            this.restoreGraphicsState();
        }
        if (borderProps3 != null) {
            this.endTextObject();
            f9 = f11;
            f8 = blArray2[0] ? f9 + fArray[0] - fArray2[0] : f9;
            f7 = f9 + f13;
            f6 = blArray2[3] ? f7 - fArray[2] + fArray2[2] : f7;
            f5 = f10 - fArray2[3];
            f4 = f5 + fArray2[3];
            f3 = f5 + fArray[3];
            this.saveGraphicsState();
            this.moveTo(f4, f7);
            f2 = f9;
            f = f7;
            if (borderProps3.mode == 2) {
                if (borderProps != null && borderProps.mode == 2) {
                    f2 -= fArray2[0];
                }
                if (borderProps2 != null && borderProps2.mode == 2) {
                    f += fArray2[2];
                }
                this.lineTo(f5, f);
                this.lineTo(f5, f2);
            }
            this.lineTo(f4, f9);
            this.lineTo(f3, f8);
            this.lineTo(f3, f6);
            this.closePath();
            this.clip();
            this.drawBorderLine(f5, f2, f3, f, false, true, borderProps3.style, borderProps3.color);
            this.restoreGraphicsState();
        }
    }

    protected void renderInlineAreaBackAndBorders(InlineArea inlineArea) {
        float f = (float)inlineArea.getBorderAndPaddingWidthStart() / 1000.0f;
        float f2 = (float)inlineArea.getBorderAndPaddingWidthEnd() / 1000.0f;
        float f3 = (float)inlineArea.getBorderAndPaddingWidthBefore() / 1000.0f;
        float f4 = (float)inlineArea.getBorderAndPaddingWidthAfter() / 1000.0f;
        float f5 = f + f2;
        float f6 = f3 + f4;
        float f7 = (float)inlineArea.getBPD() / 1000.0f;
        if (f7 != 0.0f || f6 != 0.0f && f5 != 0.0f) {
            float f8 = (float)this.currentIPPosition / 1000.0f;
            float f9 = (float)(this.currentBPPosition + inlineArea.getBlockProgressionOffset()) / 1000.0f;
            float f10 = (float)inlineArea.getIPD() / 1000.0f;
            this.drawBackAndBorders(inlineArea, f8, f9 - f3, f10 + f5, f7 + f6);
        }
    }

    protected void renderBlockViewport(BlockViewport blockViewport, List list) {
        int n = this.currentIPPosition;
        int n2 = this.currentBPPosition;
        CTM cTM = blockViewport.getCTM();
        int n3 = blockViewport.getBorderAndPaddingWidthBefore();
        int n4 = blockViewport.getPositioning();
        if (n4 == 2 || n4 == 3) {
            AffineTransform affineTransform;
            List list2 = null;
            if (n4 == 3) {
                list2 = this.breakOutOfStateStack();
            }
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.translate(blockViewport.getXOffset(), blockViewport.getYOffset());
            int n5 = blockViewport.getBidiLevel();
            int n6 = blockViewport.getBorderAndPaddingWidthStart();
            int n7 = blockViewport.getBorderAndPaddingWidthEnd();
            if (n5 == -1 || (n5 & 1) == 0) {
                affineTransform2.translate(-n6, -n3);
            } else {
                affineTransform2.translate(-n7, -n3);
            }
            String string = blockViewport.getForeignAttributeValue(FOX_TRANSFORM);
            if (string != null) {
                AffineTransform affineTransform3 = AWTTransformProducer.createAffineTransform((String)string);
                affineTransform2.concatenate(affineTransform3);
            }
            if (!affineTransform2.isIdentity()) {
                this.establishTransformationMatrix(affineTransform2);
            }
            float f = (float)blockViewport.getIPD() / 1000.0f;
            float f2 = (float)blockViewport.getBPD() / 1000.0f;
            float f3 = (float)(n6 + n7) / 1000.0f;
            float f4 = (float)(n3 + blockViewport.getBorderAndPaddingWidthAfter()) / 1000.0f;
            this.drawBackAndBorders(blockViewport, 0.0f, 0.0f, f + f3, f2 + f4);
            AffineTransform affineTransform4 = new AffineTransform();
            if (n5 == -1 || (n5 & 1) == 0) {
                affineTransform4.translate(n6, n3);
            } else {
                affineTransform4.translate(n7, n3);
            }
            if (!affineTransform4.isIdentity()) {
                this.establishTransformationMatrix(affineTransform4);
            }
            if (blockViewport.hasClip()) {
                this.clipRect(0.0f, 0.0f, f, f2);
            }
            if (!(affineTransform = cTM.toAffineTransform()).isIdentity()) {
                this.establishTransformationMatrix(affineTransform);
            }
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(blockViewport, list);
            if (!affineTransform.isIdentity()) {
                this.restoreGraphicsState();
            }
            if (!affineTransform4.isIdentity()) {
                this.restoreGraphicsState();
            }
            if (!affineTransform2.isIdentity()) {
                this.restoreGraphicsState();
            }
            if (n4 == 3 && list2 != null) {
                this.restoreStateStackAfterBreakOut(list2);
            }
            this.currentIPPosition = n;
            this.currentBPPosition = n2;
        } else {
            this.currentBPPosition += blockViewport.getSpaceBefore();
            this.handleBlockTraits(blockViewport);
            this.currentIPPosition += blockViewport.getStartIndent();
            CTM cTM2 = new CTM(this.containingIPPosition, this.currentBPPosition);
            cTM = cTM2.multiply(cTM);
            this.currentBPPosition += n3;
            Rectangle rectangle = null;
            if (blockViewport.hasClip()) {
                rectangle = new Rectangle(this.currentIPPosition, this.currentBPPosition, blockViewport.getIPD(), blockViewport.getBPD());
            }
            this.startVParea(cTM, rectangle);
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(blockViewport, list);
            this.endVParea();
            this.currentIPPosition = n;
            this.currentBPPosition = n2;
            this.currentBPPosition += blockViewport.getAllocBPD();
        }
    }

    protected void renderReferenceArea(Block block) {
        int n = this.currentIPPosition;
        int n2 = this.currentBPPosition;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.currentIPPosition, this.currentBPPosition);
        affineTransform.translate(block.getXOffset(), block.getYOffset());
        affineTransform.translate(0.0, block.getSpaceBefore());
        if (!affineTransform.isIdentity()) {
            this.establishTransformationMatrix(affineTransform);
        }
        this.currentIPPosition = 0;
        this.currentBPPosition = 0;
        this.handleBlockTraits(block);
        List list = block.getChildAreas();
        if (list != null) {
            this.renderBlocks(block, list);
        }
        if (!affineTransform.isIdentity()) {
            this.restoreGraphicsState();
        }
        this.currentIPPosition = n;
        this.currentBPPosition = n2;
    }

    protected void renderFlow(NormalFlow normalFlow) {
        int n = this.currentIPPosition;
        int n2 = this.currentBPPosition;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.currentIPPosition, this.currentBPPosition);
        if (!affineTransform.isIdentity()) {
            this.establishTransformationMatrix(affineTransform);
        }
        this.currentIPPosition = 0;
        this.currentBPPosition = 0;
        super.renderFlow(normalFlow);
        if (!affineTransform.isIdentity()) {
            this.restoreGraphicsState();
        }
        this.currentIPPosition = n;
        this.currentBPPosition = n2;
    }

    protected abstract void concatenateTransformationMatrix(AffineTransform var1);

    public void renderInlineViewport(InlineViewport inlineViewport) {
        int n = inlineViewport.getBidiLevel();
        float f = (float)this.currentIPPosition / 1000.0f;
        float f2 = (float)(this.currentBPPosition + inlineViewport.getBlockProgressionOffset()) / 1000.0f;
        float f3 = (float)inlineViewport.getIPD() / 1000.0f;
        float f4 = (float)inlineViewport.getBPD() / 1000.0f;
        float f5 = (float)inlineViewport.getBorderAndPaddingWidthStart() / 1000.0f;
        float f6 = (float)inlineViewport.getBorderAndPaddingWidthEnd() / 1000.0f;
        float f7 = (float)inlineViewport.getBorderAndPaddingWidthBefore() / 1000.0f;
        float f8 = (float)inlineViewport.getBorderAndPaddingWidthAfter() / 1000.0f;
        float f9 = f5 + f6;
        float f10 = f7 + f8;
        this.drawBackAndBorders(inlineViewport, f, f2, f3 + f9, f4 + f10);
        if (inlineViewport.hasClip()) {
            this.saveGraphicsState();
            if (n == -1 || (n & 1) == 0) {
                this.clipRect(f + f5, f2 + f7, f3, f4);
            } else {
                this.clipRect(f + f6, f2 + f7, f3, f4);
            }
        }
        super.renderInlineViewport(inlineViewport);
        if (inlineViewport.hasClip()) {
            this.restoreGraphicsState();
        }
    }

    protected abstract void restoreStateStackAfterBreakOut(List var1);

    protected abstract List breakOutOfStateStack();

    protected abstract void saveGraphicsState();

    protected abstract void restoreGraphicsState();

    protected abstract void beginTextObject();

    protected abstract void endTextObject();

    protected void renderTextDecoration(FontMetrics fontMetrics, int n, InlineArea inlineArea, int n2, int n3) {
        boolean bl;
        boolean bl2 = bl = inlineArea.hasUnderline() || inlineArea.hasOverline() || inlineArea.hasLineThrough();
        if (bl) {
            float f;
            Color color;
            this.endTextObject();
            float f2 = (float)fontMetrics.getDescender(n) / 1000.0f;
            float f3 = (float)fontMetrics.getCapHeight(n) / 1000.0f;
            float f4 = f2 / -8.0f / 2.0f;
            float f5 = (float)(n3 + inlineArea.getIPD()) / 1000.0f;
            if (inlineArea.hasUnderline()) {
                color = (Color)inlineArea.getTrait(Trait.UNDERLINE_COLOR);
                f = (float)n2 - f2 / 2.0f;
                this.drawBorderLine((float)n3 / 1000.0f, (f - f4) / 1000.0f, f5, (f + f4) / 1000.0f, true, true, 133, color);
            }
            if (inlineArea.hasOverline()) {
                color = (Color)inlineArea.getTrait(Trait.OVERLINE_COLOR);
                f = (float)((double)n2 - 1.1 * (double)f3);
                this.drawBorderLine((float)n3 / 1000.0f, (f - f4) / 1000.0f, f5, (f + f4) / 1000.0f, true, true, 133, color);
            }
            if (inlineArea.hasLineThrough()) {
                color = (Color)inlineArea.getTrait(Trait.LINETHROUGH_COLOR);
                f = (float)((double)n2 - 0.45 * (double)f3);
                this.drawBorderLine((float)n3 / 1000.0f, (f - f4) / 1000.0f, f5, (f + f4) / 1000.0f, true, true, 133, color);
            }
        }
    }

    protected abstract void clip();

    protected abstract void clipRect(float var1, float var2, float var3, float var4);

    protected abstract void moveTo(float var1, float var2);

    protected abstract void lineTo(float var1, float var2);

    protected abstract void closePath();

    protected abstract void fillRect(float var1, float var2, float var3, float var4);

    protected abstract void updateColor(Color var1, boolean var2);

    protected abstract void drawImage(String var1, Rectangle2D var2, Map var3);

    protected final void drawImage(String string, Rectangle2D rectangle2D) {
        this.drawImage(string, rectangle2D, null);
    }

    protected abstract void drawBorderLine(float var1, float var2, float var3, float var4, boolean var5, boolean var6, int var7, Color var8);

    public void renderForeignObject(ForeignObject foreignObject, Rectangle2D rectangle2D) {
        this.endTextObject();
        Document document = foreignObject.getDocument();
        String string = foreignObject.getNameSpace();
        this.renderDocument(document, string, rectangle2D, foreignObject.getForeignAttributes());
    }

    protected void establishTransformationMatrix(AffineTransform affineTransform) {
        this.saveGraphicsState();
        this.concatenateTransformationMatrix(UnitConv.mptToPt((AffineTransform)affineTransform));
    }
}

