/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.CTM;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Container;
import org.apache.fop.area.inline.FilledArea;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fo.Constants;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.ImageAdapter;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.render.XMLHandlerConfigurator;
import org.w3c.dom.Document;

public abstract class AbstractRenderer
implements Renderer,
Constants {
    protected static final Log log = LogFactory.getLog((String)"org.apache.fop.render");
    protected FOUserAgent userAgent = null;
    protected int currentBPPosition = 0;
    protected int currentIPPosition = 0;
    protected int containingBPPosition = 0;
    protected int containingIPPosition = 0;
    protected PageViewport currentPageViewport;
    private Set warnedXMLHandlers;

    public abstract void setupFontInfo(FontInfo var1) throws FOPException;

    public AbstractRenderer(FOUserAgent fOUserAgent) {
        this.userAgent = fOUserAgent;
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        if (this.userAgent == null) {
            throw new IllegalStateException("FOUserAgent has not been set on Renderer");
        }
    }

    public void stopRenderer() throws IOException {
    }

    public boolean supportsOutOfOrder() {
        return false;
    }

    public void setDocumentLocale(Locale locale) {
    }

    public void processOffDocumentItem(OffDocumentItem offDocumentItem) {
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return null;
    }

    public ImageAdapter getImageAdapter() {
        return null;
    }

    protected PageViewport getCurrentPageViewport() {
        return this.currentPageViewport;
    }

    public void preparePage(PageViewport pageViewport) {
    }

    protected String convertTitleToString(LineArea lineArea) {
        List list = lineArea.getInlineAreas();
        String string = this.convertToString(list);
        return string.trim();
    }

    private String convertToString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            InlineArea inlineArea = (InlineArea)list.get(i);
            if (inlineArea instanceof TextArea) {
                stringBuffer.append(((TextArea)inlineArea).getText());
                continue;
            }
            if (inlineArea instanceof InlineParent) {
                stringBuffer.append(this.convertToString(((InlineParent)inlineArea).getChildAreas()));
                continue;
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public void startPageSequence(LineArea lineArea) {
    }

    public void startPageSequence(PageSequence pageSequence) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPage(PageViewport pageViewport) throws IOException, FOPException {
        this.currentPageViewport = pageViewport;
        try {
            Page page = pageViewport.getPage();
            this.renderPageAreas(page);
        }
        finally {
            this.currentPageViewport = null;
        }
    }

    protected void renderPageAreas(Page page) {
        RegionViewport regionViewport = page.getRegionViewport(57);
        if (regionViewport != null) {
            this.renderRegionViewport(regionViewport);
        }
        if ((regionViewport = page.getRegionViewport(61)) != null) {
            this.renderRegionViewport(regionViewport);
        }
        if ((regionViewport = page.getRegionViewport(59)) != null) {
            this.renderRegionViewport(regionViewport);
        }
        if ((regionViewport = page.getRegionViewport(56)) != null) {
            this.renderRegionViewport(regionViewport);
        }
        if ((regionViewport = page.getRegionViewport(58)) != null) {
            this.renderRegionViewport(regionViewport);
        }
    }

    protected void renderRegionViewport(RegionViewport regionViewport) {
        this.currentBPPosition = 0;
        this.currentIPPosition = 0;
        RegionReference regionReference = regionViewport.getRegionReference();
        this.handleRegionTraits(regionViewport);
        this.startVParea(regionReference.getCTM(), regionViewport.getClipRectangle());
        if (regionReference.getRegionClass() == 58) {
            this.renderBodyRegion((BodyRegion)regionReference);
        } else {
            this.renderRegion(regionReference);
        }
        this.endVParea();
    }

    protected abstract void startVParea(CTM var1, Rectangle var2);

    protected abstract void endVParea();

    protected void handleRegionTraits(RegionViewport regionViewport) {
    }

    protected void renderRegion(RegionReference regionReference) {
        this.renderBlocks(null, regionReference.getBlocks());
    }

    protected void renderBodyRegion(BodyRegion bodyRegion) {
        Footnote footnote;
        MainReference mainReference;
        BeforeFloat beforeFloat = bodyRegion.getBeforeFloat();
        if (beforeFloat != null) {
            this.renderBeforeFloat(beforeFloat);
        }
        if ((mainReference = bodyRegion.getMainReference()) != null) {
            this.renderMainReference(mainReference);
        }
        if ((footnote = bodyRegion.getFootnote()) != null) {
            this.renderFootnote(footnote);
        }
    }

    protected void renderBeforeFloat(BeforeFloat beforeFloat) {
        List list = beforeFloat.getChildAreas();
        if (list != null) {
            this.renderBlocks(null, list);
            Block block = beforeFloat.getSeparator();
            if (block != null) {
                this.renderBlock(block);
            }
        }
    }

    protected void renderFootnote(Footnote footnote) {
        this.currentBPPosition += footnote.getTop();
        List list = footnote.getChildAreas();
        if (list != null) {
            Block block = footnote.getSeparator();
            if (block != null) {
                this.renderBlock(block);
            }
            this.renderBlocks(null, list);
        }
    }

    protected void renderMainReference(MainReference mainReference) {
        int n;
        Span span = null;
        List list = mainReference.getSpans();
        int n2 = n = this.currentBPPosition;
        int n3 = this.currentIPPosition;
        for (int i = 0; i < list.size(); ++i) {
            span = (Span)list.get(i);
            int n4 = span.getBidiLevel();
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n4 & 1) == 1) {
                this.currentIPPosition += span.getIPD();
                this.currentIPPosition += mainReference.getColumnGap();
            }
            for (int j = 0; j < span.getColumnCount(); ++j) {
                NormalFlow normalFlow = span.getNormalFlow(j);
                if (normalFlow == null) continue;
                this.currentBPPosition = n2;
                if ((n4 & 1) == 1) {
                    this.currentIPPosition -= normalFlow.getIPD();
                    this.currentIPPosition -= mainReference.getColumnGap();
                }
                this.renderFlow(normalFlow);
                if ((n4 & 1) != 0) continue;
                this.currentIPPosition += normalFlow.getIPD();
                this.currentIPPosition += mainReference.getColumnGap();
            }
            this.currentIPPosition = n3;
            n2 = this.currentBPPosition = n2 + span.getHeight();
        }
        this.currentBPPosition = n;
    }

    protected void renderFlow(NormalFlow normalFlow) {
        List list = normalFlow.getChildAreas();
        if (list != null) {
            this.renderBlocks(null, list);
        }
    }

    protected void handleBlockTraits(Block block) {
    }

    protected void renderBlockViewport(BlockViewport blockViewport, List list) {
        if (blockViewport.getPositioning() == 2) {
            int n = this.currentIPPosition;
            int n2 = this.currentBPPosition;
            Rectangle rectangle = null;
            if (blockViewport.hasClip()) {
                rectangle = new Rectangle(n, n2, blockViewport.getIPD(), blockViewport.getBPD());
            }
            CTM cTM = blockViewport.getCTM();
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.startVParea(cTM, rectangle);
            this.handleBlockTraits(blockViewport);
            this.renderBlocks(blockViewport, list);
            this.endVParea();
            this.currentIPPosition = n;
            this.currentBPPosition = n2;
        } else {
            int n = this.currentIPPosition;
            int n3 = this.currentBPPosition;
            this.handleBlockTraits(blockViewport);
            this.renderBlocks(blockViewport, list);
            this.currentIPPosition = n;
            this.currentBPPosition = n3 + blockViewport.getAllocBPD();
        }
    }

    protected abstract void renderReferenceArea(Block var1);

    protected void renderBlocks(Block block, List list) {
        int n = this.currentIPPosition;
        if (block != null && !block.getTraitAsBoolean(Trait.IS_VIEWPORT_AREA)) {
            this.currentBPPosition += block.getBorderAndPaddingWidthBefore();
        }
        int n2 = this.currentBPPosition;
        int n3 = this.currentIPPosition;
        this.containingBPPosition = this.currentBPPosition;
        this.containingIPPosition = this.currentIPPosition;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof Block) {
                this.currentIPPosition = n3;
                this.containingBPPosition = n2;
                this.containingIPPosition = n3;
                this.renderBlock((Block)e);
                this.containingBPPosition = n2;
                this.containingIPPosition = n3;
            } else if (e instanceof LineArea) {
                LineArea lineArea = (LineArea)e;
                if (block != null) {
                    int n4 = block.getBidiLevel();
                    this.currentIPPosition = n4 == -1 || (n4 & 1) == 0 ? (this.currentIPPosition += block.getStartIndent()) : (this.currentIPPosition += block.getEndIndent());
                }
                this.renderLineArea(lineArea);
                this.currentBPPosition += lineArea.getAllocBPD();
            }
            this.currentIPPosition = n;
        }
    }

    protected void renderBlock(Block block) {
        assert (block != null);
        List list = block.getChildAreas();
        if (block instanceof BlockViewport) {
            if (list != null) {
                this.renderBlockViewport((BlockViewport)block, list);
            } else {
                this.handleBlockTraits(block);
                this.currentBPPosition += block.getAllocBPD();
            }
        } else if (block.getTraitAsBoolean(Trait.IS_REFERENCE_AREA)) {
            this.renderReferenceArea(block);
        } else {
            int n = this.currentIPPosition;
            int n2 = this.currentBPPosition;
            this.currentIPPosition += block.getXOffset();
            this.currentBPPosition += block.getYOffset();
            this.currentBPPosition += block.getSpaceBefore();
            this.handleBlockTraits(block);
            if (list != null) {
                this.renderBlocks(block, list);
            }
            if (block.getPositioning() == 2) {
                this.currentBPPosition = n2;
            } else {
                this.currentIPPosition = n;
                this.currentBPPosition = n2 + block.getAllocBPD();
            }
        }
    }

    protected void renderLineArea(LineArea lineArea) {
        int n;
        List list = lineArea.getInlineAreas();
        int n2 = this.currentBPPosition;
        this.currentBPPosition += lineArea.getSpaceBefore();
        int n3 = lineArea.getBidiLevel();
        if (n3 >= 0) {
            if ((n3 & 1) == 0) {
                this.currentIPPosition += lineArea.getStartIndent();
            } else {
                this.currentIPPosition += lineArea.getEndIndent();
                n = this.computeInlinesOverflow(lineArea);
                if (n > 0) {
                    this.currentIPPosition -= n;
                }
            }
        } else {
            this.currentIPPosition += lineArea.getStartIndent();
        }
        int n4 = list.size();
        for (n = 0; n < n4; ++n) {
            InlineArea inlineArea = (InlineArea)list.get(n);
            this.renderInlineArea(inlineArea);
        }
        this.currentBPPosition = n2;
    }

    private int computeInlinesOverflow(LineArea lineArea) {
        List list = lineArea.getInlineAreas();
        int n = 0;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            InlineArea inlineArea = (InlineArea)list.get(i);
            n += inlineArea.getIPD();
        }
        return n - lineArea.getIPD();
    }

    protected void renderInlineArea(InlineArea inlineArea) {
        if (inlineArea instanceof TextArea) {
            this.renderText((TextArea)inlineArea);
        } else if (inlineArea instanceof WordArea) {
            this.renderWord((WordArea)inlineArea);
        } else if (inlineArea instanceof SpaceArea) {
            this.renderSpace((SpaceArea)inlineArea);
        } else if (inlineArea instanceof InlineParent) {
            this.renderInlineParent((InlineParent)inlineArea);
        } else if (inlineArea instanceof InlineBlockParent) {
            this.renderInlineBlockParent((InlineBlockParent)inlineArea);
        } else if (inlineArea instanceof Space) {
            this.renderInlineSpace((Space)inlineArea);
        } else if (inlineArea instanceof InlineViewport) {
            this.renderInlineViewport((InlineViewport)inlineArea);
        } else if (inlineArea instanceof Leader) {
            this.renderLeader((Leader)inlineArea);
        }
    }

    protected abstract void renderInlineAreaBackAndBorders(InlineArea var1);

    protected void renderInlineSpace(Space space) {
        this.renderInlineAreaBackAndBorders(space);
        this.currentIPPosition += space.getAllocIPD();
    }

    protected void renderLeader(Leader leader) {
        this.currentIPPosition += leader.getAllocIPD();
    }

    protected void renderText(TextArea textArea) {
        List<InlineArea> list = textArea.getChildAreas();
        int n = this.currentIPPosition;
        int n2 = this.currentBPPosition;
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            InlineArea inlineArea = list.get(i);
            this.renderInlineArea(inlineArea);
        }
        this.currentIPPosition = n + textArea.getAllocIPD();
    }

    protected void renderWord(WordArea wordArea) {
        this.currentIPPosition += wordArea.getAllocIPD();
    }

    protected void renderSpace(SpaceArea spaceArea) {
        this.currentIPPosition += spaceArea.getAllocIPD();
    }

    protected void renderInlineParent(InlineParent inlineParent) {
        int n;
        int n2;
        int n3;
        int n4 = inlineParent.getBidiLevel();
        List<InlineArea> list = inlineParent.getChildAreas();
        this.renderInlineAreaBackAndBorders(inlineParent);
        int n5 = this.currentIPPosition;
        int n6 = this.currentBPPosition;
        if (inlineParent instanceof FilledArea && (n4 & 1) != 0) {
            n3 = 0;
            int n7 = list.size();
            for (n2 = 0; n2 < n7; ++n2) {
                InlineArea inlineArea = list.get(n2);
                n3 += inlineArea.getAllocIPD();
            }
            n = inlineParent.getAllocIPD() - n3;
        } else {
            n = 0;
        }
        if (n4 == -1 || (n4 & 1) == 0) {
            this.currentIPPosition += inlineParent.getBorderAndPaddingWidthStart();
        } else {
            this.currentIPPosition += inlineParent.getBorderAndPaddingWidthEnd();
            if (n > 0) {
                this.currentIPPosition += n;
            }
        }
        this.currentBPPosition += inlineParent.getBlockProgressionOffset();
        n2 = list.size();
        for (n3 = 0; n3 < n2; ++n3) {
            InlineArea inlineArea = list.get(n3);
            this.renderInlineArea(inlineArea);
        }
        this.currentIPPosition = n5 + inlineParent.getAllocIPD();
        this.currentBPPosition = n6;
    }

    protected void renderInlineBlockParent(InlineBlockParent inlineBlockParent) {
        int n = inlineBlockParent.getBidiLevel();
        this.renderInlineAreaBackAndBorders(inlineBlockParent);
        this.currentIPPosition = n == -1 || (n & 1) == 0 ? (this.currentIPPosition += inlineBlockParent.getBorderAndPaddingWidthStart()) : (this.currentIPPosition += inlineBlockParent.getBorderAndPaddingWidthEnd());
        int n2 = this.currentBPPosition;
        this.currentBPPosition += inlineBlockParent.getBlockProgressionOffset();
        this.renderBlock(inlineBlockParent.getChildArea());
        this.currentBPPosition = n2;
    }

    protected void renderInlineViewport(InlineViewport inlineViewport) {
        Area area = inlineViewport.getContent();
        int n = this.currentBPPosition;
        this.currentBPPosition += inlineViewport.getBlockProgressionOffset();
        Rectangle2D rectangle2D = inlineViewport.getContentPosition();
        if (area instanceof Image) {
            this.renderImage((Image)area, rectangle2D);
        } else if (area instanceof Container) {
            this.renderContainer((Container)area);
        } else if (area instanceof ForeignObject) {
            this.renderForeignObject((ForeignObject)area, rectangle2D);
        } else if (area instanceof InlineBlockParent) {
            this.renderInlineBlockParent((InlineBlockParent)area);
        }
        this.currentIPPosition += inlineViewport.getAllocIPD();
        this.currentBPPosition = n;
    }

    public void renderImage(Image image, Rectangle2D rectangle2D) {
    }

    protected void renderContainer(Container container) {
        int n = this.currentIPPosition;
        int n2 = this.currentBPPosition;
        List list = container.getBlocks();
        this.renderBlocks(null, list);
        this.currentIPPosition = n;
        this.currentBPPosition = n2;
    }

    protected void renderForeignObject(ForeignObject foreignObject, Rectangle2D rectangle2D) {
    }

    public void renderXML(RendererContext rendererContext, Document document, String string) {
        XMLHandler xMLHandler = this.userAgent.getXMLHandlerRegistry().getXMLHandler((Renderer)this, string);
        if (xMLHandler != null) {
            try {
                XMLHandlerConfigurator xMLHandlerConfigurator = new XMLHandlerConfigurator(this.userAgent);
                xMLHandlerConfigurator.configure(rendererContext, string);
                xMLHandler.handleXML(rendererContext, document, string);
            }
            catch (Exception exception) {
                ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(rendererContext.getUserAgent().getEventBroadcaster());
                resourceEventProducer.foreignXMLProcessingError(this, document, string, exception);
            }
        } else {
            if (this.warnedXMLHandlers == null) {
                this.warnedXMLHandlers = new HashSet();
            }
            if (!this.warnedXMLHandlers.contains(string)) {
                this.warnedXMLHandlers.add(string);
                ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(rendererContext.getUserAgent().getEventBroadcaster());
                resourceEventProducer.foreignXMLNoHandler(this, document, string);
            }
        }
    }

    protected AffineTransform mptToPt(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        dArray[4] = dArray[4] / 1000.0;
        dArray[5] = dArray[5] / 1000.0;
        return new AffineTransform(dArray);
    }

    protected AffineTransform ptToMpt(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        dArray[4] = Math.round(dArray[4] * 1000.0);
        dArray[5] = Math.round(dArray[5] * 1000.0);
        return new AffineTransform(dArray);
    }
}

