/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.fop.afp.AFPDitheredRectanglePainter;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPRectanglePainter;
import org.apache.fop.afp.AFPResourceLevelDefaults;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.afp.AFPUnitConverter;
import org.apache.fop.afp.AbstractAFPPainter;
import org.apache.fop.afp.DataStream;
import org.apache.fop.afp.fonts.AFPFontCollection;
import org.apache.fop.afp.fonts.AFPPageFonts;
import org.apache.fop.afp.util.DefaultFOPResourceAccessor;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontEventAdapter;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.render.afp.AFPCustomizable;
import org.apache.fop.render.afp.AFPPainter;
import org.apache.fop.render.afp.AFPRendererConfigurator;
import org.apache.fop.render.afp.AFPShadingMode;
import org.apache.fop.render.afp.PageSegmentDescriptor;
import org.apache.fop.render.afp.extensions.AFPIncludeFormMap;
import org.apache.fop.render.afp.extensions.AFPInvokeMediumMap;
import org.apache.fop.render.afp.extensions.AFPPageOverlay;
import org.apache.fop.render.afp.extensions.AFPPageSegmentElement;
import org.apache.fop.render.afp.extensions.AFPPageSetup;
import org.apache.fop.render.afp.extensions.ExtensionPlacement;
import org.apache.fop.render.intermediate.AbstractBinaryWritingIFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;

public class AFPDocumentHandler
extends AbstractBinaryWritingIFDocumentHandler
implements AFPCustomizable {
    private AFPResourceManager resourceManager;
    private final AFPPaintingState paintingState;
    private final AFPUnitConverter unitConv;
    private DataStream dataStream;
    private Map<String, PageSegmentDescriptor> pageSegmentMap = new HashMap<String, PageSegmentDescriptor>();
    private Location location = Location.ELSEWHERE;
    private List<AFPPageSetup> deferredPageSequenceExtensions = new LinkedList<AFPPageSetup>();
    private AFPShadingMode shadingMode = AFPShadingMode.COLOR;

    public AFPDocumentHandler() {
        this.resourceManager = new AFPResourceManager();
        this.paintingState = new AFPPaintingState();
        this.unitConv = this.paintingState.getUnitConverter();
    }

    public boolean supportsPagesOutOfOrder() {
        return false;
    }

    public String getMimeType() {
        return "application/x-afp";
    }

    public IFDocumentHandlerConfigurator getConfigurator() {
        return new AFPRendererConfigurator(this.getUserAgent());
    }

    public void setDefaultFontInfo(FontInfo fontInfo) {
        FontManager fontManager = this.getUserAgent().getFactory().getFontManager();
        FontCollection[] fontCollectionArray = new FontCollection[]{new AFPFontCollection(this.getUserAgent().getEventBroadcaster(), null)};
        FontInfo fontInfo2 = fontInfo != null ? fontInfo : new FontInfo();
        fontInfo2.setEventListener(new FontEventAdapter(this.getUserAgent().getEventBroadcaster()));
        fontManager.setup(fontInfo2, fontCollectionArray);
        this.setFontInfo(fontInfo2);
    }

    AFPPaintingState getPaintingState() {
        return this.paintingState;
    }

    DataStream getDataStream() {
        return this.dataStream;
    }

    AFPResourceManager getResourceManager() {
        return this.resourceManager;
    }

    AbstractAFPPainter createRectanglePainter() {
        if (AFPShadingMode.DITHERED.equals(this.shadingMode)) {
            return new AFPDitheredRectanglePainter(this.getPaintingState(), this.getDataStream(), this.getResourceManager());
        }
        return new AFPRectanglePainter(this.getPaintingState(), this.getDataStream());
    }

    public void startDocument() throws IFException {
        super.startDocument();
        try {
            this.paintingState.setColor(Color.WHITE);
            this.dataStream = this.resourceManager.createDataStream(this.paintingState, this.outputStream);
            this.dataStream.startDocument();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startDocument()", iOException);
        }
    }

    public void startDocumentHeader() throws IFException {
        super.startDocumentHeader();
        this.location = Location.IN_DOCUMENT_HEADER;
    }

    public void endDocumentHeader() throws IFException {
        super.endDocumentHeader();
        this.location = Location.ELSEWHERE;
    }

    public void endDocument() throws IFException {
        try {
            this.dataStream.endDocument();
            this.dataStream = null;
            this.resourceManager.writeToStream();
            this.resourceManager = null;
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endDocument()", iOException);
        }
        super.endDocument();
    }

    public void startPageSequence(String string) throws IFException {
        try {
            this.dataStream.startPageGroup();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startPageSequence()", iOException);
        }
        this.location = Location.FOLLOWING_PAGE_SEQUENCE;
    }

    public void endPageSequence() throws IFException {
        try {
            Iterator<AFPPageSetup> iterator = this.deferredPageSequenceExtensions.iterator();
            while (iterator.hasNext()) {
                AFPPageSetup aFPPageSetup = iterator.next();
                iterator.remove();
                if ("no-operation".equals(aFPPageSetup.getElementName())) {
                    this.handleNOP(aFPPageSetup);
                    continue;
                }
                throw new UnsupportedOperationException("Don't know how to handle " + aFPPageSetup);
            }
            this.dataStream.endPageGroup();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endPageSequence()", iOException);
        }
        this.location = Location.ELSEWHERE;
    }

    private AffineTransform getBaseTransform() {
        AffineTransform affineTransform = new AffineTransform();
        double d = this.unitConv.mpt2units(1.0f);
        affineTransform.scale(d, d);
        return affineTransform;
    }

    public void startPage(int n, String string, String string2, Dimension dimension) throws IFException {
        this.location = Location.ELSEWHERE;
        this.paintingState.clear();
        AffineTransform affineTransform = this.getBaseTransform();
        this.paintingState.concatenate(affineTransform);
        int n2 = Math.round(this.unitConv.mpt2units(dimension.width));
        this.paintingState.setPageWidth(n2);
        int n3 = Math.round(this.unitConv.mpt2units(dimension.height));
        this.paintingState.setPageHeight(n3);
        int n4 = this.paintingState.getPageRotation();
        int n5 = this.paintingState.getResolution();
        this.dataStream.startPage(n2, n3, n4, n5, n5);
    }

    public void startPageHeader() throws IFException {
        super.startPageHeader();
        this.location = Location.IN_PAGE_HEADER;
    }

    public void endPageHeader() throws IFException {
        this.location = Location.ELSEWHERE;
        super.endPageHeader();
    }

    public IFPainter startPageContent() throws IFException {
        return new AFPPainter(this);
    }

    public void endPageContent() throws IFException {
    }

    public void endPage() throws IFException {
        try {
            AFPPageFonts aFPPageFonts = this.paintingState.getPageFonts();
            if (aFPPageFonts != null && !aFPPageFonts.isEmpty()) {
                this.dataStream.addFontsToCurrentPage(aFPPageFonts);
            }
            this.dataStream.endPage();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endPage()", iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleExtensionObject(Object object) throws IFException {
        if (object instanceof AFPPageSetup) {
            AFPPageSetup aFPPageSetup = (AFPPageSetup)object;
            String string = aFPPageSetup.getElementName();
            if ("tag-logical-element".equals(string)) {
                switch (this.location) {
                    case FOLLOWING_PAGE_SEQUENCE: 
                    case IN_PAGE_HEADER: {
                        String string2 = aFPPageSetup.getName();
                        String string3 = aFPPageSetup.getValue();
                        this.dataStream.createTagLogicalElement(string2, string3);
                        return;
                    }
                    default: {
                        throw new IFException("TLE extension must be in the page header or between page-sequence and the first page: " + aFPPageSetup, null);
                    }
                }
            }
            if ("no-operation".equals(string)) {
                switch (this.location) {
                    case FOLLOWING_PAGE_SEQUENCE: {
                        if (aFPPageSetup.getPlacement() == ExtensionPlacement.BEFORE_END) {
                            this.deferredPageSequenceExtensions.add(aFPPageSetup);
                            return;
                        }
                    }
                    case IN_PAGE_HEADER: 
                    case IN_DOCUMENT_HEADER: {
                        this.handleNOP(aFPPageSetup);
                        return;
                    }
                    default: {
                        throw new IFException("NOP extension must be in the document header, the page header or between page-sequence and the first page: " + aFPPageSetup, null);
                    }
                }
            }
            if (this.location != Location.IN_PAGE_HEADER) {
                throw new IFException("AFP page setup extension encountered outside the page header: " + aFPPageSetup, null);
            }
            if (!"include-page-segment".equals(string)) return;
            AFPPageSegmentElement.AFPPageSegmentSetup aFPPageSegmentSetup = (AFPPageSegmentElement.AFPPageSegmentSetup)aFPPageSetup;
            String string4 = aFPPageSegmentSetup.getName();
            String string5 = aFPPageSegmentSetup.getValue();
            String string6 = aFPPageSegmentSetup.getResourceSrc();
            this.pageSegmentMap.put(string5, new PageSegmentDescriptor(string4, string6));
            return;
        }
        if (object instanceof AFPPageOverlay) {
            AFPPageOverlay aFPPageOverlay = (AFPPageOverlay)object;
            if (this.location != Location.IN_PAGE_HEADER) {
                throw new IFException("AFP page overlay extension encountered outside the page header: " + aFPPageOverlay, null);
            }
            String string = aFPPageOverlay.getName();
            if (string == null) return;
            this.dataStream.createIncludePageOverlay(string, aFPPageOverlay.getX(), aFPPageOverlay.getY());
            return;
        }
        if (object instanceof AFPInvokeMediumMap) {
            if (this.location != Location.FOLLOWING_PAGE_SEQUENCE && this.location != Location.IN_PAGE_HEADER) {
                throw new IFException("AFP IMM extension must be between page-sequence and the first page or child of page-header: " + object, null);
            }
            AFPInvokeMediumMap aFPInvokeMediumMap = (AFPInvokeMediumMap)object;
            String string = aFPInvokeMediumMap.getName();
            if (string == null) return;
            this.dataStream.createInvokeMediumMap(string);
            return;
        }
        if (!(object instanceof AFPIncludeFormMap)) return;
        AFPIncludeFormMap aFPIncludeFormMap = (AFPIncludeFormMap)object;
        DefaultFOPResourceAccessor defaultFOPResourceAccessor = new DefaultFOPResourceAccessor(this.getUserAgent(), null, null);
        try {
            this.getResourceManager().createIncludedResource(aFPIncludeFormMap.getName(), aFPIncludeFormMap.getSrc(), defaultFOPResourceAccessor, (byte)-2);
            return;
        }
        catch (IOException iOException) {
            throw new IFException("I/O error while embedding form map resource: " + aFPIncludeFormMap.getName(), iOException);
        }
    }

    private void handleNOP(AFPPageSetup aFPPageSetup) {
        String string = aFPPageSetup.getContent();
        if (string != null) {
            this.dataStream.createNoOperation(string);
        }
    }

    public void setBitsPerPixel(int n) {
        this.paintingState.setBitsPerPixel(n);
    }

    public void setColorImages(boolean bl) {
        this.paintingState.setColorImages(bl);
    }

    public void setNativeImagesSupported(boolean bl) {
        this.paintingState.setNativeImagesSupported(bl);
    }

    public void setCMYKImagesSupported(boolean bl) {
        this.paintingState.setCMYKImagesSupported(bl);
    }

    public void setDitheringQuality(float f) {
        this.paintingState.setDitheringQuality(f);
    }

    public void setBitmapEncodingQuality(float f) {
        this.paintingState.setBitmapEncodingQuality(f);
    }

    public void setShadingMode(AFPShadingMode aFPShadingMode) {
        this.shadingMode = aFPShadingMode;
    }

    public void setResolution(int n) {
        this.paintingState.setResolution(n);
    }

    public void setLineWidthCorrection(float f) {
        this.paintingState.setLineWidthCorrection(f);
    }

    public int getResolution() {
        return this.paintingState.getResolution();
    }

    public void setGOCAEnabled(boolean bl) {
        this.paintingState.setGOCAEnabled(bl);
    }

    public boolean isGOCAEnabled() {
        return this.paintingState.isGOCAEnabled();
    }

    public void setStrokeGOCAText(boolean bl) {
        this.paintingState.setStrokeGOCAText(bl);
    }

    public boolean isStrokeGOCAText() {
        return this.paintingState.isStrokeGOCAText();
    }

    public void setWrapPSeg(boolean bl) {
        this.paintingState.setWrapPSeg(bl);
    }

    public void setFS45(boolean bl) {
        this.paintingState.setFS45(bl);
    }

    public boolean getWrapPSeg() {
        return this.paintingState.getWrapPSeg();
    }

    public boolean getFS45() {
        return this.paintingState.getFS45();
    }

    public void setDefaultResourceGroupFilePath(String string) {
        this.resourceManager.setDefaultResourceGroupFilePath(string);
    }

    public void setResourceLevelDefaults(AFPResourceLevelDefaults aFPResourceLevelDefaults) {
        this.resourceManager.setResourceLevelDefaults(aFPResourceLevelDefaults);
    }

    PageSegmentDescriptor getPageSegmentNameFor(String string) {
        return this.pageSegmentMap.get(string);
    }

    public void canEmbedJpeg(boolean bl) {
        this.paintingState.setCanEmbedJpeg(bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Location {
        ELSEWHERE,
        IN_DOCUMENT_HEADER,
        FOLLOWING_PAGE_SEQUENCE,
        IN_PAGE_HEADER;

    }
}

