/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.xmlgraphics.util.QName;

public class AFPForeignAttributeReader {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.xmlgraphics.afp");
    public static final QName RESOURCE_NAME = new QName("http://xmlgraphics.apache.org/fop/extensions/afp", "afp:resource-name");
    public static final QName RESOURCE_LEVEL = new QName("http://xmlgraphics.apache.org/fop/extensions/afp", "afp:resource-level");
    public static final QName RESOURCE_GROUP_FILE = new QName("http://xmlgraphics.apache.org/fop/extensions/afp", "afp:resource-group-file");

    public AFPResourceInfo getResourceInfo(Map map) {
        AFPResourceInfo aFPResourceInfo = new AFPResourceInfo();
        if (map != null && !map.isEmpty()) {
            AFPResourceLevel aFPResourceLevel;
            String string = (String)map.get(RESOURCE_NAME);
            if (string != null) {
                aFPResourceInfo.setName(string);
            }
            if ((aFPResourceLevel = this.getResourceLevel(map)) != null) {
                aFPResourceInfo.setLevel(aFPResourceLevel);
            }
        }
        return aFPResourceInfo;
    }

    public AFPResourceLevel getResourceLevel(Map map) {
        String string;
        AFPResourceLevel aFPResourceLevel = null;
        if (map != null && !map.isEmpty() && map.containsKey(RESOURCE_LEVEL) && (aFPResourceLevel = AFPResourceLevel.valueOf(string = (String)map.get(RESOURCE_LEVEL))) != null && aFPResourceLevel.isExternal()) {
            String string2;
            String string3 = (String)map.get(RESOURCE_GROUP_FILE);
            if (string3 == null) {
                String string4 = RESOURCE_GROUP_FILE + " not specified";
                LOG.error((Object)string4);
                throw new UnsupportedOperationException(string4);
            }
            File file = new File(string3);
            SecurityManager securityManager = System.getSecurityManager();
            try {
                if (securityManager != null) {
                    securityManager.checkWrite(file.getPath());
                }
            }
            catch (SecurityException securityException) {
                string2 = "unable to gain write access to external resource file: " + string3;
                LOG.error((Object)string2);
            }
            try {
                boolean bl = file.exists();
                if (bl) {
                    LOG.warn((Object)("overwriting external resource file: " + string3));
                }
                aFPResourceLevel.setExternalFilePath(string3);
            }
            catch (SecurityException securityException) {
                string2 = "unable to gain read access to external resource file: " + string3;
                LOG.error((Object)string2);
            }
        }
        return aFPResourceLevel;
    }
}

