/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt.viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.render.awt.viewer.Command;
import org.apache.fop.render.awt.viewer.GoToPageDialog;
import org.apache.fop.render.awt.viewer.PageChangeEvent;
import org.apache.fop.render.awt.viewer.PageChangeListener;
import org.apache.fop.render.awt.viewer.PreviewDialogAboutBox;
import org.apache.fop.render.awt.viewer.PreviewPanel;
import org.apache.fop.render.awt.viewer.Renderable;
import org.apache.fop.render.awt.viewer.StatusListener;
import org.apache.fop.render.awt.viewer.Translator;

public class PreviewDialog
extends JFrame
implements StatusListener {
    protected Translator translator;
    protected AWTRenderer renderer;
    protected FOUserAgent foUserAgent;
    protected float configuredTargetResolution;
    protected Renderable renderable;
    private JComboBox scale;
    private JLabel processStatus;
    private JLabel infoStatus;
    private PreviewPanel previewPanel;
    private DecimalFormat percentFormat = new DecimalFormat("###0.0#", new DecimalFormatSymbols(Locale.ENGLISH));

    public PreviewDialog(FOUserAgent fOUserAgent, Renderable renderable) {
        this.renderer = (AWTRenderer)fOUserAgent.getRendererOverride();
        this.foUserAgent = fOUserAgent;
        this.configuredTargetResolution = this.foUserAgent.getTargetResolution();
        this.renderable = renderable;
        this.translator = new Translator();
        Command command = new Command(this.translator.getString("Menu.Print"), "Print"){

            public void doit() {
                PreviewDialog.this.startPrinterJob(true);
            }
        };
        Command command2 = new Command(this.translator.getString("Menu.First.page"), "firstpg"){

            public void doit() {
                PreviewDialog.this.goToFirstPage();
            }
        };
        Command command3 = new Command(this.translator.getString("Menu.Prev.page"), "prevpg"){

            public void doit() {
                PreviewDialog.this.goToPreviousPage();
            }
        };
        Command command4 = new Command(this.translator.getString("Menu.Next.page"), "nextpg"){

            public void doit() {
                PreviewDialog.this.goToNextPage();
            }
        };
        Command command5 = new Command(this.translator.getString("Menu.Last.page"), "lastpg"){

            public void doit() {
                PreviewDialog.this.goToLastPage();
            }
        };
        Command command6 = new Command(this.translator.getString("Menu.Reload"), "reload"){

            public void doit() {
                PreviewDialog.this.previewPanel.reload();
            }
        };
        Command command7 = new Command(this.translator.getString("Menu.Debug"), "debug"){

            public void doit() {
                PreviewDialog.this.previewPanel.debug();
            }
        };
        Command command8 = new Command(this.translator.getString("Menu.About"), "fopLogo"){

            public void doit() {
                PreviewDialog.this.startHelpAbout();
            }
        };
        this.setTitle("FOP: AWT-" + this.translator.getString("Title.Preview"));
        this.setDefaultCloseOperation(2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.pack();
        this.setSize(dimension.width * 61 / 100, dimension.height * 9 / 10);
        this.previewPanel = new PreviewPanel(fOUserAgent, renderable, this.renderer);
        this.getContentPane().add((Component)this.previewPanel, "Center");
        this.previewPanel.addPageChangeListener(new PageChangeListener(){

            public void pageChanged(PageChangeEvent pageChangeEvent) {
                new ShowInfo().run();
            }
        });
        InputMap inputMap = this.previewPanel.getInputMap(2);
        ActionMap actionMap = this.previewPanel.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(34, 0), "nextPage");
        inputMap.put(KeyStroke.getKeyStroke(33, 0), "prevPage");
        inputMap.put(KeyStroke.getKeyStroke(36, 0), "firstPage");
        inputMap.put(KeyStroke.getKeyStroke(35, 0), "lastPage");
        this.previewPanel.getActionMap().put("nextPage", command4);
        this.previewPanel.getActionMap().put("prevPage", command3);
        this.previewPanel.getActionMap().put("firstPage", command2);
        this.previewPanel.getActionMap().put("lastPage", command5);
        this.scale = new JComboBox();
        this.scale.addItem(this.translator.getString("Menu.Fit.Window"));
        this.scale.addItem(this.translator.getString("Menu.Fit.Width"));
        this.scale.addItem("25%");
        this.scale.addItem("50%");
        this.scale.addItem("75%");
        this.scale.addItem("100%");
        this.scale.addItem("150%");
        this.scale.addItem("200%");
        this.scale.setMaximumSize(new Dimension(80, 24));
        this.scale.setPreferredSize(new Dimension(80, 24));
        this.scale.setSelectedItem("100%");
        this.scale.setEditable(true);
        this.scale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewDialog.this.scaleActionPerformed(actionEvent);
            }
        });
        this.setJMenuBar(this.setupMenu());
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(command);
        jToolBar.add(command6);
        jToolBar.addSeparator();
        jToolBar.add(command2);
        jToolBar.add(command3);
        jToolBar.add(command4);
        jToolBar.add(command5);
        jToolBar.addSeparator(new Dimension(20, 0));
        jToolBar.add(new JLabel(this.translator.getString("Menu.Zoom") + " "));
        jToolBar.add(this.scale);
        jToolBar.addSeparator();
        jToolBar.add(command7);
        jToolBar.addSeparator();
        jToolBar.add(command8);
        this.getContentPane().add((Component)jToolBar, "North");
        JPanel jPanel = new JPanel();
        this.processStatus = new JLabel();
        this.processStatus.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 0)));
        this.infoStatus = new JLabel();
        this.infoStatus.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 0)));
        jPanel.setLayout(new GridBagLayout());
        this.processStatus.setPreferredSize(new Dimension(200, 21));
        this.processStatus.setMinimumSize(new Dimension(200, 21));
        this.infoStatus.setPreferredSize(new Dimension(100, 21));
        this.infoStatus.setMinimumSize(new Dimension(100, 21));
        jPanel.add((Component)this.processStatus, new GridBagConstraints(0, 0, 1, 0, 2.0, 0.0, 10, 2, new Insets(0, 0, 0, 3), 0, 0));
        jPanel.add((Component)this.infoStatus, new GridBagConstraints(1, 0, 1, 0, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)jPanel, "South");
    }

    public static PreviewDialog createPreviewDialog(FOUserAgent fOUserAgent, Renderable renderable, boolean bl) {
        PreviewDialog previewDialog = new PreviewDialog(fOUserAgent, renderable);
        if (bl) {
            previewDialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = previewDialog.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        previewDialog.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        previewDialog.setStatus(previewDialog.translator.getString("Status.Build.FO.tree"));
        previewDialog.setVisible(true);
        return previewDialog;
    }

    public PreviewDialog(FOUserAgent fOUserAgent) {
        this(fOUserAgent, null);
    }

    private JMenuBar setupMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(this.translator.getString("Menu.File"));
        jMenu.setMnemonic(70);
        jMenu.add(new Command(this.translator.getString("Menu.Print"), 80){

            public void doit() {
                PreviewDialog.this.startPrinterJob(true);
            }
        });
        if (this.renderable != null) {
            jMenu.add(new Command(this.translator.getString("Menu.Reload"), 82){

                public void doit() {
                    PreviewDialog.this.reload();
                }
            });
        }
        jMenu.addSeparator();
        jMenu.add(new Command(this.translator.getString("Menu.Exit"), 88){

            public void doit() {
                PreviewDialog.this.dispose();
            }
        });
        jMenuBar.add(jMenu);
        jMenu = new JMenu(this.translator.getString("Menu.View"));
        jMenu.setMnemonic(86);
        jMenu.add(new Command(this.translator.getString("Menu.First.page"), 70){

            public void doit() {
                PreviewDialog.this.goToFirstPage();
            }
        });
        jMenu.add(new Command(this.translator.getString("Menu.Prev.page"), 80){

            public void doit() {
                PreviewDialog.this.goToPreviousPage();
            }
        });
        jMenu.add(new Command(this.translator.getString("Menu.Next.page"), 78){

            public void doit() {
                PreviewDialog.this.goToNextPage();
            }
        });
        jMenu.add(new Command(this.translator.getString("Menu.Last.page"), 76){

            public void doit() {
                PreviewDialog.this.goToLastPage();
            }
        });
        jMenu.add(new Command(this.translator.getString("Menu.Go.to.Page"), 71){

            public void doit() {
                PreviewDialog.this.showGoToPageDialog();
            }
        });
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu(this.translator.getString("Menu.Zoom"));
        jMenu2.setMnemonic(90);
        jMenu2.add(new Command("25%", 0){

            public void doit() {
                PreviewDialog.this.setScale(25.0);
            }
        });
        jMenu2.add(new Command("50%", 0){

            public void doit() {
                PreviewDialog.this.setScale(50.0);
            }
        });
        jMenu2.add(new Command("75%", 0){

            public void doit() {
                PreviewDialog.this.setScale(75.0);
            }
        });
        jMenu2.add(new Command("100%", 0){

            public void doit() {
                PreviewDialog.this.setScale(100.0);
            }
        });
        jMenu2.add(new Command("150%", 0){

            public void doit() {
                PreviewDialog.this.setScale(150.0);
            }
        });
        jMenu2.add(new Command("200%", 0){

            public void doit() {
                PreviewDialog.this.setScale(200.0);
            }
        });
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        jMenu.add(new Command(this.translator.getString("Menu.Default.zoom"), 68){

            public void doit() {
                PreviewDialog.this.setScale(100.0);
            }
        });
        jMenu.add(new Command(this.translator.getString("Menu.Fit.Window"), 70){

            public void doit() {
                PreviewDialog.this.setScaleToFitWindow();
            }
        });
        jMenu.add(new Command(this.translator.getString("Menu.Fit.Width"), 87){

            public void doit() {
                PreviewDialog.this.setScaleToFitWidth();
            }
        });
        jMenu.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new Command(this.translator.getString("Menu.Single"), 83){

            public void doit() {
                PreviewDialog.this.previewPanel.setDisplayMode(1);
            }
        });
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(new Command(this.translator.getString("Menu.Continuous"), 67){

            public void doit() {
                PreviewDialog.this.previewPanel.setDisplayMode(2);
            }
        });
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(new Command(this.translator.getString("Menu.Facing"), 0){

            public void doit() {
                PreviewDialog.this.previewPanel.setDisplayMode(3);
            }
        });
        jRadioButtonMenuItem.setSelected(true);
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem3);
        jMenu.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem2);
        jMenu.add(jRadioButtonMenuItem3);
        jMenuBar.add(jMenu);
        jMenu = new JMenu(this.translator.getString("Menu.Help"));
        jMenu.setMnemonic(72);
        jMenu.add(new Command(this.translator.getString("Menu.About"), 65){

            public void doit() {
                PreviewDialog.this.startHelpAbout();
            }
        });
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    public void notifyRendererStopped() {
        this.reload();
    }

    private void reload() {
        this.setStatus(this.translator.getString("Status.Show"));
        this.previewPanel.reload();
    }

    public void goToPage(int n) {
        if (n != this.previewPanel.getPage()) {
            this.previewPanel.setPage(n);
            this.notifyPageRendered();
        }
    }

    public void goToPreviousPage() {
        int n = this.previewPanel.getPage();
        if (n > 0) {
            this.goToPage(n - 1);
        }
    }

    public void goToNextPage() {
        int n = this.previewPanel.getPage();
        if (n < this.renderer.getNumberOfPages() - 1) {
            this.goToPage(n + 1);
        }
    }

    public void goToFirstPage() {
        this.goToPage(0);
    }

    public void goToLastPage() {
        this.goToPage(this.renderer.getNumberOfPages() - 1);
    }

    private void startHelpAbout() {
        PreviewDialogAboutBox previewDialogAboutBox = new PreviewDialogAboutBox((Frame)this, this.translator);
        Dimension dimension = previewDialogAboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        previewDialogAboutBox.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        previewDialogAboutBox.setVisible(true);
    }

    private void showGoToPageDialog() {
        int n = this.previewPanel.getPage();
        GoToPageDialog goToPageDialog = new GoToPageDialog((Frame)this, this.translator.getString("Menu.Go.to.Page"), this.translator);
        goToPageDialog.setLocation((int)this.getLocation().getX() + 50, (int)this.getLocation().getY() + 50);
        goToPageDialog.setVisible(true);
        n = goToPageDialog.getPageNumber();
        if (n < 1 || n > this.renderer.getNumberOfPages()) {
            return;
        }
        this.goToPage(--n);
    }

    public void setScale(double d) {
        this.scale.setSelectedItem(this.percentFormat.format(d) + "%");
        this.previewPanel.setScaleFactor(d / 100.0);
    }

    public void setScaleToFitWindow() {
        try {
            this.setScale(this.previewPanel.getScaleToFitWindow() * 100.0);
        }
        catch (FOPException fOPException) {
            fOPException.printStackTrace();
        }
    }

    public void setScaleToFitWidth() {
        try {
            this.setScale(this.previewPanel.getScaleToFitWidth() * 100.0);
        }
        catch (FOPException fOPException) {
            fOPException.printStackTrace();
        }
    }

    private void scaleActionPerformed(ActionEvent actionEvent) {
        int n = this.scale.getSelectedIndex();
        if (n == 0) {
            this.setScaleToFitWindow();
        } else if (n == 1) {
            this.setScaleToFitWidth();
        } else {
            String string = (String)this.scale.getSelectedItem();
            this.setScale(Double.parseDouble(string.substring(0, string.indexOf(37))));
        }
    }

    public void startPrinterJob(boolean bl) {
        float f = this.foUserAgent.getTargetResolution();
        this.foUserAgent.setTargetResolution(this.configuredTargetResolution);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPageable(this.renderer);
        if (!bl || printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }
        this.foUserAgent.setTargetResolution(f);
    }

    public void setStatus(String string) {
        SwingUtilities.invokeLater(new ShowStatus(string));
    }

    public void notifyPageRendered() {
        SwingUtilities.invokeLater(new ShowInfo());
    }

    public void reportException(Exception exception) {
        String string = this.translator.getString("Exception.Occured");
        this.setStatus(string);
        JOptionPane.showMessageDialog(this.getContentPane(), "<html><b>" + string + ":</b><br>" + exception.getClass().getName() + "<br>" + exception.getMessage() + "</html>", this.translator.getString("Exception.Error"), 0);
    }

    private class ShowInfo
    implements Runnable {
        private ShowInfo() {
        }

        public void run() {
            String string = PreviewDialog.this.translator.getString("Status.Page") + " " + (PreviewDialog.this.previewPanel.getPage() + 1) + " " + PreviewDialog.this.translator.getString("Status.of") + " " + PreviewDialog.this.renderer.getNumberOfPages();
            PreviewDialog.this.infoStatus.setText(string);
        }
    }

    private class ShowStatus
    implements Runnable {
        private String message;

        public ShowStatus(String string) {
            this.message = string;
        }

        public void run() {
            PreviewDialog.this.processStatus.setText(this.message.toString());
        }
    }
}

