/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt.viewer;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RectangularShape;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.PageViewport;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.render.awt.viewer.ImageProxyPanel;
import org.apache.fop.render.awt.viewer.PageChangeEvent;
import org.apache.fop.render.awt.viewer.PageChangeListener;
import org.apache.fop.render.awt.viewer.Renderable;

public class PreviewPanel
extends JPanel {
    public static final int SINGLE = 1;
    public static final int CONTINUOUS = 2;
    public static final int CONT_FACING = 3;
    private static final int BORDER_SPACING = 10;
    private JScrollPane previewArea;
    private AWTRenderer renderer;
    protected FOUserAgent foUserAgent;
    protected Renderable renderable;
    private int currentPage = 0;
    private int firstPage = 0;
    private int pageRange = 1;
    private int displayMode = 1;
    private ImageProxyPanel[] pagePanels = null;
    private JPanel gridPanel = null;
    private Reloader reloader;
    private ViewportScroller scroller;

    public PreviewPanel(FOUserAgent fOUserAgent, Renderable renderable, AWTRenderer aWTRenderer) {
        super(new GridLayout(1, 1));
        this.renderable = renderable;
        this.renderer = aWTRenderer;
        this.foUserAgent = fOUserAgent;
        this.foUserAgent.setTargetResolution(Toolkit.getDefaultToolkit().getScreenResolution());
        this.gridPanel = new JPanel();
        this.gridPanel.setLayout(new GridLayout(0, 1));
        this.previewArea = new JScrollPane(this.gridPanel);
        this.previewArea.getViewport().setBackground(Color.gray);
        this.previewArea.getVerticalScrollBar().addAdjustmentListener(new PageNumberListener());
        this.scroller = new ViewportScroller(this.previewArea.getViewport());
        this.previewArea.addMouseListener(this.scroller);
        this.previewArea.addMouseMotionListener(this.scroller);
        this.previewArea.setMinimumSize(new Dimension(50, 50));
        this.add(this.previewArea);
    }

    public int getPage() {
        return this.currentPage;
    }

    public void setPage(int n) {
        int n2 = this.currentPage;
        if (this.displayMode == 2 || this.displayMode == 3) {
            this.currentPage = n;
            this.gridPanel.scrollRectToVisible(this.pagePanels[this.currentPage].getBounds());
        } else {
            this.firstPage = this.currentPage = n;
        }
        this.showPage();
        this.firePageChange(n2, this.currentPage);
    }

    public void setDisplayMode(int n) {
        if (n != this.displayMode) {
            this.displayMode = n;
            this.gridPanel.setLayout(new GridLayout(0, this.displayMode == 3 ? 2 : 1));
            this.reload();
        }
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public synchronized void reload() {
        if (this.reloader == null || !this.reloader.isAlive()) {
            this.reloader = new Reloader();
            this.reloader.start();
        }
    }

    void debug() {
        this.renderer.debug = !this.renderer.debug;
        this.reload();
    }

    public void addPageChangeListener(PageChangeListener pageChangeListener) {
        this.listenerList.add(PageChangeListener.class, pageChangeListener);
    }

    public void removePageChangeListener(PageChangeListener pageChangeListener) {
        this.listenerList.remove(PageChangeListener.class, pageChangeListener);
    }

    protected void firePageChange(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        PageChangeEvent pageChangeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PageChangeListener.class) continue;
            if (pageChangeEvent == null) {
                pageChangeEvent = new PageChangeEvent(this, n2, n);
            }
            ((PageChangeListener)objectArray[i + 1]).pageChanged(pageChangeEvent);
        }
    }

    public void setScaleFactor(double d) {
        this.renderer.setScaleFactor(d);
        this.reload();
    }

    public double getScaleToFitWindow() throws FOPException {
        Dimension dimension = this.previewArea.getViewport().getExtentSize();
        return this.getScaleToFit(dimension.getWidth() - 20.0, dimension.getHeight() - 20.0);
    }

    public double getScaleToFitWidth() throws FOPException {
        Dimension dimension = this.previewArea.getViewport().getExtentSize();
        return this.getScaleToFit(dimension.getWidth() - 20.0, Double.MAX_VALUE);
    }

    public double getScaleToFit(double d, double d2) throws FOPException {
        PageViewport pageViewport = this.renderer.getPageViewport(this.currentPage);
        Rectangle rectangle = pageViewport.getViewArea();
        float f = Toolkit.getDefaultToolkit().getScreenResolution();
        float f2 = f / 72.0f;
        double d3 = d / (((RectangularShape)rectangle).getWidth() / 1000.0) / (double)f2;
        double d4 = d2 / (((RectangularShape)rectangle).getHeight() / 1000.0) / (double)f2;
        return Math.min(this.displayMode == 3 ? d3 / 2.0 : d3, d4);
    }

    public synchronized void showPage() {
        ShowPageImage showPageImage = new ShowPageImage();
        if (SwingUtilities.isEventDispatchThread()) {
            showPageImage.run();
        } else {
            SwingUtilities.invokeLater(showPageImage);
        }
    }

    static /* synthetic */ ImageProxyPanel[] access$402(PreviewPanel previewPanel, ImageProxyPanel[] imageProxyPanelArray) {
        previewPanel.pagePanels = imageProxyPanelArray;
        return imageProxyPanelArray;
    }

    private class ShowPageImage
    implements Runnable {
        private ShowPageImage() {
        }

        public void run() {
            for (int i = PreviewPanel.this.firstPage; i < PreviewPanel.this.firstPage + PreviewPanel.this.pageRange; ++i) {
                PreviewPanel.this.pagePanels[i - PreviewPanel.this.firstPage].setPage(i);
            }
            PreviewPanel.this.revalidate();
        }
    }

    private class PageNumberListener
    implements AdjustmentListener {
        private PageNumberListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (PreviewPanel.this.displayMode == 2 || PreviewPanel.this.displayMode == 3) {
                Adjustable adjustable = adjustmentEvent.getAdjustable();
                int n = adjustmentEvent.getValue();
                int n2 = adjustable.getMinimum();
                int n3 = adjustable.getMaximum();
                int n4 = PreviewPanel.this.renderer.getNumberOfPages() * n / (n3 - n2);
                if (n4 != PreviewPanel.this.currentPage) {
                    int n5 = PreviewPanel.this.currentPage;
                    PreviewPanel.this.currentPage = n4;
                    PreviewPanel.this.firePageChange(n5, PreviewPanel.this.currentPage);
                }
            }
        }
    }

    private class Reloader
    extends Thread {
        private Reloader() {
        }

        public void run() {
            if (!PreviewPanel.this.renderer.isRenderingDone()) {
                JOptionPane.showMessageDialog(PreviewPanel.this.previewArea, "Cannot perform the requested operation until all page are rendered. Please wait", "Please wait ", 1);
                return;
            }
            PreviewPanel.access$402(PreviewPanel.this, null);
            int n = PreviewPanel.this.currentPage;
            PreviewPanel.this.currentPage = 0;
            PreviewPanel.this.gridPanel.removeAll();
            switch (PreviewPanel.this.displayMode) {
                case 3: {
                    PreviewPanel.this.gridPanel.add(new JLabel(""));
                }
                case 2: {
                    PreviewPanel.this.currentPage = 0;
                    PreviewPanel.this.firstPage = 0;
                    PreviewPanel.this.pageRange = PreviewPanel.this.renderer.getNumberOfPages();
                    break;
                }
                default: {
                    PreviewPanel.this.currentPage = 0;
                    PreviewPanel.this.firstPage = 0;
                    PreviewPanel.this.pageRange = 1;
                }
            }
            PreviewPanel.access$402(PreviewPanel.this, new ImageProxyPanel[PreviewPanel.this.pageRange]);
            for (int i = 0; i < PreviewPanel.this.pageRange; ++i) {
                ((PreviewPanel)PreviewPanel.this).pagePanels[i] = new ImageProxyPanel(PreviewPanel.this.renderer, i + PreviewPanel.this.firstPage);
                PreviewPanel.this.pagePanels[i].setBorder(new EmptyBorder(10, 10, 10, 10));
                PreviewPanel.this.gridPanel.add(PreviewPanel.this.pagePanels[i]);
            }
            try {
                if (PreviewPanel.this.renderable != null) {
                    PreviewPanel.this.renderer.clearViewportList();
                    PreviewPanel.this.renderable.renderTo(PreviewPanel.this.foUserAgent, "application/X-fop-awt-preview");
                }
            }
            catch (FOPException fOPException) {
                fOPException.printStackTrace();
            }
            PreviewPanel.this.setPage(n);
        }
    }

    private class ViewportScroller
    implements MouseListener,
    MouseMotionListener {
        private final JViewport viewport;
        private int startPosX = 0;
        private int startPosY = 0;

        ViewportScroller(JViewport jViewport) {
            this.viewport = jViewport;
        }

        public synchronized void mouseDragged(MouseEvent mouseEvent) {
            if (this.viewport == null) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n - this.startPosX;
            int n4 = n2 - this.startPosY;
            int n5 = this.viewport.getExtentSize().width;
            int n6 = this.viewport.getExtentSize().height;
            int n7 = this.viewport.getViewSize().width;
            int n8 = this.viewport.getViewSize().height;
            Point point = this.viewport.getViewPosition();
            int n9 = Math.max(0, Math.min(n7 - n5, point.x - n3));
            int n10 = Math.max(0, Math.min(n8 - n6, point.y - n4));
            this.viewport.setViewPosition(new Point(n9, n10));
            this.startPosX = n;
            this.startPosY = n2;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.startPosX = mouseEvent.getX();
            this.startPosY = mouseEvent.getY();
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

