/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.geom.AffineTransform;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.TransformListHandler;
import org.apache.batik.parser.TransformListParser;

public class AffineTransformArrayParser
implements TransformListHandler {
    private static final AffineTransform[] EMPTY_ARRAY = new AffineTransform[0];
    private List transforms;

    public static AffineTransform[] createAffineTransform(Reader reader) throws ParseException {
        TransformListParser transformListParser = new TransformListParser();
        AffineTransformArrayParser affineTransformArrayParser = new AffineTransformArrayParser();
        transformListParser.setTransformListHandler((TransformListHandler)affineTransformArrayParser);
        transformListParser.parse(reader);
        return affineTransformArrayParser.getAffineTransforms();
    }

    public static AffineTransform[] createAffineTransform(String string) throws ParseException {
        if (string == null) {
            return EMPTY_ARRAY;
        }
        TransformListParser transformListParser = new TransformListParser();
        AffineTransformArrayParser affineTransformArrayParser = new AffineTransformArrayParser();
        transformListParser.setTransformListHandler((TransformListHandler)affineTransformArrayParser);
        transformListParser.parse(string);
        return affineTransformArrayParser.getAffineTransforms();
    }

    public AffineTransform[] getAffineTransforms() {
        if (this.transforms == null) {
            return null;
        }
        int n = this.transforms.size();
        return this.transforms.toArray(new AffineTransform[n]);
    }

    public void startTransformList() throws ParseException {
        this.transforms = new ArrayList();
    }

    public void matrix(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
        this.transforms.add(new AffineTransform(f, f2, f3, f4, f5, f6));
    }

    public void rotate(float f) throws ParseException {
        this.transforms.add(AffineTransform.getRotateInstance(Math.toRadians(f)));
    }

    public void rotate(float f, float f2, float f3) throws ParseException {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(f), f2, f3);
        this.transforms.add(affineTransform);
    }

    public void translate(float f) throws ParseException {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, 0.0);
        this.transforms.add(affineTransform);
    }

    public void translate(float f, float f2) throws ParseException {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        this.transforms.add(affineTransform);
    }

    public void scale(float f) throws ParseException {
        this.transforms.add(AffineTransform.getScaleInstance(f, f));
    }

    public void scale(float f, float f2) throws ParseException {
        this.transforms.add(AffineTransform.getScaleInstance(f, f2));
    }

    public void skewX(float f) throws ParseException {
        this.transforms.add(AffineTransform.getShearInstance(Math.tan(Math.toRadians(f)), 0.0));
    }

    public void skewY(float f) throws ParseException {
        this.transforms.add(AffineTransform.getShearInstance(0.0, Math.tan(Math.toRadians(f))));
    }

    public void endTransformList() throws ParseException {
    }
}

