/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.util.List;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.render.java2d.CustomFontMetricsMapper;

public class ConfiguredFontCollection
implements FontCollection {
    private static Log log = LogFactory.getLog(ConfiguredFontCollection.class);
    private FontResolver fontResolver;
    private List embedFontInfoList;

    public ConfiguredFontCollection(FontResolver fontResolver, List list, boolean bl) {
        this.fontResolver = fontResolver;
        if (this.fontResolver == null) {
            this.fontResolver = FontManager.createMinimalFontResolver(bl);
        }
        this.embedFontInfoList = list;
    }

    public int setup(int n, FontInfo fontInfo) {
        int n2 = n;
        if (this.embedFontInfoList == null || this.embedFontInfoList.size() < 1) {
            log.debug((Object)"No user configured fonts found.");
            return n2;
        }
        String string = null;
        for (int i = 0; i < this.embedFontInfoList.size(); ++i) {
            EmbedFontInfo embedFontInfo = (EmbedFontInfo)this.embedFontInfoList.get(i);
            String string2 = embedFontInfo.getEmbedFile();
            string = "F" + n2;
            ++n2;
            try {
                Object object;
                CustomFontMetricsMapper customFontMetricsMapper = null;
                String string3 = embedFontInfo.getMetricsFile();
                if (string3 != null) {
                    object = new LazyFont(embedFontInfo, this.fontResolver);
                    Source source = this.fontResolver.resolve(embedFontInfo.getEmbedFile());
                    customFontMetricsMapper = new CustomFontMetricsMapper((LazyFont)object, source);
                } else {
                    object = FontLoader.loadFont(string2, null, true, embedFontInfo.getEmbeddingMode(), EncodingMode.AUTO, embedFontInfo.getKerning(), embedFontInfo.getAdvanced(), this.fontResolver);
                    customFontMetricsMapper = new CustomFontMetricsMapper((CustomFont)object);
                }
                fontInfo.addMetrics(string, customFontMetricsMapper);
                object = embedFontInfo.getFontTriplets();
                for (int j = 0; j < object.size(); ++j) {
                    FontTriplet fontTriplet = (FontTriplet)object.get(j);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Registering: " + fontTriplet + " under " + string));
                    }
                    fontInfo.addFontProperties(string, fontTriplet);
                }
                continue;
            }
            catch (Exception exception) {
                log.warn((Object)("Unable to load custom font from file '" + string2 + "'"), (Throwable)exception);
            }
        }
        return n2;
    }
}

