/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.pcl.PCLGenerator;
import org.apache.fop.render.pcl.PCLGraphics2D;
import org.apache.fop.render.pcl.PCLRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.util.UnitConv;

public class PCLImageHandlerGraphics2D
implements ImageHandler {
    private static Log log = LogFactory.getLog(PCLImageHandlerGraphics2D.class);

    public int getPriority() {
        return 400;
    }

    public Class getSupportedImageClass() {
        return ImageGraphics2D.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return new ImageFlavor[]{ImageFlavor.GRAPHICS2D};
    }

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        PCLGraphics2D pCLGraphics2D;
        AffineTransform affineTransform;
        Object object;
        PCLRenderingContext pCLRenderingContext = (PCLRenderingContext)renderingContext;
        ImageGraphics2D imageGraphics2D = (ImageGraphics2D)image;
        Dimension dimension = imageGraphics2D.getSize().getDimensionMpt();
        PCLGenerator pCLGenerator = pCLRenderingContext.getPCLGenerator();
        Point2D point2D = pCLRenderingContext.transformedPoint(rectangle.x, rectangle.y);
        pCLGenerator.setCursorPos(point2D.getX(), point2D.getY());
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PCLGenerator pCLGenerator2 = new PCLGenerator((OutputStream)byteArrayOutputStream, pCLGenerator.getMaximumBitmapResolution());
        pCLGenerator2.setDitheringQuality(pCLGenerator.getDitheringQuality());
        try {
            object = (GraphicContext)pCLRenderingContext.getGraphicContext().clone();
            affineTransform = new AffineTransform();
            affineTransform.scale(0.001, 0.001);
            object.setTransform(affineTransform);
            pCLGraphics2D = new PCLGraphics2D(pCLGenerator2);
            pCLGraphics2D.setGraphicContext((GraphicContext)object);
            pCLGraphics2D.setClippingDisabled(false);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
            imageGraphics2D.getGraphics2DImagePainter().paint((Graphics2D)((Object)pCLGraphics2D), (Rectangle2D)double_);
            pCLGenerator.writeCommand("*c" + pCLGenerator.formatDouble4((float)rectangle.width / 100.0f) + "x" + pCLGenerator.formatDouble4((float)rectangle.height / 100.0f) + "Y");
            pCLGenerator.writeCommand("*c0T");
            pCLGenerator.enterHPGL2Mode(false);
            pCLGenerator.writeText("\nIN;");
            pCLGenerator.writeText("SP1;");
            double d = dimension.getWidth() / UnitConv.mm2pt((double)(dimension.getWidth() * 0.025));
            pCLGenerator.writeText("SC0," + pCLGenerator.formatDouble4(d) + ",0,-" + pCLGenerator.formatDouble4(d) + ",2;");
            pCLGenerator.writeText("IR0,100,0,100;");
            pCLGenerator.writeText("PU;PA0,0;\n");
            byteArrayOutputStream.writeTo(pCLGenerator.getOutputStream());
            pCLGenerator.writeText("\n");
            pCLGenerator.enterPCLMode(false);
            bl = true;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            log.debug((Object)("Cannot paint graphic natively. Falling back to bitmap painting. Reason: " + unsupportedOperationException.getMessage()));
        }
        if (!bl) {
            object = renderingContext.getUserAgent();
            affineTransform = ((FOUserAgent)object).getFactory().getImageManager();
            try {
                pCLGraphics2D = (ImageRendered)affineTransform.convertImage((Image)imageGraphics2D, new ImageFlavor[]{ImageFlavor.RENDERED_IMAGE});
            }
            catch (ImageException imageException) {
                throw new IOException("Image conversion error while converting the image to a bitmap as a fallback measure: " + imageException.getMessage());
            }
            pCLGenerator.paintBitmap(pCLGraphics2D.getRenderedImage(), new Dimension(rectangle.width, rectangle.height), pCLRenderingContext.isSourceTransparencyEnabled());
        }
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        String string;
        boolean bl;
        boolean bl2 = bl = (image == null || image instanceof ImageGraphics2D) && renderingContext instanceof PCLRenderingContext;
        if (bl && ImageHandlerUtil.isConversionModeBitmap(string = (String)renderingContext.getHint(ImageHandlerUtil.CONVERSION_MODE))) {
            return false;
        }
        return bl;
    }
}

