/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.render.pdf.PDFEventProducer;

final class FOToPDFRoleMap {
    private static final Map<String, PDFName> STANDARD_STRUCTURE_TYPES = new HashMap<String, PDFName>();
    private static final Map<String, Mapper> DEFAULT_MAPPINGS = new HashMap<String, Mapper>();
    private static final PDFName THEAD;
    private static final PDFName NON_STRUCT;

    private static void addStructureType(String string) {
        STANDARD_STRUCTURE_TYPES.put(string, new PDFName(string));
    }

    private static void addMapping(String string, String string2) {
        PDFName pDFName = STANDARD_STRUCTURE_TYPES.get(string2);
        assert (pDFName != null);
        FOToPDFRoleMap.addMapping(string, new SimpleMapper(pDFName));
    }

    private static void addMapping(String string, Mapper mapper) {
        DEFAULT_MAPPINGS.put(string, mapper);
    }

    public static PDFName mapFormattingObject(String string, String string2, PDFObject pDFObject, EventBroadcaster eventBroadcaster) {
        PDFName pDFName = null;
        if (string2 == null) {
            pDFName = FOToPDFRoleMap.getDefaultMappingFor(string, pDFObject);
        } else {
            pDFName = STANDARD_STRUCTURE_TYPES.get(string2);
            if (pDFName == null) {
                pDFName = FOToPDFRoleMap.getDefaultMappingFor(string, pDFObject);
                PDFEventProducer.Provider.get(eventBroadcaster).nonStandardStructureType(string, string, string2, pDFName.toString().substring(1));
            }
        }
        assert (pDFName != null);
        return pDFName;
    }

    private static PDFName getDefaultMappingFor(String string, PDFObject pDFObject) {
        Mapper mapper = DEFAULT_MAPPINGS.get(string);
        if (mapper != null) {
            return mapper.getStructureType(pDFObject);
        }
        return NON_STRUCT;
    }

    private FOToPDFRoleMap() {
    }

    static {
        FOToPDFRoleMap.addStructureType("Document");
        FOToPDFRoleMap.addStructureType("Part");
        FOToPDFRoleMap.addStructureType("Art");
        FOToPDFRoleMap.addStructureType("Sect");
        FOToPDFRoleMap.addStructureType("Div");
        FOToPDFRoleMap.addStructureType("BlockQuote");
        FOToPDFRoleMap.addStructureType("Caption");
        FOToPDFRoleMap.addStructureType("TOC");
        FOToPDFRoleMap.addStructureType("TOCI");
        FOToPDFRoleMap.addStructureType("Index");
        FOToPDFRoleMap.addStructureType("NonStruct");
        FOToPDFRoleMap.addStructureType("Private");
        FOToPDFRoleMap.addStructureType("H");
        FOToPDFRoleMap.addStructureType("H1");
        FOToPDFRoleMap.addStructureType("H2");
        FOToPDFRoleMap.addStructureType("H3");
        FOToPDFRoleMap.addStructureType("H4");
        FOToPDFRoleMap.addStructureType("H5");
        FOToPDFRoleMap.addStructureType("H6");
        FOToPDFRoleMap.addStructureType("P");
        FOToPDFRoleMap.addStructureType("L");
        FOToPDFRoleMap.addStructureType("LI");
        FOToPDFRoleMap.addStructureType("Lbl");
        FOToPDFRoleMap.addStructureType("LBody");
        FOToPDFRoleMap.addStructureType("Table");
        FOToPDFRoleMap.addStructureType("TR");
        FOToPDFRoleMap.addStructureType("TH");
        FOToPDFRoleMap.addStructureType("TD");
        FOToPDFRoleMap.addStructureType("THead");
        FOToPDFRoleMap.addStructureType("TBody");
        FOToPDFRoleMap.addStructureType("TFoot");
        FOToPDFRoleMap.addStructureType("Span");
        FOToPDFRoleMap.addStructureType("Quote");
        FOToPDFRoleMap.addStructureType("Note");
        FOToPDFRoleMap.addStructureType("Reference");
        FOToPDFRoleMap.addStructureType("BibEntry");
        FOToPDFRoleMap.addStructureType("Code");
        FOToPDFRoleMap.addStructureType("Link");
        FOToPDFRoleMap.addStructureType("Annot");
        FOToPDFRoleMap.addStructureType("Ruby");
        FOToPDFRoleMap.addStructureType("RB");
        FOToPDFRoleMap.addStructureType("RT");
        FOToPDFRoleMap.addStructureType("RP");
        FOToPDFRoleMap.addStructureType("Warichu");
        FOToPDFRoleMap.addStructureType("WT");
        FOToPDFRoleMap.addStructureType("WP");
        FOToPDFRoleMap.addStructureType("Figure");
        FOToPDFRoleMap.addStructureType("Formula");
        FOToPDFRoleMap.addStructureType("Form");
        NON_STRUCT = STANDARD_STRUCTURE_TYPES.get("NonStruct");
        assert (NON_STRUCT != null);
        THEAD = STANDARD_STRUCTURE_TYPES.get("THead");
        assert (THEAD != null);
        FOToPDFRoleMap.addMapping("root", "Document");
        FOToPDFRoleMap.addMapping("page-sequence", "Part");
        FOToPDFRoleMap.addMapping("flow", "Sect");
        FOToPDFRoleMap.addMapping("static-content", "Sect");
        FOToPDFRoleMap.addMapping("block", "P");
        FOToPDFRoleMap.addMapping("block-container", "Div");
        FOToPDFRoleMap.addMapping("character", "Span");
        FOToPDFRoleMap.addMapping("external-graphic", "Figure");
        FOToPDFRoleMap.addMapping("instream-foreign-object", "Figure");
        FOToPDFRoleMap.addMapping("inline", "Span");
        FOToPDFRoleMap.addMapping("inline-container", "Div");
        FOToPDFRoleMap.addMapping("page-number", "Quote");
        FOToPDFRoleMap.addMapping("page-number-citation", "Quote");
        FOToPDFRoleMap.addMapping("page-number-citation-last", "Quote");
        FOToPDFRoleMap.addMapping("table-and-caption", "Div");
        FOToPDFRoleMap.addMapping("table", "Table");
        FOToPDFRoleMap.addMapping("table-caption", "Caption");
        FOToPDFRoleMap.addMapping("table-header", "THead");
        FOToPDFRoleMap.addMapping("table-footer", "TFoot");
        FOToPDFRoleMap.addMapping("table-body", "TBody");
        FOToPDFRoleMap.addMapping("table-row", "TR");
        FOToPDFRoleMap.addMapping("table-cell", new TableCellMapper());
        FOToPDFRoleMap.addMapping("list-block", "L");
        FOToPDFRoleMap.addMapping("list-item", "LI");
        FOToPDFRoleMap.addMapping("list-item-body", "LBody");
        FOToPDFRoleMap.addMapping("list-item-label", "Lbl");
        FOToPDFRoleMap.addMapping("basic-link", "Link");
        FOToPDFRoleMap.addMapping("float", "Div");
        FOToPDFRoleMap.addMapping("footnote", "Note");
        FOToPDFRoleMap.addMapping("footnote-body", "Sect");
        FOToPDFRoleMap.addMapping("wrapper", "Span");
        FOToPDFRoleMap.addMapping("marker", "Private");
    }

    private static class TableCellMapper
    implements Mapper {
        private TableCellMapper() {
        }

        public PDFName getStructureType(PDFObject pDFObject) {
            PDFStructElem pDFStructElem = ((PDFStructElem)pDFObject).getParentStructElem();
            PDFName pDFName = THEAD.equals(pDFStructElem.getStructureType()) ? (PDFName)STANDARD_STRUCTURE_TYPES.get("TH") : (PDFName)STANDARD_STRUCTURE_TYPES.get("TD");
            assert (pDFName != null);
            return pDFName;
        }
    }

    private static class SimpleMapper
    implements Mapper {
        private PDFName structureType;

        public SimpleMapper(PDFName pDFName) {
            this.structureType = pDFName;
        }

        public PDFName getStructureType(PDFObject pDFObject) {
            return this.structureType;
        }
    }

    private static interface Mapper {
        public PDFName getStructureType(PDFObject var1);
    }
}

