/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.pdf.DCTFilter;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.render.pdf.AbstractImageAdapter;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.JPEGFile;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class ImageRawJPEGAdapter
extends AbstractImageAdapter {
    private PDFFilter pdfFilter = null;

    public ImageRawJPEGAdapter(ImageRawJPEG imageRawJPEG, String string) {
        super((Image)imageRawJPEG, string);
    }

    public ImageRawJPEG getImage() {
        return (ImageRawJPEG)this.image;
    }

    public void setup(PDFDocument pDFDocument) {
        this.pdfFilter = new DCTFilter();
        this.pdfFilter.setApplied(true);
        super.setup(pDFDocument);
    }

    public PDFDeviceColorSpace getColorSpace() {
        return ImageRawJPEGAdapter.toPDFColorSpace(this.getImageColorSpace());
    }

    public int getBitsPerComponent() {
        return 8;
    }

    public boolean isInverted() {
        return this.getImage().isInverted();
    }

    public PDFFilter getPDFFilter() {
        return this.pdfFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void outputContents(OutputStream var1_1) throws IOException {
        var2_2 = this.getImage().createInputStream();
        var2_2 = ImageUtil.decorateMarkSupported((InputStream)var2_2);
        try {
            var3_3 = new JPEGFile(var2_2);
            var4_4 = var3_3.getDataInput();
            block12: while (true) {
                var6_6 = var3_3.readMarkerSegment();
                switch (var6_6) {
                    case 216: {
                        var1_1.write(255);
                        var1_1.write(var6_6);
                        continue block12;
                    }
                    case 217: 
                    case 218: {
                        var1_1.write(255);
                        var1_1.write(var6_6);
                        IOUtils.copy((InputStream)var2_2, (OutputStream)var1_1);
                        return;
                    }
                    case 226: {
                        var7_7 = false;
                        var2_2.mark(16);
                        try {
                            var5_5 = var3_3.readSegmentLength();
                            var8_8 = new byte[11];
                            var4_4.readFully(var8_8);
                            var4_4.skipBytes(1);
                            if ("ICC_PROFILE".equals(new String(var8_8, "US-ASCII"))) {
                                var7_7 = this.image.getICCProfile() != null;
                            }
                        }
                        finally {
                            var2_2.reset();
                        }
                        if (!var7_7) break;
                        var3_3.skipCurrentMarkerSegment();
                        continue block12;
                    }
                }
                var1_1.write(255);
                var1_1.write(var6_6);
                var5_5 = var3_3.readSegmentLength();
                var1_1.write(var5_5 >>> 8 & 255);
                var1_1.write(var5_5 >>> 0 & 255);
                var8_9 = var5_5 - 2;
                var9_10 = new byte[2048];
                while (true) {
                    if (var8_9 > 0) ** break;
                    continue block12;
                    var10_12 = Math.min(var9_10.length, var8_9);
                    var4_4.readFully(var9_10, 0, var10_12);
                    var1_1.write(var9_10, 0, var10_12);
                    var8_9 -= var10_12;
                }
                break;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)var2_2);
        }
    }

    public String getFilterHint() {
        return "jpeg";
    }
}

