/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.fo.extensions.xmp.XMPMetadata;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.render.extensions.prepress.PageBoundaries;
import org.apache.fop.render.extensions.prepress.PageScale;
import org.apache.fop.render.intermediate.AbstractBinaryWritingIFDocumentHandler;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFDocumentNavigationHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.render.pdf.PDFDocumentNavigationHandler;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.apache.fop.render.pdf.PDFPainter;
import org.apache.fop.render.pdf.PDFRendererConfigurator;
import org.apache.fop.render.pdf.PDFRenderingUtil;
import org.apache.fop.render.pdf.PDFStructureTreeBuilder;
import org.apache.fop.render.pdf.extensions.PDFEmbeddedFileExtensionAttachment;
import org.apache.xmlgraphics.xmp.Metadata;

public class PDFDocumentHandler
extends AbstractBinaryWritingIFDocumentHandler {
    private static Log log = LogFactory.getLog(PDFDocumentHandler.class);
    private boolean accessEnabled;
    private PDFLogicalStructureHandler logicalStructureHandler;
    private PDFStructureTreeBuilder structureTreeBuilder;
    protected PDFDocument pdfDoc;
    protected PDFRenderingUtil pdfUtil;
    protected PDFResources pdfResources;
    protected PDFContentGenerator generator;
    protected PDFResourceContext currentContext;
    protected PDFPage currentPage;
    protected PageReference currentPageRef;
    protected Map<Integer, PageReference> pageReferences = new HashMap<Integer, PageReference>();
    private final PDFDocumentNavigationHandler documentNavigationHandler = new PDFDocumentNavigationHandler(this);

    public boolean supportsPagesOutOfOrder() {
        return !this.accessEnabled;
    }

    public String getMimeType() {
        return "application/pdf";
    }

    public void setContext(IFContext iFContext) {
        super.setContext(iFContext);
        this.pdfUtil = new PDFRenderingUtil(iFContext.getUserAgent());
    }

    public IFDocumentHandlerConfigurator getConfigurator() {
        return new PDFRendererConfigurator(this.getUserAgent());
    }

    public IFDocumentNavigationHandler getDocumentNavigationHandler() {
        return this.documentNavigationHandler;
    }

    PDFRenderingUtil getPDFUtil() {
        return this.pdfUtil;
    }

    PDFLogicalStructureHandler getLogicalStructureHandler() {
        return this.logicalStructureHandler;
    }

    public void startDocument() throws IFException {
        super.startDocument();
        try {
            this.pdfDoc = this.pdfUtil.setupPDFDocument(this.outputStream);
            this.accessEnabled = this.getUserAgent().isAccessibilityEnabled();
            if (this.accessEnabled) {
                this.setupAccessibility();
            }
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startDocument()", iOException);
        }
    }

    private void setupAccessibility() {
        this.pdfDoc.getRoot().makeTagged();
        this.logicalStructureHandler = new PDFLogicalStructureHandler(this.pdfDoc);
        this.structureTreeBuilder.setPdfFactory(this.pdfDoc.getFactory());
        this.structureTreeBuilder.setLogicalStructureHandler(this.logicalStructureHandler);
        this.structureTreeBuilder.setEventBroadcaster(this.getUserAgent().getEventBroadcaster());
    }

    public void endDocumentHeader() throws IFException {
        this.pdfUtil.generateDefaultXMPMetadata();
    }

    public void endDocument() throws IFException {
        try {
            this.pdfDoc.getResources().addFonts(this.pdfDoc, this.fontInfo);
            this.pdfDoc.outputTrailer(this.outputStream);
            this.pdfDoc = null;
            this.pdfResources = null;
            this.generator = null;
            this.currentContext = null;
            this.currentPage = null;
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endDocument()", iOException);
        }
        super.endDocument();
    }

    public void startPageSequence(String string) throws IFException {
    }

    public void endPageSequence() throws IFException {
    }

    public void startPage(int n, String string, String string2, Dimension dimension) throws IFException {
        this.pdfResources = this.pdfDoc.getResources();
        PageBoundaries pageBoundaries = new PageBoundaries(dimension, this.getContext().getForeignAttributes());
        Rectangle rectangle = pageBoundaries.getTrimBox();
        Rectangle rectangle2 = pageBoundaries.getBleedBox();
        Rectangle rectangle3 = pageBoundaries.getMediaBox();
        Rectangle rectangle4 = pageBoundaries.getCropBox();
        double d = 1.0;
        double d2 = 1.0;
        String string3 = (String)this.getContext().getForeignAttribute(PageScale.EXT_PAGE_SCALE);
        Point2D point2D = PageScale.getScale(string3);
        if (point2D != null) {
            d = point2D.getX();
            d2 = point2D.getY();
        }
        AffineTransform affineTransform = new AffineTransform(d / 1000.0, 0.0, 0.0, -d2 / 1000.0, 0.0, d2 * dimension.getHeight() / 1000.0);
        this.currentPage = this.pdfDoc.getFactory().makePage(this.pdfResources, n, this.toPDFCoordSystem(rectangle3, affineTransform), this.toPDFCoordSystem(rectangle4, affineTransform), this.toPDFCoordSystem(rectangle2, affineTransform), this.toPDFCoordSystem(rectangle, affineTransform));
        if (this.accessEnabled) {
            this.logicalStructureHandler.startPage(this.currentPage);
        }
        this.pdfUtil.generatePageLabel(n, string);
        this.currentPageRef = new PageReference(this.currentPage, dimension);
        this.pageReferences.put(n, this.currentPageRef);
        this.generator = new PDFContentGenerator(this.pdfDoc, this.outputStream, this.currentPage);
        AffineTransform affineTransform2 = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, d2 * (double)dimension.height / 1000.0);
        affineTransform2.scale(d, d2);
        this.generator.saveGraphicsState();
        this.generator.concatenate(affineTransform2);
    }

    private Rectangle2D toPDFCoordSystem(Rectangle rectangle, AffineTransform affineTransform) {
        return affineTransform.createTransformedShape(rectangle).getBounds2D();
    }

    public IFPainter startPageContent() throws IFException {
        return new PDFPainter(this, this.logicalStructureHandler);
    }

    public void endPageContent() throws IFException {
        this.generator.restoreGraphicsState();
    }

    public void endPage() throws IFException {
        if (this.accessEnabled) {
            this.logicalStructureHandler.endPage();
        }
        try {
            this.documentNavigationHandler.commit();
            this.pdfDoc.registerObject(this.generator.getStream());
            this.currentPage.setContents(this.generator.getStream());
            PDFAnnotList pDFAnnotList = this.currentPage.getAnnotations();
            if (pDFAnnotList != null) {
                this.pdfDoc.addObject(pDFAnnotList);
            }
            this.pdfDoc.addObject(this.currentPage);
            this.generator.flushPDFDoc();
            this.generator = null;
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endPage()", iOException);
        }
    }

    public void handleExtensionObject(Object object) throws IFException {
        if (object instanceof XMPMetadata) {
            this.pdfUtil.renderXMPMetadata((XMPMetadata)object);
        } else if (object instanceof Metadata) {
            XMPMetadata xMPMetadata = new XMPMetadata((Metadata)object);
            this.pdfUtil.renderXMPMetadata(xMPMetadata);
        } else if (object instanceof PDFEmbeddedFileExtensionAttachment) {
            PDFEmbeddedFileExtensionAttachment pDFEmbeddedFileExtensionAttachment = (PDFEmbeddedFileExtensionAttachment)object;
            try {
                this.pdfUtil.addEmbeddedFile(pDFEmbeddedFileExtensionAttachment);
            }
            catch (IOException iOException) {
                throw new IFException("Error adding embedded file: " + pDFEmbeddedFileExtensionAttachment.getSrc(), iOException);
            }
        } else {
            log.debug((Object)("Don't know how to handle extension object. Ignoring: " + object + " (" + object.getClass().getName() + ")"));
        }
    }

    public void setDocumentLocale(Locale locale) {
        this.pdfDoc.getRoot().setLanguage(locale);
    }

    PageReference getPageReference(int n) {
        return this.pageReferences.get(n);
    }

    public StructureTreeEventHandler getStructureTreeEventHandler() {
        if (this.structureTreeBuilder == null) {
            this.structureTreeBuilder = new PDFStructureTreeBuilder();
        }
        return this.structureTreeBuilder;
    }

    static final class PageReference {
        private final String pageRef;
        private final Dimension pageDimension;

        private PageReference(PDFPage pDFPage, Dimension dimension) {
            this.pageRef = pDFPage.makeReference().toString();
            this.pageDimension = new Dimension(dimension);
        }

        public String getPageRef() {
            return this.pageRef;
        }

        public Dimension getPageDimension() {
            return this.pageDimension;
        }
    }
}

