/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.extensions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.pdf.extensions.PDFEmbeddedFileExtensionAttachment;
import org.apache.fop.render.pdf.extensions.PDFExtensionAttachment;
import org.apache.fop.util.ContentHandlerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class PDFExtensionHandler
extends DefaultHandler
implements ContentHandlerFactory.ObjectSource {
    protected static final Log log = LogFactory.getLog(PDFExtensionHandler.class);
    private Attributes lastAttributes;
    private PDFExtensionAttachment returnedObject;
    private ContentHandlerFactory.ObjectBuiltListener listener;

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = false;
        if ("apache:fop:extensions:pdf".equals(string)) {
            this.lastAttributes = new AttributesImpl(attributes);
            bl = false;
            if (string2.equals("embedded-file")) {
                bl = true;
            }
        }
        if (!bl) {
            if ("apache:fop:extensions:pdf".equals(string)) {
                throw new SAXException("Unhandled element " + string2 + " in namespace: " + string);
            }
            log.warn((Object)("Unhandled element " + string2 + " in namespace: " + string));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("apache:fop:extensions:pdf".equals(string) && "embedded-file".equals(string2)) {
            String string4 = this.lastAttributes.getValue("name");
            String string5 = this.lastAttributes.getValue("src");
            String string6 = this.lastAttributes.getValue("description");
            this.returnedObject = new PDFEmbeddedFileExtensionAttachment(string4, string5, string6);
        }
    }

    public void endDocument() throws SAXException {
        if (this.listener != null) {
            this.listener.notifyObjectBuilt(this.getObject());
        }
    }

    public Object getObject() {
        return this.returnedObject;
    }

    public void setObjectBuiltListener(ContentHandlerFactory.ObjectBuiltListener objectBuiltListener) {
        this.listener = objectBuiltListener;
    }
}

