/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSImageHandler;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.ps.ImageEncoder;
import org.apache.xmlgraphics.ps.ImageEncodingHelper;
import org.apache.xmlgraphics.ps.ImageFormGenerator;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

public class PSImageHandlerRenderedImage
implements PSImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.BUFFERED_IMAGE, ImageFlavor.RENDERED_IMAGE};

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
        PSGenerator pSGenerator = pSRenderingContext.getGenerator();
        ImageRendered imageRendered = (ImageRendered)image;
        float f = (float)rectangle.getX() / 1000.0f;
        float f2 = (float)rectangle.getY() / 1000.0f;
        float f3 = (float)rectangle.getWidth() / 1000.0f;
        float f4 = (float)rectangle.getHeight() / 1000.0f;
        Rectangle2D.Double double_ = new Rectangle2D.Double(f, f2, f3, f4);
        RenderedImage renderedImage = imageRendered.getRenderedImage();
        ImageEncoder imageEncoder = ImageEncodingHelper.createRenderedImageEncoder((RenderedImage)renderedImage);
        Dimension dimension = new Dimension(renderedImage.getWidth(), renderedImage.getHeight());
        String string = renderedImage.getClass().getName();
        ImageEncodingHelper imageEncodingHelper = new ImageEncodingHelper(renderedImage);
        ColorModel colorModel = imageEncodingHelper.getEncodedColorModel();
        PSImageUtils.writeImage((ImageEncoder)imageEncoder, (Dimension)dimension, (String)string, (Rectangle2D)double_, (ColorModel)colorModel, (PSGenerator)pSGenerator);
    }

    public void generateForm(RenderingContext renderingContext, Image image, PSImageFormResource pSImageFormResource) throws IOException {
        PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
        PSGenerator pSGenerator = pSRenderingContext.getGenerator();
        ImageRendered imageRendered = (ImageRendered)image;
        ImageInfo imageInfo = image.getInfo();
        String string = imageInfo.getMimeType() + " " + imageInfo.getOriginalURI();
        RenderedImage renderedImage = imageRendered.getRenderedImage();
        ImageFormGenerator imageFormGenerator = new ImageFormGenerator(pSImageFormResource.getName(), string, imageInfo.getSize().getDimensionPt(), renderedImage, false);
        imageFormGenerator.generate(pSGenerator);
    }

    public int getPriority() {
        return 300;
    }

    public Class getSupportedImageClass() {
        return ImageRendered.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        return (image == null || image instanceof ImageRendered) && renderingContext instanceof PSRenderingContext;
    }
}

