/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfExternalGraphicContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfParagraphContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTableContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableColumnsInfo;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfExternalGraphic;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfParagraph;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfSection;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTextrun;

abstract class RtfAfterBeforeBase
extends RtfContainer
implements IRtfParagraphContainer,
IRtfExternalGraphicContainer,
IRtfTableContainer,
IRtfTextrunContainer {
    protected RtfAttributes attrib;
    private RtfParagraph para;
    private RtfExternalGraphic externalGraphic;
    private RtfTable table;

    RtfAfterBeforeBase(RtfSection rtfSection, Writer writer, RtfAttributes rtfAttributes) throws IOException {
        super(rtfSection, writer, rtfAttributes);
        this.attrib = rtfAttributes;
    }

    public RtfParagraph newParagraph() throws IOException {
        this.closeAll();
        this.para = new RtfParagraph(this, this.writer);
        return this.para;
    }

    public RtfParagraph newParagraph(RtfAttributes rtfAttributes) throws IOException {
        this.closeAll();
        this.para = new RtfParagraph(this, this.writer, rtfAttributes);
        return this.para;
    }

    public RtfExternalGraphic newImage() throws IOException {
        this.closeAll();
        this.externalGraphic = new RtfExternalGraphic(this, this.writer);
        return this.externalGraphic;
    }

    private void closeCurrentParagraph() throws IOException {
        if (this.para != null) {
            this.para.close();
        }
    }

    private void closeCurrentExternalGraphic() throws IOException {
        if (this.externalGraphic != null) {
            this.externalGraphic.close();
        }
    }

    private void closeCurrentTable() throws IOException {
        if (this.table != null) {
            this.table.close();
        }
    }

    protected void writeRtfPrefix() throws IOException {
        this.writeGroupMark(true);
        this.writeMyAttributes();
    }

    protected abstract void writeMyAttributes() throws IOException;

    protected void writeRtfSuffix() throws IOException {
        this.writeGroupMark(false);
    }

    public RtfAttributes getAttributes() {
        return this.attrib;
    }

    public void closeAll() throws IOException {
        this.closeCurrentParagraph();
        this.closeCurrentExternalGraphic();
        this.closeCurrentTable();
    }

    public RtfTable newTable(RtfAttributes rtfAttributes, ITableColumnsInfo iTableColumnsInfo) throws IOException {
        this.closeAll();
        this.table = new RtfTable(this, this.writer, rtfAttributes, iTableColumnsInfo);
        return this.table;
    }

    public RtfTable newTable(ITableColumnsInfo iTableColumnsInfo) throws IOException {
        this.closeAll();
        this.table = new RtfTable(this, this.writer, iTableColumnsInfo);
        return this.table;
    }

    public RtfTextrun getTextrun() throws IOException {
        return RtfTextrun.getTextrun(this, this.writer, null);
    }
}

