/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IBorderAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfExternalGraphicContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfListContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfParagraphContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTableContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableColumnsInfo;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfExternalGraphic;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfList;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfParagraph;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfParagraphBreak;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTextrun;

public class RtfTableCell
extends RtfContainer
implements IRtfParagraphContainer,
IRtfListContainer,
IRtfTableContainer,
IRtfExternalGraphicContainer,
IRtfTextrunContainer {
    private RtfParagraph paragraph;
    private RtfList list;
    private RtfTable table;
    private RtfExternalGraphic externalGraphic;
    private final RtfTableRow parentRow;
    private boolean setCenter;
    private boolean setRight;
    private int id;
    private RtfParagraphBreak lastBreak = null;
    private int lastBreakDepth = Integer.MIN_VALUE;
    private static final String TABLE_CELL_PARAGRAPH = "cell";
    private static final String TABLE_CELL_NESTED_PARAGRAPH = "nestcell";
    public static final int DEFAULT_CELL_WIDTH = 2000;
    private int cellWidth;
    private int widthOffset;
    private int vMerge = 0;
    private int hMerge = 0;
    public static final int NO_MERGE = 0;
    public static final int MERGE_START = 1;
    public static final int MERGE_WITH_PREVIOUS = 2;

    RtfTableCell(RtfTableRow rtfTableRow, Writer writer, int n, int n2) throws IOException {
        super(rtfTableRow, writer);
        this.id = n2;
        this.parentRow = rtfTableRow;
        this.cellWidth = n;
        this.setCenter = false;
        this.setRight = false;
    }

    RtfTableCell(RtfTableRow rtfTableRow, Writer writer, int n, RtfAttributes rtfAttributes, int n2) throws IOException {
        super(rtfTableRow, writer, rtfAttributes);
        this.id = n2;
        this.parentRow = rtfTableRow;
        this.cellWidth = n;
    }

    public RtfParagraph newParagraph(RtfAttributes rtfAttributes) throws IOException {
        this.closeAll();
        if (rtfAttributes == null) {
            rtfAttributes = new RtfAttributes();
        }
        rtfAttributes.set("intbl");
        this.paragraph = new RtfParagraph(this, this.writer, rtfAttributes);
        if (this.paragraph.attrib.isSet("qc")) {
            this.setCenter = true;
            rtfAttributes.set("qc");
        } else if (this.paragraph.attrib.isSet("qr")) {
            this.setRight = true;
            rtfAttributes.set("qr");
        } else {
            rtfAttributes.set("ql");
        }
        rtfAttributes.set("intbl");
        return this.paragraph;
    }

    public RtfExternalGraphic newImage() throws IOException {
        this.closeAll();
        this.externalGraphic = new RtfExternalGraphic(this, this.writer);
        return this.externalGraphic;
    }

    public RtfParagraph newParagraph() throws IOException {
        return this.newParagraph(null);
    }

    public RtfList newList(RtfAttributes rtfAttributes) throws IOException {
        this.closeAll();
        this.list = new RtfList(this, this.writer, rtfAttributes);
        return this.list;
    }

    public RtfTable newTable(ITableColumnsInfo iTableColumnsInfo) throws IOException {
        this.closeAll();
        this.table = new RtfTable(this, this.writer, iTableColumnsInfo);
        return this.table;
    }

    public RtfTable newTable(RtfAttributes rtfAttributes, ITableColumnsInfo iTableColumnsInfo) throws IOException {
        this.closeAll();
        this.table = new RtfTable(this, this.writer, rtfAttributes, iTableColumnsInfo);
        return this.table;
    }

    int writeCellDef(int n) throws IOException {
        int n2;
        if (this.hMerge == 2) {
            return n;
        }
        this.newLine();
        this.widthOffset = n;
        if (this.vMerge == 1) {
            this.writeControlWord("clvmgf");
        } else if (this.vMerge == 2) {
            this.writeControlWord("clvmrg");
        }
        this.writeAttributes(this.attrib, ITableAttributes.CELL_COLOR);
        this.writeAttributes(this.attrib, ITableAttributes.ATTRIB_CELL_PADDING);
        this.writeAttributes(this.attrib, ITableAttributes.CELL_BORDER);
        this.writeAttributes(this.attrib, IBorderAttributes.BORDERS);
        int n3 = this.cellWidth;
        if (this.attrib.getValue("number-columns-spanned") != null) {
            n2 = (Integer)this.attrib.getValue("number-columns-spanned");
            RtfTable rtfTable = this.getRow().getTable();
            ITableColumnsInfo iTableColumnsInfo = rtfTable.getITableColumnsInfo();
            iTableColumnsInfo.selectFirstColumn();
            while (this.id - 1 != iTableColumnsInfo.getColumnIndex()) {
                iTableColumnsInfo.selectNextColumn();
            }
            for (int i = n2 - 1; i > 0; --i) {
                iTableColumnsInfo.selectNextColumn();
                n3 += (int)iTableColumnsInfo.getColumnWidth();
            }
        }
        n2 = n + n3;
        if (this.setCenter) {
            this.writeControlWord("trqc");
        } else if (this.setRight) {
            this.writeControlWord("trqr");
        } else {
            this.writeControlWord("trql");
        }
        this.writeAttributes(this.attrib, ITableAttributes.CELL_VERT_ALIGN);
        this.writeControlWord("cellx" + n2);
        return n2;
    }

    protected void writeRtfContent() throws IOException {
        if (this.hMerge == 2) {
            return;
        }
        super.writeRtfContent();
    }

    protected void writeRtfPrefix() throws IOException {
        if (this.hMerge == 2) {
            return;
        }
        super.writeRtfPrefix();
    }

    protected void writeRtfSuffix() throws IOException {
        if (this.hMerge == 2) {
            return;
        }
        if (this.getRow().getTable().isNestedTable()) {
            if (this.lastBreak == null) {
                this.writeControlWordNS(TABLE_CELL_NESTED_PARAGRAPH);
            }
            this.writeGroupMark(true);
            this.writeControlWord("nonesttables");
            this.writeControlWord("par");
            this.writeGroupMark(false);
        } else {
            if (this.setCenter) {
                this.writeControlWord("qc");
            } else if (this.setRight) {
                this.writeControlWord("qr");
            } else {
                RtfElement rtfElement = null;
                if (this.getChildren().size() > 0) {
                    rtfElement = (RtfElement)this.getChildren().get(this.getChildren().size() - 1);
                }
                if (rtfElement == null || !(rtfElement instanceof RtfTextrun)) {
                    this.writeControlWord("ql");
                }
            }
            if (!this.containsText()) {
                this.writeControlWord("intbl");
            }
            if (this.lastBreak == null) {
                this.writeControlWord(TABLE_CELL_PARAGRAPH);
            }
        }
    }

    private void closeCurrentParagraph() throws IOException {
        if (this.paragraph != null) {
            this.paragraph.close();
        }
    }

    private void closeCurrentList() throws IOException {
        if (this.list != null) {
            this.list.close();
        }
    }

    private void closeCurrentTable() throws IOException {
        if (this.table != null) {
            this.table.close();
        }
    }

    private void closeCurrentExternalGraphic() throws IOException {
        if (this.externalGraphic != null) {
            this.externalGraphic.close();
        }
    }

    private void closeAll() throws IOException {
        this.closeCurrentTable();
        this.closeCurrentParagraph();
        this.closeCurrentList();
        this.closeCurrentExternalGraphic();
    }

    public void setVMerge(int n) {
        this.vMerge = n;
    }

    public int getVMerge() {
        return this.vMerge;
    }

    public void setHMerge(int n) {
        this.hMerge = n;
    }

    public int getHMerge() {
        return this.hMerge;
    }

    int getCellWidth() {
        return this.cellWidth;
    }

    public boolean isEmpty() {
        return false;
    }

    boolean paragraphNeedsPar(RtfParagraph rtfParagraph) {
        boolean bl = false;
        boolean bl2 = false;
        for (Object e : this.getChildren()) {
            if (!bl) {
                bl = e == rtfParagraph;
                continue;
            }
            if (e instanceof RtfParagraph) {
                RtfParagraph rtfParagraph2 = (RtfParagraph)e;
                if (rtfParagraph2.isEmpty()) continue;
                bl2 = true;
                break;
            }
            if (!(e instanceof RtfTable)) continue;
            break;
        }
        return bl2;
    }

    public RtfTextrun getTextrun() throws IOException {
        RtfAttributes rtfAttributes = new RtfAttributes();
        if (!this.getRow().getTable().isNestedTable()) {
            rtfAttributes.set("intbl");
        }
        RtfTextrun rtfTextrun = RtfTextrun.getTextrun(this, this.writer, rtfAttributes);
        rtfTextrun.setSuppressLastPar(true);
        return rtfTextrun;
    }

    public RtfTableRow getRow() {
        RtfContainer rtfContainer = this;
        while (rtfContainer.parent != null) {
            if (rtfContainer.parent instanceof RtfTableRow) {
                return (RtfTableRow)rtfContainer.parent;
            }
            rtfContainer = rtfContainer.parent;
        }
        return null;
    }

    public void setLastParagraph(RtfParagraphBreak rtfParagraphBreak, int n) {
        if (rtfParagraphBreak != null && n >= this.lastBreakDepth) {
            this.lastBreak = rtfParagraphBreak;
            this.lastBreakDepth = n;
        }
    }

    public void finish() {
        if (this.getRow().getTable().isNestedTable() && this.table != null) {
            this.lastBreak = null;
        } else if (this.lastBreak != null) {
            this.lastBreak.switchControlWord(this.getRow().getTable().isNestedTable() ? TABLE_CELL_NESTED_PARAGRAPH : TABLE_CELL_PARAGRAPH);
        }
    }
}

