/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.cli.InputHandler;
import org.apache.fop.tools.anttasks.Fop;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.xml.sax.SAXException;

class FOPTaskStarter {
    private FopFactory fopFactory = FopFactory.newInstance();
    private Fop task;
    private String baseURL = null;
    protected Log logger = null;
    private static final String[][] SHORT_NAMES = new String[][]{{"pdf", "application/pdf"}, {"ps", "application/postscript"}, {"mif", "application/mif"}, {"rtf", "application/rtf"}, {"pcl", "application/x-pcl"}, {"txt", "text/plain"}, {"at", "application/X-fop-areatree"}, {"xml", "application/X-fop-areatree"}, {"tiff", "image/tiff"}, {"tif", "image/tiff"}, {"png", "image/png"}, {"afp", "application/x-afp"}};
    private static final String[][] EXTENSIONS = new String[][]{{"application/X-fop-areatree", ".at.xml"}, {"application/X-fop-awt-preview", null}, {"application/X-fop-print", null}, {"application/pdf", ".pdf"}, {"application/postscript", ".ps"}, {"application/x-pcl", ".pcl"}, {"application/vnd.hp-PCL", ".pcl"}, {"text/plain", ".txt"}, {"application/rtf", ".rtf"}, {"text/richtext", ".rtf"}, {"text/rtf", ".rtf"}, {"application/mif", ".mif"}, {"image/svg+xml", ".svg"}, {"image/png", ".png"}, {"image/jpeg", ".jpg"}, {"image/tiff", ".tif"}, {"application/x-afp", ".afp"}, {"application/vnd.ibm.modcap", ".afp"}, {"text/xsl", ".fo"}};

    public void setLogger(Log log) {
        this.logger = log;
    }

    protected Log getLogger() {
        return this.logger;
    }

    FOPTaskStarter(Fop fop) throws SAXException, IOException {
        this.task = fop;
        if (fop.getUserconfig() != null) {
            this.fopFactory.setUserConfig(fop.getUserconfig());
        }
    }

    private String normalizeOutputFormat(String string) {
        if (string == null) {
            return "application/pdf";
        }
        for (int i = 0; i < SHORT_NAMES.length; ++i) {
            if (!SHORT_NAMES[i][0].equals(string)) continue;
            return SHORT_NAMES[i][1];
        }
        return string;
    }

    private String determineExtension(String string) {
        for (int i = 0; i < EXTENSIONS.length; ++i) {
            if (!EXTENSIONS[i][0].equals(string)) continue;
            String string2 = EXTENSIONS[i][1];
            if (string2 == null) {
                throw new RuntimeException("Output format '" + string + "' does not produce a file.");
            }
            return string2;
        }
        return ".unk";
    }

    private File replaceExtension(File file, String string, String string2) {
        String string3 = file.getName();
        if (string3.toLowerCase().endsWith(string)) {
            string3 = string3.substring(0, string3.length() - string.length());
        }
        string3 = string3.concat(string2);
        return new File(file.getParentFile(), string3);
    }

    public void run() throws FOPException {
        Object object;
        if (this.task.getBasedir() != null) {
            try {
                this.baseURL = this.task.getBasedir().toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                this.logger.error((Object)"Error creating base URL from base directory", (Throwable)malformedURLException);
            }
        } else {
            try {
                if (this.task.getFofile() != null) {
                    this.baseURL = this.task.getFofile().getParentFile().toURI().toURL().toExternalForm();
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.logger.error((Object)"Error creating base URL from XSL-FO input file", (Throwable)malformedURLException);
            }
        }
        this.task.log("Using base URL: " + this.baseURL, 4);
        String string = this.normalizeOutputFormat(this.task.getFormat());
        String string2 = this.determineExtension(string);
        int n = 0;
        int n2 = 0;
        if (this.task.getFofile() != null) {
            if (this.task.getFofile().exists()) {
                object = this.task.getOutfile();
                if (object == null) {
                    throw new BuildException("outfile is required when fofile is used");
                }
                if (this.task.getOutdir() != null) {
                    object = new File(this.task.getOutdir(), ((File)object).getName());
                }
                if (this.task.getForce() || !((File)object).exists() || this.task.getFofile().lastModified() > ((File)object).lastModified()) {
                    this.render(this.task.getFofile(), (File)object, string);
                    ++n;
                } else if (((File)object).exists() && this.task.getFofile().lastModified() <= ((File)object).lastModified()) {
                    ++n2;
                }
            }
        } else if (this.task.getXmlFile() != null && this.task.getXsltFile() != null && this.task.getXmlFile().exists() && this.task.getXsltFile().exists()) {
            object = this.task.getOutfile();
            if (object == null) {
                throw new BuildException("outfile is required when fofile is used");
            }
            if (this.task.getOutdir() != null) {
                object = new File(this.task.getOutdir(), ((File)object).getName());
            }
            if (this.task.getForce() || !((File)object).exists() || this.task.getXmlFile().lastModified() > ((File)object).lastModified() || this.task.getXsltFile().lastModified() > ((File)object).lastModified()) {
                this.render(this.task.getXmlFile(), this.task.getXsltFile(), (File)object, string);
                ++n;
            } else if (((File)object).exists() && (this.task.getXmlFile().lastModified() <= ((File)object).lastModified() || this.task.getXsltFile().lastModified() <= ((File)object).lastModified())) {
                ++n2;
            }
        }
        object = new GlobPatternMapper();
        String string3 = ".fo";
        File file = this.task.getXsltFile();
        if (file != null) {
            string3 = ".xml";
        }
        object.setFrom("*" + string3);
        object.setTo("*" + string2);
        for (int i = 0; i < this.task.getFilesets().size(); ++i) {
            FileSet fileSet = (FileSet)this.task.getFilesets().get(i);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.task.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int j = 0; j < stringArray.length; ++j) {
                Object object2;
                File file2 = new File(fileSet.getDir(this.task.getProject()), stringArray[j]);
                File file3 = null;
                if (this.task.getOutdir() != null && stringArray[j].endsWith(string3)) {
                    object2 = object.mapFileName(stringArray[j]);
                    file3 = new File(this.task.getOutdir(), (String)object2[0]);
                } else {
                    file3 = this.replaceExtension(file2, string3, string2);
                    if (this.task.getOutdir() != null) {
                        file3 = new File(this.task.getOutdir(), file3.getName());
                    }
                }
                object2 = file3.getParentFile();
                if (!((File)object2).exists()) {
                    ((File)object2).mkdirs();
                }
                try {
                    if (this.task.getRelativebase()) {
                        this.baseURL = file2.getParentFile().toURI().toURL().toExternalForm();
                    }
                    if (this.baseURL == null) {
                        this.baseURL = fileSet.getDir(this.task.getProject()).toURI().toURL().toExternalForm();
                    }
                }
                catch (Exception exception) {
                    this.task.log("Error setting base URL", 4);
                }
                if (this.task.getForce() || !file3.exists() || file2.lastModified() > file3.lastModified()) {
                    if (file != null) {
                        this.render(file2, file, file3, string);
                    } else {
                        this.render(file2, file3, string);
                    }
                    ++n;
                    continue;
                }
                if (!file3.exists() || file2.lastModified() > file3.lastModified()) continue;
                ++n2;
            }
        }
        if (n + n2 == 0) {
            this.task.log("No files processed. No files were selected by the filesets and no fofile was set.", 1);
        } else if (n2 > 0) {
            this.task.log(n2 + " xslfo file(s) skipped (no change found" + " since last generation; set force=\"true\" to override).", 2);
        }
    }

    private void renderInputHandler(InputHandler inputHandler, File file, String string) throws Exception {
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            outputStream = new BufferedOutputStream(outputStream);
        }
        catch (Exception exception) {
            throw new BuildException("Failed to open " + file, (Throwable)exception);
        }
        boolean bl = false;
        try {
            FOUserAgent fOUserAgent = this.fopFactory.newFOUserAgent();
            fOUserAgent.setBaseURL(this.baseURL);
            inputHandler.renderTo(fOUserAgent, string, outputStream);
            bl = true;
        }
        catch (Exception exception) {
            if (this.task.getThrowexceptions()) {
                throw new BuildException((Throwable)exception);
            }
            throw exception;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                this.logger.error((Object)"Error closing output file", (Throwable)iOException);
            }
            if (!bl) {
                file.delete();
            }
        }
    }

    private void render(File file, File file2, String string) throws FOPException {
        InputHandler inputHandler = new InputHandler(file);
        try {
            this.renderInputHandler(inputHandler, file2, string);
        }
        catch (Exception exception) {
            this.logger.error((Object)("Error rendering fo file: " + file), (Throwable)exception);
        }
        if (this.task.getLogFiles()) {
            this.task.log(file + " -> " + file2, 2);
        }
    }

    private void render(File file, File file2, File file3, String string) {
        Vector vector = null;
        InputHandler inputHandler = new InputHandler(file, file2, vector);
        try {
            this.renderInputHandler(inputHandler, file3, string);
        }
        catch (Exception exception) {
            this.logger.error((Object)("Error rendering xml/xslt files: " + file + ", " + file2), (Throwable)exception);
        }
        if (this.task.getLogFiles()) {
            this.task.log("xml: " + file + ", xslt: " + file2 + " -> " + file3, 2);
        }
    }
}

