/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.fop.apps.FOPException;
import org.apache.fop.tools.anttasks.FOPTaskStarter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.SAXException;

public class Fop
extends Task {
    private File foFile;
    private File xmlFile;
    private File xsltFile;
    private String xsltParams;
    private List filesets = new ArrayList();
    private File outFile;
    private File outDir;
    private String format;
    private File baseDir;
    private File userConfig;
    private int messageType = 3;
    private boolean logFiles = true;
    private boolean force = false;
    private boolean relativebase = false;
    private boolean throwExceptions = true;

    public void setUserconfig(File file) {
        this.userConfig = file;
    }

    public File getUserconfig() {
        return this.userConfig;
    }

    public void setFofile(File file) {
        this.foFile = file;
    }

    public File getFofile() {
        return this.foFile;
    }

    public File getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(File file) {
        this.xmlFile = file;
    }

    public File getXsltFile() {
        return this.xsltFile;
    }

    public void setXsltFile(File file) {
        this.xsltFile = file;
    }

    public String getXsltParams() {
        return this.xsltParams;
    }

    public void setXsltParams(String string) {
        this.xsltParams = string;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public List getFilesets() {
        return this.filesets;
    }

    public void setRelativebase(boolean bl) {
        this.relativebase = bl;
    }

    public boolean getRelativebase() {
        return this.relativebase;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public boolean getForce() {
        return this.force;
    }

    public void setOutfile(File file) {
        this.outFile = file;
    }

    public File getOutfile() {
        return this.outFile;
    }

    public void setOutdir(File file) {
        this.outDir = file;
    }

    public File getOutdir() {
        return this.outDir;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setThrowexceptions(boolean bl) {
        this.throwExceptions = bl;
    }

    public boolean getThrowexceptions() {
        return this.throwExceptions;
    }

    public void setMessagelevel(String string) {
        if (string.equalsIgnoreCase("info")) {
            this.messageType = 2;
        } else if (string.equalsIgnoreCase("verbose")) {
            this.messageType = 3;
        } else if (string.equalsIgnoreCase("debug")) {
            this.messageType = 4;
        } else if (string.equalsIgnoreCase("err") || string.equalsIgnoreCase("error")) {
            this.messageType = 0;
        } else if (string.equalsIgnoreCase("warn")) {
            this.messageType = 1;
        } else {
            this.log("messagelevel set to unknown value \"" + string + "\"", 0);
            throw new BuildException("unknown messagelevel");
        }
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public File getBasedir() {
        return this.baseDir != null ? this.baseDir : this.getProject().resolveFile(".");
    }

    public void setLogFiles(boolean bl) {
        this.logFiles = bl;
    }

    public boolean getLogFiles() {
        return this.logFiles;
    }

    public void execute() throws BuildException {
        int n = 3;
        switch (this.getMessageType()) {
            case 4: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 0: {
                n = 5;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            default: {
                n = 3;
            }
        }
        SimpleLog simpleLog = new SimpleLog("FOP/Anttask");
        simpleLog.setLevel(n);
        try {
            FOPTaskStarter fOPTaskStarter = new FOPTaskStarter(this);
            fOPTaskStarter.setLogger((Log)simpleLog);
            fOPTaskStarter.run();
        }
        catch (FOPException fOPException) {
            throw new BuildException((Throwable)fOPException);
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        catch (SAXException sAXException) {
            throw new BuildException((Throwable)sAXException);
        }
    }
}

