/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class RunTest
extends Task {
    private String basedir;
    private String testsuite = "";
    private String referenceJar = "";
    private String refVersion = "";

    public void setTestSuite(String string) {
        this.testsuite = string;
    }

    public void setBasedir(String string) {
        this.basedir = string;
    }

    public void setReference(String string) {
        this.referenceJar = string;
    }

    public void setRefVersion(String string) {
        this.refVersion = string;
    }

    public void execute() throws BuildException {
        this.runReference();
        this.testNewBuild();
    }

    protected void testNewBuild() {
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(this.createUrls("build/fop.jar"));
            Map map = this.runConverter(uRLClassLoader, "areatree", "reference/output/");
            if (map != null && !map.isEmpty()) {
                System.out.println("====================================");
                System.out.println("The following files differ:");
                boolean bl = false;
                for (Object k : map.keySet()) {
                    Boolean bl2 = (Boolean)map.get(k);
                    System.out.println("file: " + k + " - reference success: " + bl2);
                    if (!bl2.booleanValue()) continue;
                    bl = true;
                }
                if (bl) {
                    throw new BuildException("Working tests have been changed.");
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    protected void runReference() throws BuildException {
        File file = new File(this.basedir + "/reference/output/");
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(this.createUrls(this.referenceJar));
            boolean bl = false;
            try {
                Class<?> clazz = Class.forName("org.apache.fop.apps.Fop", true, uRLClassLoader);
                Method method = clazz.getMethod("getVersion", new Class[0]);
                if (!method.invoke(null, new Object[0]).equals(this.refVersion)) {
                    throw new BuildException("Reference jar is not correct version it must be: " + this.refVersion);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = true;
            }
            catch (InvocationTargetException invocationTargetException) {
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                bl = true;
            }
            if (bl) {
                throw new BuildException("Reference jar could not be found in: " + this.basedir + "/reference/");
            }
            file.mkdirs();
            this.runConverter(uRLClassLoader, "reference/output/", null);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    protected Map runConverter(ClassLoader classLoader, String string, String string2) {
        String string3 = "org.apache.fop.tools.TestConverter";
        Map map = null;
        try {
            Class<?> clazz = Class.forName(string3, true, classLoader);
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("setBaseDir", String.class);
            method.invoke(obj, this.basedir);
            method = clazz.getMethod("runTests", String.class, String.class, String.class);
            map = (Map)method.invoke(obj, this.testsuite, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return map;
    }

    private URL[] createUrls(String string) throws MalformedURLException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.add(new File(string).toURI().toURL());
        File[] fileArray = new File("lib").listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getPath().endsWith(".jar")) continue;
            arrayList.add(fileArray[i].toURI().toURL());
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }
}

