/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import java.io.Serializable;

public final class MinOptMax
implements Serializable {
    private static final long serialVersionUID = -4791524475122206142L;
    public static final MinOptMax ZERO = MinOptMax.getInstance(0);
    private final int min;
    private final int opt;
    private final int max;

    public static MinOptMax getInstance(int n, int n2, int n3) throws IllegalArgumentException {
        if (n > n2) {
            throw new IllegalArgumentException("min (" + n + ") > opt (" + n2 + ")");
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("max (" + n3 + ") < opt (" + n2 + ")");
        }
        return new MinOptMax(n, n2, n3);
    }

    public static MinOptMax getInstance(int n) {
        return new MinOptMax(n, n, n);
    }

    private MinOptMax(int n, int n2, int n3) {
        assert (n <= n2 && n2 <= n3);
        this.min = n;
        this.opt = n2;
        this.max = n3;
    }

    public int getMin() {
        return this.min;
    }

    public int getOpt() {
        return this.opt;
    }

    public int getMax() {
        return this.max;
    }

    public int getShrink() {
        return this.opt - this.min;
    }

    public int getStretch() {
        return this.max - this.opt;
    }

    public MinOptMax plus(MinOptMax minOptMax) {
        return new MinOptMax(this.min + minOptMax.min, this.opt + minOptMax.opt, this.max + minOptMax.max);
    }

    public MinOptMax plus(int n) {
        return new MinOptMax(this.min + n, this.opt + n, this.max + n);
    }

    public MinOptMax minus(MinOptMax minOptMax) throws ArithmeticException {
        this.checkCompatibility(this.getShrink(), minOptMax.getShrink(), "shrink");
        this.checkCompatibility(this.getStretch(), minOptMax.getStretch(), "stretch");
        return new MinOptMax(this.min - minOptMax.min, this.opt - minOptMax.opt, this.max - minOptMax.max);
    }

    private void checkCompatibility(int n, int n2, String string) {
        if (n < n2) {
            throw new ArithmeticException("Cannot subtract a MinOptMax from another MinOptMax that has less " + string + " (" + n + " < " + n2 + ")");
        }
    }

    public MinOptMax minus(int n) {
        return new MinOptMax(this.min - n, this.opt - n, this.max - n);
    }

    public MinOptMax plusMin(int n) throws IllegalArgumentException {
        return MinOptMax.getInstance(this.min + n, this.opt, this.max);
    }

    public MinOptMax minusMin(int n) throws IllegalArgumentException {
        return MinOptMax.getInstance(this.min - n, this.opt, this.max);
    }

    public MinOptMax plusMax(int n) throws IllegalArgumentException {
        return MinOptMax.getInstance(this.min, this.opt, this.max + n);
    }

    public MinOptMax minusMax(int n) throws IllegalArgumentException {
        return MinOptMax.getInstance(this.min, this.opt, this.max - n);
    }

    public MinOptMax mult(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("factor < 0; was: " + n);
        }
        if (n == 1) {
            return this;
        }
        return MinOptMax.getInstance(this.min * n, this.opt * n, this.max * n);
    }

    public boolean isNonZero() {
        return this.min != 0 || this.max != 0;
    }

    public boolean isStiff() {
        return this.min == this.max;
    }

    public boolean isElastic() {
        return this.min != this.opt || this.opt != this.max;
    }

    public MinOptMax extendMinimum(int n) {
        if (this.min < n) {
            int n2 = Math.max(n, this.opt);
            int n3 = Math.max(n2, this.max);
            return MinOptMax.getInstance(n, n2, n3);
        }
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MinOptMax minOptMax = (MinOptMax)object;
        return this.opt == minOptMax.opt && this.max == minOptMax.max && this.min == minOptMax.min;
    }

    public int hashCode() {
        int n = this.min;
        n = 31 * n + this.opt;
        n = 31 * n + this.max;
        return n;
    }

    public String toString() {
        return "MinOptMax[min = " + this.min + ", opt = " + this.opt + ", max = " + this.max + "]";
    }
}

