/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.xmlgraphics.util.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedMessageFormat {
    static final Pattern COMMA_SEPARATOR_REGEX;
    private static final Map<String, PartFactory> PART_FACTORIES;
    private static final List<ObjectFormatter> OBJECT_FORMATTERS;
    private static final Map<Object, Function> FUNCTIONS;
    private CompositePart rootPart;

    public AdvancedMessageFormat(CharSequence charSequence) {
        this.parsePattern(charSequence);
    }

    private void parsePattern(CharSequence charSequence) {
        this.rootPart = new CompositePart(false);
        StringBuffer stringBuffer = new StringBuffer();
        this.parseInnerPattern(charSequence, this.rootPart, stringBuffer, 0);
    }

    private int parseInnerPattern(CharSequence charSequence, CompositePart compositePart, StringBuffer stringBuffer, int n) {
        assert (stringBuffer.length() == 0);
        int n2 = n;
        int n3 = charSequence.length();
        block7: while (n2 < n3) {
            char c = charSequence.charAt(n2);
            switch (c) {
                case '{': {
                    if (stringBuffer.length() > 0) {
                        compositePart.addChild(new TextPart(stringBuffer.toString()));
                        stringBuffer.setLength(0);
                    }
                    ++n2;
                    int n4 = 1;
                    while (n2 < n3) {
                        c = charSequence.charAt(n2);
                        if (c == '{') {
                            ++n4;
                        } else if (c == '}' && --n4 == 0) {
                            ++n2;
                            break;
                        }
                        stringBuffer.append(c);
                        ++n2;
                    }
                    compositePart.addChild(this.parseField(stringBuffer.toString()));
                    stringBuffer.setLength(0);
                    continue block7;
                }
                case ']': {
                    ++n2;
                    break block7;
                }
                case '[': {
                    if (stringBuffer.length() > 0) {
                        compositePart.addChild(new TextPart(stringBuffer.toString()));
                        stringBuffer.setLength(0);
                    }
                    ++n2;
                    CompositePart compositePart2 = new CompositePart(true);
                    compositePart.addChild(compositePart2);
                    n2 += this.parseInnerPattern(charSequence, compositePart2, stringBuffer, n2);
                    continue block7;
                }
                case '|': {
                    if (stringBuffer.length() > 0) {
                        compositePart.addChild(new TextPart(stringBuffer.toString()));
                        stringBuffer.setLength(0);
                    }
                    compositePart.newSection();
                    ++n2;
                    continue block7;
                }
                case '\\': {
                    if (n2 < n3 - 1) {
                        c = charSequence.charAt(++n2);
                    }
                }
                default: {
                    stringBuffer.append(c);
                    ++n2;
                    continue block7;
                }
            }
        }
        if (stringBuffer.length() > 0) {
            compositePart.addChild(new TextPart(stringBuffer.toString()));
            stringBuffer.setLength(0);
        }
        return n2 - n;
    }

    private Part parseField(String string) {
        String[] stringArray = COMMA_SEPARATOR_REGEX.split(string, 3);
        String string2 = stringArray[0];
        if (stringArray.length == 1) {
            if (string2.startsWith("#")) {
                return new FunctionPart(string2.substring(1));
            }
            return new SimpleFieldPart(string2);
        }
        String string3 = stringArray[1];
        PartFactory partFactory = PART_FACTORIES.get(string3);
        if (partFactory == null) {
            throw new IllegalArgumentException("No PartFactory available under the name: " + string3);
        }
        if (stringArray.length == 2) {
            return partFactory.newPart(string2, null);
        }
        return partFactory.newPart(string2, stringArray[2]);
    }

    private static Function getFunction(String string) {
        return FUNCTIONS.get(string);
    }

    public String format(Map<String, Object> map) {
        StringBuffer stringBuffer = new StringBuffer();
        this.format(map, stringBuffer);
        return stringBuffer.toString();
    }

    public void format(Map<String, Object> map, StringBuffer stringBuffer) {
        this.rootPart.write(stringBuffer, map);
    }

    public static void formatObject(Object object, StringBuffer stringBuffer) {
        if (object instanceof String) {
            stringBuffer.append(object);
        } else {
            boolean bl = false;
            for (ObjectFormatter objectFormatter : OBJECT_FORMATTERS) {
                if (!objectFormatter.supportsObject(object)) continue;
                objectFormatter.format(stringBuffer, object);
                bl = true;
                break;
            }
            if (!bl) {
                stringBuffer.append(String.valueOf(object));
            }
        }
    }

    static String unescapeComma(String string) {
        return string.replaceAll("\\\\,", ",");
    }

    static {
        Object object;
        COMMA_SEPARATOR_REGEX = Pattern.compile("(?<!\\\\),");
        PART_FACTORIES = new HashMap<String, PartFactory>();
        OBJECT_FORMATTERS = new ArrayList<ObjectFormatter>();
        FUNCTIONS = new HashMap<Object, Function>();
        Iterator iterator = Service.providers(PartFactory.class);
        while (iterator.hasNext()) {
            object = (PartFactory)iterator.next();
            PART_FACTORIES.put(object.getFormat(), (PartFactory)object);
        }
        iterator = Service.providers(ObjectFormatter.class);
        while (iterator.hasNext()) {
            OBJECT_FORMATTERS.add((ObjectFormatter)iterator.next());
        }
        iterator = Service.providers(Function.class);
        while (iterator.hasNext()) {
            object = (Function)iterator.next();
            FUNCTIONS.put(object.getName(), (Function)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositePart
    implements Part {
        protected List<Part> parts = new ArrayList<Part>();
        private boolean conditional;
        private boolean hasSections = false;

        public CompositePart(boolean bl) {
            this.conditional = bl;
        }

        private CompositePart(List<Part> list) {
            this.parts.addAll(list);
            this.conditional = true;
        }

        public void addChild(Part part) {
            if (part == null) {
                throw new NullPointerException("part must not be null");
            }
            if (this.hasSections) {
                CompositePart compositePart = (CompositePart)this.parts.get(this.parts.size() - 1);
                compositePart.addChild(part);
            } else {
                this.parts.add(part);
            }
        }

        public void newSection() {
            if (!this.hasSections) {
                List<Part> list = this.parts;
                this.parts = new ArrayList<Part>();
                this.parts.add(new CompositePart(list));
                this.hasSections = true;
            }
            this.parts.add(new CompositePart(true));
        }

        @Override
        public void write(StringBuffer stringBuffer, Map<String, Object> map) {
            block2: {
                block3: {
                    if (!this.hasSections) break block3;
                    for (Part part : this.parts) {
                        if (!part.isGenerated(map)) continue;
                        part.write(stringBuffer, map);
                        break block2;
                    }
                    break block2;
                }
                if (!this.isGenerated(map)) break block2;
                for (Part part : this.parts) {
                    part.write(stringBuffer, map);
                }
            }
        }

        @Override
        public boolean isGenerated(Map<String, Object> map) {
            if (this.hasSections) {
                for (Part part : this.parts) {
                    if (!part.isGenerated(map)) continue;
                    return true;
                }
                return false;
            }
            if (this.conditional) {
                for (Part part : this.parts) {
                    if (part.isGenerated(map)) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return this.parts.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionPart
    implements Part {
        private Function function;

        public FunctionPart(String string) {
            this.function = AdvancedMessageFormat.getFunction(string);
            if (this.function == null) {
                throw new IllegalArgumentException("Unknown function: " + string);
            }
        }

        @Override
        public void write(StringBuffer stringBuffer, Map<String, Object> map) {
            Object object = this.function.evaluate(map);
            AdvancedMessageFormat.formatObject(object, stringBuffer);
        }

        @Override
        public boolean isGenerated(Map<String, Object> map) {
            Object object = this.function.evaluate(map);
            return object != null;
        }

        public String toString() {
            return "{#" + this.function.getName() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleFieldPart
    implements Part {
        private String fieldName;

        public SimpleFieldPart(String string) {
            this.fieldName = string;
        }

        @Override
        public void write(StringBuffer stringBuffer, Map<String, Object> map) {
            if (!map.containsKey(this.fieldName)) {
                throw new IllegalArgumentException("Message pattern contains unsupported field name: " + this.fieldName);
            }
            Object object = map.get(this.fieldName);
            AdvancedMessageFormat.formatObject(object, stringBuffer);
        }

        @Override
        public boolean isGenerated(Map<String, Object> map) {
            Object object = map.get(this.fieldName);
            return object != null;
        }

        public String toString() {
            return "{" + this.fieldName + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextPart
    implements Part {
        private String text;

        public TextPart(String string) {
            this.text = string;
        }

        @Override
        public void write(StringBuffer stringBuffer, Map<String, Object> map) {
            stringBuffer.append(this.text);
        }

        @Override
        public boolean isGenerated(Map<String, Object> map) {
            return true;
        }

        public String toString() {
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Function {
        public Object evaluate(Map<String, Object> var1);

        public Object getName();
    }

    public static interface ObjectFormatter {
        public void format(StringBuffer var1, Object var2);

        public boolean supportsObject(Object var1);
    }

    public static interface PartFactory {
        public Part newPart(String var1, String var2);

        public String getFormat();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Part {
        public void write(StringBuffer var1, Map<String, Object> var2);

        public boolean isGenerated(Map<String, Object> var1);
    }
}

