/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.toolbox.distcomp.auth.AllowedUserList;
import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.AuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.AuthorisationModuleConfig;
import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.InvalidAdminPasswordException;
import com.mathworks.toolbox.distcomp.auth.InvalidPasswordException;
import com.mathworks.toolbox.distcomp.auth.NoAuthorisedUserFoundException;
import com.mathworks.toolbox.distcomp.auth.NotAdminUserException;
import com.mathworks.toolbox.distcomp.auth.SecurityModuleProvider;
import com.mathworks.toolbox.distcomp.auth.UnknownUserException;
import com.mathworks.toolbox.distcomp.auth.UserCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialRole;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptedAuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptedUserCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.PlainCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialTransferException;
import com.mathworks.toolbox.distcomp.auth.credentials.store.NoCredentialsException;
import com.mathworks.toolbox.distcomp.storage.CredentialStorage;
import com.mathworks.toolbox.distcomp.storage.CredentialStorageErrorCode;
import com.mathworks.toolbox.distcomp.storage.CredentialStorageException;
import com.mathworks.toolbox.distcomp.storage.CredentialsNotFoundException;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class AuthorisationModuleImpl
implements AuthorisationModule {
    private static final byte[] SALT = new byte[0];
    private static final boolean STORE_ENCRYPTED = true;
    private final int fSecurityLevel;
    private final CryptoModule fTransferCryptoModule;
    private CryptoModule fStorageCryptoModule;
    private final CryptoModule.Hasher fHasher;
    private final CredentialStorage fCredentialStorage;
    private final UserIdentity fAdminUserIdentity;
    private final AllowedUserList fAllowedUsers;
    private UserIdentity fCachedUser;
    private CredentialProviderLocal fCachedProvider;

    AuthorisationModuleImpl(AuthorisationModuleConfig authorisationModuleConfig) throws StorageInitException {
        this.fSecurityLevel = authorisationModuleConfig.getSecurityLevel();
        this.fTransferCryptoModule = authorisationModuleConfig.getTransferCryptoModule();
        this.fStorageCryptoModule = authorisationModuleConfig.getStorageCryptoModule();
        this.fHasher = authorisationModuleConfig.getHasher();
        this.fCredentialStorage = authorisationModuleConfig.getStorageFactory().createCredentialStorage();
        this.fAdminUserIdentity = authorisationModuleConfig.getAdminUserIdentity();
        this.fAllowedUsers = authorisationModuleConfig.getAllowedUsers();
    }

    @Override
    public void checkCredentials(UserIdentity userIdentity, List<UserIdentity> list, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        list.add(this.fAdminUserIdentity);
        this.checkCredentialsOfUserAndAuthorisedUsers(userIdentity, list, credentialProviderLocal);
    }

    @Override
    public void checkCredentialsAdminOnly(CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        try {
            this.checkCredentials(this.fAdminUserIdentity, credentialProviderLocal);
        }
        catch (NoCredentialsException noCredentialsException) {
            throw new NotAdminUserException(this.fAdminUserIdentity, (Throwable)noCredentialsException);
        }
        catch (InvalidPasswordException invalidPasswordException) {
            throw new InvalidAdminPasswordException(this.fAdminUserIdentity, (Throwable)invalidPasswordException);
        }
    }

    @Override
    public void checkCredentialsUserOnly(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        List<UserIdentity> list = Collections.emptyList();
        this.checkCredentialsOfUserAndAuthorisedUsers(userIdentity, list, credentialProviderLocal);
    }

    private void checkCredentialsOfUserAndAuthorisedUsers(UserIdentity userIdentity, List<UserIdentity> list, CredentialProviderLocal credentialProviderLocal) throws NoAuthorisedUserFoundException, CredentialStorageException {
        try {
            this.checkCredentials(userIdentity, credentialProviderLocal);
            return;
        }
        catch (AuthorisationFailedException authorisationFailedException) {
            NoAuthorisedUserFoundException noAuthorisedUserFoundException = new NoAuthorisedUserFoundException(userIdentity);
            noAuthorisedUserFoundException.put(userIdentity, authorisationFailedException);
            for (UserIdentity userIdentity2 : list) {
                try {
                    this.checkCredentials(userIdentity2, credentialProviderLocal);
                    return;
                }
                catch (AuthorisationFailedException authorisationFailedException2) {
                    noAuthorisedUserFoundException.put(userIdentity2, authorisationFailedException2);
                }
            }
            throw noAuthorisedUserFoundException;
        }
    }

    private void checkCredentials(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        AuthenticationToken authenticationToken;
        if (this.cachedSuccess(userIdentity, credentialProviderLocal)) {
            return;
        }
        try {
            authenticationToken = this.retrieveAuthenticationToken(userIdentity);
        }
        catch (CredentialsNotFoundException credentialsNotFoundException) {
            throw new UnknownUserException(userIdentity, (Throwable)credentialsNotFoundException);
        }
        AuthenticationToken authenticationToken2 = (AuthenticationToken)credentialProviderLocal.getCredentials(userIdentity, this.fTransferCryptoModule);
        this.checkTokens(authenticationToken, authenticationToken2);
        this.cacheSuccess(userIdentity, credentialProviderLocal);
    }

    protected void checkTokens(AuthenticationToken authenticationToken, AuthenticationToken authenticationToken2) throws InvalidPasswordException {
        if (!authenticationToken2.equals(authenticationToken)) {
            throw new InvalidPasswordException(authenticationToken2.getUserIdentity());
        }
    }

    @Override
    public final UserCredentials getCredentials(UserIdentity userIdentity) throws CredentialCreationException, CredentialStorageException, CredentialsNotFoundException {
        return this.retrieveUserCredentials(userIdentity);
    }

    @Override
    public boolean userExists(UserIdentity userIdentity) throws CredentialStorageException {
        try {
            this.fCredentialStorage.getCredentials(userIdentity, CredentialRole.AUTH_TOKEN);
            return true;
        }
        catch (CredentialsNotFoundException credentialsNotFoundException) {
            return false;
        }
    }

    @Override
    public final void addNewUser(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        if (this.userExists(userIdentity)) {
            return;
        }
        if (this.fAdminUserIdentity.equals(userIdentity) || !this.fAllowedUsers.isUserAllowed(userIdentity)) {
            throw new UserCreationException(userIdentity);
        }
        this.addPasswordToDatabase(this.retrieveUser(userIdentity, credentialProviderLocal));
    }

    protected final PlainCredentials retrieveUser(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException {
        return (PlainCredentials)credentialProviderLocal.getCredentials(userIdentity, this.fTransferCryptoModule);
    }

    @Override
    public final void addAdminUser(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        if (this.userExists(userIdentity)) {
            return;
        }
        this.addPasswordToDatabase(this.retrieveAdminUser(userIdentity, credentialProviderLocal));
    }

    protected PlainCredentials retrieveAdminUser(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException {
        return (PlainCredentials)credentialProviderLocal.getCredentials(userIdentity, this.fTransferCryptoModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPasswordToDatabase(PlainCredentials plainCredentials) throws CredentialCreationException, CredentialStorageException {
        try {
            Map<CredentialRole, TransferableCredentials> map = this.generateCredentialMapForPlainCredentials(plainCredentials);
            this.fCredentialStorage.putMultipleCredentials(map);
        }
        finally {
            plainCredentials.erase();
        }
    }

    @Override
    public void changeCredentialsOfExistingUser(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal, CredentialProviderLocal credentialProviderLocal2) throws AuthorisationFailedException, CredentialStorageException {
        if (!this.userExists(userIdentity)) {
            throw new UnknownUserException(userIdentity);
        }
        this.checkCredentialsOfUserAndAdmin(userIdentity, credentialProviderLocal);
        this.changePasswordInDatabase(userIdentity, credentialProviderLocal2);
    }

    private void checkCredentialsOfUserAndAdmin(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        List<UserIdentity> list = Collections.singletonList(this.fAdminUserIdentity);
        this.checkCredentialsOfUserAndAuthorisedUsers(userIdentity, list, credentialProviderLocal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changePasswordInDatabase(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws CredentialCreationException, CredentialTransferException, CredentialStorageException, NoCredentialsException {
        PlainCredentials plainCredentials = (PlainCredentials)credentialProviderLocal.getCredentials(userIdentity, this.fTransferCryptoModule);
        try {
            Map<CredentialRole, TransferableCredentials> map = this.generateCredentialMapForPlainCredentials(plainCredentials);
            this.fCredentialStorage.updateMultipleCredentials(map);
        }
        finally {
            plainCredentials.erase();
        }
    }

    private Map<CredentialRole, TransferableCredentials> generateCredentialMapForPlainCredentials(PlainCredentials plainCredentials) throws CredentialCreationException, CredentialEncryptionException {
        HashMap<CredentialRole, TransferableCredentials> hashMap = new HashMap<CredentialRole, TransferableCredentials>(2);
        AuthenticationToken authenticationToken = plainCredentials.createAuthenticationToken(this.fHasher);
        hashMap.put(CredentialRole.AUTH_TOKEN, authenticationToken.prepare());
        if (SecurityModuleProvider.isRunAsUser(this.fSecurityLevel)) {
            try {
                hashMap.put(CredentialRole.PASSWORD, plainCredentials.prepare(true, SALT, this.fStorageCryptoModule.getEncryptor()));
            }
            catch (CryptoException cryptoException) {
                throw new CredentialEncryptionException(cryptoException);
            }
        }
        return hashMap;
    }

    private UserCredentials retrieveUserCredentials(UserIdentity userIdentity) throws CredentialCreationException, CredentialStorageException, CredentialsNotFoundException {
        Map<CredentialRole, TransferableCredentials> map = this.fCredentialStorage.getAllCredentials(userIdentity);
        EncryptedUserCredentials encryptedUserCredentials = new EncryptedUserCredentials(userIdentity, map);
        try {
            return encryptedUserCredentials.unpack(SALT, this.fStorageCryptoModule.getDecryptor());
        }
        catch (CryptoException cryptoException) {
            throw new CredentialDecryptionException(cryptoException);
        }
    }

    private AuthenticationToken retrieveAuthenticationToken(UserIdentity userIdentity) throws CredentialCreationException, CredentialStorageException, CredentialsNotFoundException {
        TransferableCredentials transferableCredentials = this.fCredentialStorage.getCredentials(userIdentity, CredentialRole.AUTH_TOKEN);
        return ((EncryptedAuthenticationToken)transferableCredentials).unpack();
    }

    private boolean cachedSuccess(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) {
        return userIdentity.equals(this.fCachedUser) && credentialProviderLocal.equals(this.fCachedProvider);
    }

    private void cacheSuccess(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) {
        this.fCachedUser = userIdentity;
        this.fCachedProvider = credentialProviderLocal;
    }

    @Override
    public void close() throws StorageException {
        this.fCredentialStorage.close();
    }

    private static class CredentialDecryptionException
    extends CredentialStorageException {
        CredentialDecryptionException(CryptoException cryptoException) {
            super(CredentialStorageErrorCode.CredentialDecryptionFailure, (Throwable)cryptoException, new Object[0]);
        }
    }

    private static class CredentialEncryptionException
    extends CredentialStorageException {
        CredentialEncryptionException(CryptoException cryptoException) {
            super(CredentialStorageErrorCode.CredentialEncryptionFailure, (Throwable)cryptoException, new Object[0]);
        }
    }
}

