/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.EncryptedObject;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.modules.CryptoModuleHelper;
import com.mathworks.toolbox.distcomp.auth.modules.KeyPairProvider;
import com.mathworks.toolbox.distcomp.auth.modules.ModuleCreationException;
import com.mathworks.toolbox.distcomp.auth.modules.SaltMismatchException;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;

public class CryptoModuleKeyPairImpl
implements CryptoModule {
    private KeyPair fKeyPair;

    public CryptoModuleKeyPairImpl(KeyPairProvider keyPairProvider) throws ModuleCreationException, CryptoException {
        this.fKeyPair = keyPairProvider.getKeyPair();
    }

    @Override
    public CryptoModule.Encryptor getEncryptor() {
        return new KeyPairEncryptor(this.fKeyPair.getPublic());
    }

    @Override
    public CryptoModule.Decryptor getDecryptor() {
        return new KeyPairDecryptor(this.fKeyPair.getPrivate());
    }

    @Override
    public byte[] createSalt(int n) {
        return CryptoModuleHelper.INSTANCE.createSalt(n);
    }

    static {
        CryptoModuleHelper.INSTANCE.initialize();
    }

    @Deprecated
    private static class KeyPairHasher
    implements CryptoModule.Hasher {
        private static final long serialVersionUID = 4498070618029360779L;

        private KeyPairHasher() {
        }

        @Override
        public Erasable createHash(Erasable erasable) {
            throw new UnsupportedOperationException("KeyPairHasher should not be used. Use com.mathworks.toolbox.distcomp.auth.modules.SecureHasher instead.");
        }
    }

    private static class KeyPairDecryptor
    implements CryptoModule.Decryptor {
        private PrivateKey iPrivateKey;

        KeyPairDecryptor(PrivateKey privateKey) {
            this.iPrivateKey = privateKey;
        }

        @Override
        public Erasable decrypt(EncryptedObject encryptedObject) throws CryptoException {
            return new Erasable(CryptoModuleHelper.INSTANCE.decryptKeyPair(encryptedObject, this.iPrivateKey));
        }

        @Override
        public Erasable decryptWithSalt(EncryptedObject encryptedObject, byte[] byArray) throws CryptoException {
            Erasable erasable = this.decrypt(encryptedObject);
            int n = byArray.length;
            if (n == 0) {
                return erasable;
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(erasable.get(), 0, byArray2, 0, n);
            if (!Arrays.equals(byArray, byArray2)) {
                throw new SaltMismatchException();
            }
            int n2 = erasable.get().length - n;
            byte[] byArray3 = new byte[n2];
            System.arraycopy(erasable.get(), n, byArray3, 0, n2);
            erasable.erase();
            return new Erasable(byArray3);
        }
    }

    private static class KeyPairEncryptor
    implements CryptoModule.Encryptor,
    Serializable {
        private PublicKey iPublicKey;

        KeyPairEncryptor(PublicKey publicKey) {
            this.iPublicKey = publicKey;
        }

        @Override
        public EncryptedObject encrypt(Erasable erasable) throws CryptoException {
            return CryptoModuleHelper.INSTANCE.encryptKeyPair(erasable.get(), this.iPublicKey);
        }

        @Override
        public EncryptedObject encryptWithSalt(Erasable erasable, byte[] byArray) throws CryptoException {
            return this.encrypt(Erasable.concat(byArray, erasable.get()));
        }
    }
}

