/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.toolbox.distcomp.clusteraccess.CouldNotRemoveJobFilesException;
import com.mathworks.toolbox.distcomp.clusteraccess.FileMirrorControl;
import com.mathworks.toolbox.distcomp.clusteraccess.JobNotMirroredException;
import com.mathworks.toolbox.distcomp.clusteraccess.LastMirrorFilesChore;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesInfo;
import com.mathworks.toolbox.distcomp.clusteraccess.OneTimeChore;
import com.mathworks.toolbox.distcomp.clusteraccess.RemoveFilesChore;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class LastMirrorAndRemoveChore
extends OneTimeChore {
    private final MirrorFilesInfo fMirrorFilesInfo;
    private final Lock fLock = new ReentrantLock();
    private LastMirrorFilesChore fLastMirrorFilesChore = null;
    private RemoveFilesChore fRemoveFilesChore = null;

    LastMirrorAndRemoveChore(MirrorFilesInfo mirrorFilesInfo, String string, ParameterMap parameterMap, FileMirrorControl fileMirrorControl) {
        super(string, parameterMap, fileMirrorControl);
        this.fMirrorFilesInfo = mirrorFilesInfo;
    }

    @Override
    public boolean runChore() throws JobNotMirroredException, CouldNotRemoveJobFilesException {
        this.doLastMirror();
        this.doRemove();
        return !this.hasBeenCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLastMirror() throws JobNotMirroredException {
        this.fLock.lock();
        try {
            this.fLastMirrorFilesChore = this.getFileMirrorControl().createLastMirrorForJob(this.fMirrorFilesInfo);
            this.getFileMirrorControl().stopMirrorBeforeLastMirror(this.fMirrorFilesInfo);
        }
        finally {
            this.fLock.unlock();
        }
        this.fLastMirrorFilesChore.runChore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemove() throws CouldNotRemoveJobFilesException {
        this.fLock.lock();
        try {
            this.fRemoveFilesChore = new RemoveFilesChore(this.fMirrorFilesInfo, this.getHostname(), this.getParameterMap(), this.getFileMirrorControl());
        }
        finally {
            this.fLock.unlock();
        }
        this.fRemoveFilesChore.runChore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.fLock.lock();
        try {
            if (null != this.fRemoveFilesChore) {
                this.fRemoveFilesChore.cancel();
            }
            if (null != this.fLastMirrorFilesChore) {
                this.fLastMirrorFilesChore.cancel();
            }
        }
        finally {
            this.fLock.unlock();
        }
        super.cancel();
    }

    @Override
    public String logPrefix() {
        return "LastMirrorAndRemoveChore files for job " + this.fMirrorFilesInfo.getJobId() + " from " + this.getHostname() + ": ";
    }
}

