/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.clusteraccess.CouldNotRemoveJobFilesException;
import com.mathworks.toolbox.distcomp.clusteraccess.FileMirrorControl;
import com.mathworks.toolbox.distcomp.clusteraccess.Log;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesInfo;
import com.mathworks.toolbox.distcomp.clusteraccess.OneTimeChore;
import com.mathworks.toolbox.distcomp.clusteraccess.SharedPath;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FileSystemManipulatorFuture;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.NoSuchProtocolException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolProvider;
import com.mathworks.toolbox.distcomp.remote.RemoveFileCommand;
import com.mathworks.toolbox.distcomp.remote.spi.FileSystemManipulator;
import java.util.HashSet;
import java.util.Set;

final class RemoveFilesChore
extends OneTimeChore {
    private final MirrorFilesInfo fMirrorFilesInfo;

    RemoveFilesChore(MirrorFilesInfo mirrorFilesInfo, String string, ParameterMap parameterMap, FileMirrorControl fileMirrorControl) {
        super(string, parameterMap, fileMirrorControl);
        this.fMirrorFilesInfo = mirrorFilesInfo;
    }

    @Override
    public boolean runChore() throws CouldNotRemoveJobFilesException {
        this.deleteFiles();
        return !this.hasBeenCanceled();
    }

    @Override
    FileSystemManipulatorFuture getFuture() throws InterruptedException {
        return (FileSystemManipulatorFuture)super.getFuture();
    }

    private void deleteFiles() throws CouldNotRemoveJobFilesException {
        try {
            FileSystemManipulator fileSystemManipulator = (FileSystemManipulator)ProtocolProvider.getInstance().getProtocolByType("sftp");
            this.deleteFiles(this.fMirrorFilesInfo.getStateFilePaths(), this.fMirrorFilesInfo.getExcludeFromRemove(), fileSystemManipulator);
            this.deleteFiles(this.fMirrorFilesInfo.getDataFilePaths(), this.fMirrorFilesInfo.getExcludeFromRemove(), fileSystemManipulator);
        }
        catch (NoSuchProtocolException noSuchProtocolException) {
            AssertionError assertionError = new AssertionError((Object)"Someone's removed sftp from the ProtocolProvider");
            ((Throwable)((Object)assertionError)).initCause(noSuchProtocolException);
            throw assertionError;
        }
    }

    private void deleteFiles(Set<SharedPath> set, Set<SharedPath> set2, FileSystemManipulator fileSystemManipulator) throws CouldNotRemoveJobFilesException {
        if (!this.hasBeenCanceled()) {
            HashSet<SharedPath> hashSet = new HashSet<SharedPath>(set);
            hashSet.removeAll(set2);
            Set<String> set3 = SharedPath.sharedPathsToRemotePaths(hashSet, this.fMirrorFilesInfo.getRemoteDataLocation());
            RemoveFileCommand removeFileCommand = new RemoveFileCommand(set3);
            Log.LOGGER.finest(this.logPrefix() + "About to start to remove " + set3);
            try {
                this.performRemoteCommand(removeFileCommand, fileSystemManipulator, "Started removing " + set + " for job " + this.fMirrorFilesInfo.getJobId());
            }
            catch (DispatchException dispatchException) {
                throw new CouldNotRemoveJobFilesDispatchException(this.fMirrorFilesInfo.getJobId(), set, dispatchException);
            }
            this.awaitEndOfRemovingFiles(set);
        }
    }

    private void awaitEndOfRemovingFiles(Set<SharedPath> set) throws CouldNotRemoveJobFilesException {
        try {
            if (!this.hasBeenCanceled()) {
                this.awaitEndOfFuture();
                Log.LOGGER.finer(this.logPrefix() + "Finished removing " + set);
            }
        }
        catch (FulfillmentException fulfillmentException) {
            throw new CouldNotRemoveJobFilesFulfillmentException(this.fMirrorFilesInfo.getJobId(), set, fulfillmentException);
        }
        catch (InterruptedException interruptedException) {
            throw new CouldNotRemoveJobFilesInterruptedException(this.fMirrorFilesInfo.getJobId(), set, interruptedException);
        }
    }

    @Override
    public String logPrefix() {
        return "Remove files for job " + this.fMirrorFilesInfo.getJobId() + " from " + this.getHostname() + ": ";
    }

    private static final class CouldNotRemoveJobFilesInterruptedException
    extends CouldNotRemoveJobFilesException {
        CouldNotRemoveJobFilesInterruptedException(int n, Set<SharedPath> set, InterruptedException interruptedException) {
            super(n, set, interruptedException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.CouldNotRemoveJobFilesInterrupted(this.getJobIdAsString(), this.getPathsAsString(), this.getExceptionCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.CouldNotRemoveJobFilesInterrupted(this.getJobIdAsString(), this.getPathsAsString(), this.getExceptionCause().getLocalizedMessage());
        }
    }

    private static final class CouldNotRemoveJobFilesFulfillmentException
    extends CouldNotRemoveJobFilesException {
        CouldNotRemoveJobFilesFulfillmentException(int n, Set<SharedPath> set, FulfillmentException fulfillmentException) {
            super(n, set, fulfillmentException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.CouldNotRemoveJobFilesFulfillment(this.getJobIdAsString(), this.getPathsAsString(), this.getExceptionCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.CouldNotRemoveJobFilesFulfillment(this.getJobIdAsString(), this.getPathsAsString(), this.getExceptionCause().getLocalizedMessage());
        }
    }

    private static final class CouldNotRemoveJobFilesDispatchException
    extends CouldNotRemoveJobFilesException {
        CouldNotRemoveJobFilesDispatchException(int n, Set<SharedPath> set, DispatchException dispatchException) {
            super(n, set, dispatchException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.CouldNotRemoveJobFilesDispatch(this.getJobIdAsString(), this.getPathsAsString(), this.getExceptionCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.CouldNotRemoveJobFilesDispatch(this.getJobIdAsString(), this.getPathsAsString(), this.getExceptionCause().getLocalizedMessage());
        }
    }
}

