/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.control.CommandDialogHandShake;
import com.mathworks.toolbox.distcomp.control.CommandListener;
import com.mathworks.toolbox.distcomp.control.ControlExceptionFactory;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.control.PortConfig;
import com.mathworks.toolbox.distcomp.control.serviceinfo.VersionMismatchException;
import com.mathworks.toolbox.distcomp.util.AdminUserRegistrar;
import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.util.FormattableException;
import com.mathworks.toolbox.distcomp.util.Version;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;

public final class CommandSender {
    private static final int DEFAULT_SOCKET_TIMEOUT_SECS = 0;
    private static final ControlExceptionFactory<ErrorKey> ERROR_FACTORY = new ControlExceptionFactory();

    private CommandSender() {
    }

    public static MDCSCommandResults sendAndRunCommand(MDCSCommand mDCSCommand, String string, int n) throws Exception {
        return CommandSender.sendAndRunCommand(mDCSCommand, string, n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MDCSCommandResults sendAndRunCommand(MDCSCommand mDCSCommand, String string, int n, int n2) throws Exception {
        Socket socket;
        mDCSCommand.beforeRun();
        try {
            socket = CommandSender.getSocketTryManyTimes(string, n, mDCSCommand.maxTimeForRemoteTries(), mDCSCommand.timeBetweenTriesInMilliSeconds());
            socket.setSoTimeout(n2 * 1000);
        }
        catch (Exception exception) {
            throw CommandSender.handleConnectionException(exception, string, n);
        }
        MDCSCommandResults mDCSCommandResults = null;
        try {
            Object object;
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.writeInt(2999);
            dataOutputStream.writeInt(20);
            dataOutputStream.flush();
            try {
                object = new DataInputStream(socket.getInputStream());
                int n3 = ((DataInputStream)object).readInt();
                int n4 = ((DataInputStream)object).readInt();
                CommandDialogHandShake.checkProtocolAndVersion(n3, n4);
            }
            catch (SocketException socketException) {
                throw CommandSender.handleReceiveException(socketException, string, n);
            }
            catch (CommandDialogHandShake.HandShakeException handShakeException) {
                throw CommandSender.handleConnectionException(handShakeException, string, n);
            }
            try {
                object = new ObjectOutputStream(socket.getOutputStream());
                ((ObjectOutputStream)object).writeObject(mDCSCommand);
                ((ObjectOutputStream)object).flush();
            }
            catch (Exception exception) {
                throw CommandSender.handleSendException(exception, string, n);
            }
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                throw CommandSender.handleReceiveException(exception, string, n);
            }
            if (object instanceof Throwable) {
                throw CommandSender.handleRunResultThrowable((Throwable)object, string, n);
            }
            mDCSCommandResults = (MDCSCommandResults)object;
        }
        finally {
            socket.close();
        }
        try {
            mDCSCommand.afterRun();
        }
        catch (Exception exception) {
            throw CommandSender.handleAfterRunThrowable(exception, string, n);
        }
        return mDCSCommandResults;
    }

    private static Exception handleConnectionException(Exception exception, String string, int n) {
        Exception exception2 = null;
        exception2 = exception instanceof UnknownHostException ? ERROR_FACTORY.createFormattableException(null, ErrorKey.UNKNOWN_HOST, string) : (exception instanceof ConnectException ? ERROR_FACTORY.createFormattableException(null, ErrorKey.FAILED_TO_CONNECT, PortConfig.getBasePortFromRemoteCommandPort(n), string, n) : exception);
        return ERROR_FACTORY.diagnoseWithHostAndPort(exception2, ErrorKey.MDCS_COULD_NOT_CONNECT, string, n);
    }

    private static Exception handleSendException(Exception exception, String string, int n) {
        return CommandSender.handleSendReceiveException(exception, string, n, true);
    }

    private static Exception handleReceiveException(Exception exception, String string, int n) {
        return CommandSender.handleSendReceiveException(exception, string, n, false);
    }

    private static Exception handleSendReceiveException(Exception exception, String string, int n, boolean bl) {
        ErrorKey errorKey;
        FormattableException formattableException = null;
        if (exception instanceof SocketException) {
            formattableException = bl ? ERROR_FACTORY.createFormattableException(null, ErrorKey.SEND_FAILED_INCOMPATIBLE_VERSIONS, Version.VERSION_STRING, PortConfig.getBasePortFromRemoteCommandPort(n)) : ERROR_FACTORY.createFormattableException(null, ErrorKey.RECEIVE_FAILED_INCOMPATIBLE_VERSIONS, Version.VERSION_STRING);
        }
        ErrorKey errorKey2 = errorKey = bl ? ErrorKey.MDCS_REQUEST_SEND_ERROR : ErrorKey.MDCS_REQUEST_RECEIVE_ERROR;
        if (formattableException != null) {
            return ERROR_FACTORY.diagnoseWithHostAndError(formattableException, errorKey, string, exception);
        }
        return ERROR_FACTORY.createFormattableException(exception, errorKey, string, exception.getLocalizedMessage());
    }

    private static Exception handleRunResultThrowable(Throwable throwable, String string, int n) {
        Object object;
        Throwable throwable2 = null;
        if (throwable instanceof DistcompDiagnosticException) {
            object = (DistcompDiagnosticException)throwable;
            if (CommandSender.isVersionMismatch((DistcompDiagnosticException)object)) {
                FormattableException formattableException = (FormattableException)((Throwable)object).getCause();
                String string2 = (String)formattableException.getParams()[0];
                throwable2 = new VersionMismatchException(string, Version.VERSION_STRING, string2);
                return ERROR_FACTORY.diagnoseWithHostAndPort(throwable2, ErrorKey.MDCS_ERROR_ON_HOST, string, n);
            }
            if (throwable.getCause() != null) {
                throwable2 = throwable.getCause();
                return ERROR_FACTORY.diagnoseWithHostAndError(throwable2, ErrorKey.MDCS_FOLLOWING_ERROR_ON_HOST, string, throwable);
            }
            throwable2 = throwable;
        }
        object = ErrorKey.MDCS_ERROR_ON_HOST;
        if (throwable2 != null) {
            return ERROR_FACTORY.diagnoseWithHostAndPort(throwable2, (ErrorKey)((Object)object), string, n);
        }
        return ERROR_FACTORY.createFormattableException(throwable, (ErrorKey)((Object)object), string, n);
    }

    private static Exception handleAfterRunThrowable(Exception exception, String string, int n) {
        if (exception instanceof AdminUserRegistrar.RegistrationException) {
            return ERROR_FACTORY.diagnose(exception.getCause(), ErrorKey.ADMIN_REGISTRATION_PROBLEM, string, n, exception.getCause());
        }
        return ERROR_FACTORY.createFormattableException(exception, ErrorKey.AFTER_RUN_FAILED, string, n);
    }

    private static Socket getSocketTryManyTimes(String string, int n, int n2, int n3) throws Exception {
        long l = System.currentTimeMillis();
        while (true) {
            try {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
                Socket socket = new Socket();
                socket.connect(inetSocketAddress, n2);
                return socket;
            }
            catch (Exception exception) {
                long l2 = System.currentTimeMillis() - l;
                if (l2 + (long)n3 > (long)n2) {
                    throw exception;
                }
                try {
                    Thread.sleep(n3);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private static boolean isVersionMismatch(DistcompDiagnosticException distcompDiagnosticException) {
        boolean bl;
        Object object;
        Object[] objectArray = new Object[]{CommandListener.ErrorKey.INVALID_CLASS_DETAIL, CommandListener.ErrorKey.INVALID_VERSION_DETAIL, CommandListener.ErrorKey.INVALID_CLASS, CommandListener.ErrorKey.INVALID_VERSION, ErrorKey.RECEIVE_FAILED_INCOMPATIBLE_VERSIONS, ErrorKey.SEND_FAILED_INCOMPATIBLE_VERSIONS};
        HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList(objectArray));
        if (hashSet.contains(object = distcompDiagnosticException.getResourceKey())) {
            return true;
        }
        Throwable throwable = distcompDiagnosticException.getCause();
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof FormattableException) {
            return hashSet.contains(((FormattableException)throwable).getResourceKey());
        }
        boolean bl2 = bl = ErrorKey.MDCS_FOLLOWING_ERROR_ON_HOST == distcompDiagnosticException.getResourceKey();
        if (bl) {
            Object[] objectArray2 = distcompDiagnosticException.getParams();
            FormattableException formattableException = null;
            for (Object object2 : objectArray2) {
                if (!(object2 instanceof Throwable)) continue;
                formattableException = (DistcompDiagnosticException)object2;
                break;
            }
            return formattableException != null && formattableException.isMarshalledFromOldVersion();
        }
        return false;
    }

    private static enum ErrorKey {
        MDCS_COULD_NOT_CONNECT,
        MDCS_REQUEST_SEND_ERROR,
        MDCS_REQUEST_RECEIVE_ERROR,
        MDCS_FOLLOWING_ERROR_ON_HOST,
        MDCS_ERROR_ON_HOST,
        UNKNOWN_HOST,
        FAILED_TO_CONNECT,
        SEND_FAILED_INCOMPATIBLE_VERSIONS,
        RECEIVE_FAILED_INCOMPATIBLE_VERSIONS,
        AFTER_RUN_FAILED,
        ADMIN_REGISTRATION_PROBLEM;

    }
}

