/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.control.ConfigRunner;
import com.mathworks.toolbox.distcomp.control.ControlMessage;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcess;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcessInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.CheckpointDirInfo;
import com.mathworks.toolbox.distcomp.util.RemoteConfigurationFileOverride;
import com.mathworks.toolbox.distcomp.util.SystemPropertyNames;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;
import java.util.List;

public final class ControlWorker
extends ControlStartStopProcess {
    private static final long serialVersionUID = 1L;
    private RemoteConfigurationFileOverride fJobmanager;
    private RemoteConfigurationFileOverride fLookupHosts;
    private ControlWorkerInfo fInfo;
    private boolean fCreateNewDefaultName = false;

    @Override
    protected String getDefaultServiceName() {
        String string = System.getProperty("com.mathworks.toolbox.distcomp.default_worker_name", "");
        int n = this.fCreateNewDefaultName ? CheckpointDirInfo.getLastAssignedNumber(string) + 1 : CheckpointDirInfo.getLastAssignedNumber(string);
        if (n == 0) {
            return string;
        }
        int n2 = 2;
        return string + String.format("%0" + n2 + "d", n);
    }

    @Override
    protected void preRunSetup(WarningAndNoteInfo warningAndNoteInfo) {
        super.preRunSetup(warningAndNoteInfo);
        this.fJobmanager.setDefaultValue(System.getProperty("com.mathworks.toolbox.distcomp.default_jobmanager_name", ""));
        if (this.isStarting()) {
            this.prepareLookupHostsForExport(warningAndNoteInfo);
        }
        this.fInfo.setJobmanager(this.fJobmanager.getValue());
    }

    @Override
    protected void postRunTeardown() {
        super.postRunTeardown();
    }

    @Override
    protected void addConfigFileOverride(List<String> list) {
        super.addConfigFileOverride(list);
        list.add(this.fJobmanager.getConfigEntryOverride());
        list.add(this.fLookupHosts.getConfigEntryOverride());
    }

    public ControlWorker(ConfigRunner configRunner, boolean bl, String string, String string2, String string3) {
        super(configRunner, bl, string, string2);
        this.fJobmanager = new RemoteConfigurationFileOverride(SystemPropertyNames.JOBMANAGER_NAME, string3);
        this.fLookupHosts = new RemoteConfigurationFileOverride(SystemPropertyNames.LOOKUP_HOSTS, "WORKER_LOOKUP_NOT_SPECIFIED");
        this.fInfo = new ControlWorkerInfo();
    }

    public ControlWorker(ConfigRunner configRunner, boolean bl, String string, String string2, String string3, boolean bl2) {
        this(configRunner, bl, string, string2, string3);
        this.fCreateNewDefaultName = bl2;
    }

    public void setLookupHosts(String string) {
        if (string != null && string.length() > 0) {
            this.fLookupHosts.setValue(string);
        }
    }

    @Override
    public ControlStartStopProcessInfo getInfo() {
        return this.fInfo;
    }

    private void prepareLookupHostsForExport(WarningAndNoteInfo warningAndNoteInfo) {
        boolean bl;
        boolean bl2 = bl = !"WORKER_LOOKUP_NOT_SPECIFIED".equals(this.fLookupHosts.getValue());
        if (bl) {
            return;
        }
        String string = System.getProperty(SystemPropertyNames.LOOKUP_HOSTS.getPropertyName(), "");
        boolean bl3 = "MDCE_LOOKUP_NOT_SPECIFIED".equals(string);
        if (bl3) {
            warningAndNoteInfo.addWarning(new WorkerNoLookupSpecifiedFallbackOnMulticastMessage().getLocalizedMessage());
            this.fLookupHosts.setValue("USE_MULTICAST");
        } else {
            this.fLookupHosts.setValue(null);
        }
    }

    private static final class WorkerNoLookupSpecifiedFallbackOnMulticastMessage
    extends ControlWorkerManagerMessage {
        private final BaseMsgID fBaseMsgID = new mjs.WorkerNoLookupSpecifiedFallbackOnMulticast();

        WorkerNoLookupSpecifiedFallbackOnMulticastMessage() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class WorkerStopNotNeededDescriptionMessage
    extends ControlWorkerManagerMessage {
        private final BaseMsgID fBaseMsgID;

        WorkerStopNotNeededDescriptionMessage(String string, String string2) {
            this.fBaseMsgID = new mjs.WorkerStopNotNeededDescription(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class WorkerStartNotNeededDescriptionMessage
    extends ControlWorkerManagerMessage {
        private final BaseMsgID fBaseMsgID;

        WorkerStartNotNeededDescriptionMessage(String string, String string2) {
            this.fBaseMsgID = new mjs.WorkerStartNotNeededDescription(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class WorkerPreStopDescriptionMessage
    extends ControlWorkerManagerMessage {
        private final BaseMsgID fBaseMsgID;

        WorkerPreStopDescriptionMessage(String string) {
            this.fBaseMsgID = new mjs.WorkerPreStopDescription(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class WorkerPreStartDescriptionMessage
    extends ControlWorkerManagerMessage {
        private final BaseMsgID fBaseMsgID;

        WorkerPreStartDescriptionMessage(String string) {
            this.fBaseMsgID = new mjs.WorkerPreStartDescription(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class WorkerStopSuccessDescriptionMessage
    extends ControlWorkerManagerMessage {
        private final BaseMsgID fBaseMsgID;

        WorkerStopSuccessDescriptionMessage(String string, String string2) {
            this.fBaseMsgID = new mjs.WorkerStopSuccessDescription(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class WorkerStartSuccessDescriptionMessage
    extends ControlWorkerManagerMessage {
        private final BaseMsgID fBaseMsgID;

        WorkerStartSuccessDescriptionMessage(String string, String string2, String string3) {
            this.fBaseMsgID = new mjs.WorkerStartSuccessDescription(string, string2, string3);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static abstract class ControlWorkerManagerMessage
    extends ControlMessage {
        ControlWorkerManagerMessage() {
        }
    }

    private static final class ControlWorkerInfo
    extends ControlStartStopProcessInfo {
        private static final long serialVersionUID = 1L;
        private String fJobmanager;

        private ControlWorkerInfo() {
        }

        public void setJobmanager(String string) {
            this.fJobmanager = string;
        }

        public String getJobmanager() {
            return this.fJobmanager;
        }

        @Override
        public String getStartSuccessDescription() {
            return new WorkerStartSuccessDescriptionMessage(this.getServiceName(), this.getRemoteHostname(), this.getJobmanager()).getLocalizedMessage();
        }

        @Override
        public String getStopSuccessDescription() {
            return new WorkerStopSuccessDescriptionMessage(this.getServiceName(), this.getRemoteHostname()).getLocalizedMessage();
        }

        @Override
        public String getPreStartDescription() {
            return new WorkerPreStartDescriptionMessage(this.getRemoteHostname()).getLocalizedMessage();
        }

        @Override
        public String getPreStopDescription() {
            return new WorkerPreStopDescriptionMessage(this.getRemoteHostname()).getLocalizedMessage();
        }

        @Override
        public String getStartNotNeededDescription() {
            return new WorkerStartNotNeededDescriptionMessage(this.getServiceName(), this.getRemoteHostname()).getLocalizedMessage();
        }

        @Override
        public String getStopNotNeededDescription() {
            return new WorkerStopNotNeededDescriptionMessage(this.getServiceName(), this.getRemoteHostname()).getLocalizedMessage();
        }
    }
}

