/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.control.PackageInfo;
import com.mathworks.toolbox.distcomp.nativedmatlab.ProcessManipulation;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.sun.jini.start.LifeCycle;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationID;

public class ParentWatchdog
implements Runnable,
Remote {
    ProcessManipulation fNative = new ProcessManipulation();
    int fParentPID;
    Thread fThread;
    Remote fStub;

    public ParentWatchdog() {
        this.initWatchdog();
    }

    public ParentWatchdog(String[] stringArray, LifeCycle lifeCycle) {
        this.initWatchdog();
    }

    public ParentWatchdog(ActivationID activationID, MarshalledObject marshalledObject) throws RemoteException {
        int n = Integer.getInteger("com.mathworks.toolbox.distcomp.watchdogExportPort", 0);
        this.fStub = Activatable.exportObject((Remote)this, (ActivationID)activationID, (int)n);
        this.initWatchdog();
    }

    protected void initWatchdog() {
        this.fParentPID = this.fNative.getParentPID();
        if (this.fParentPID <= 0) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Unable to get parent pid. getParentPID returned : " + this.fParentPID);
            return;
        }
        this.fThread = new Thread((Runnable)this, "ParentWatchdog");
        this.fThread.setDaemon(true);
        this.fThread.start();
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Watchdog will kill JVM (" + this.fNative.getPID() + ") when pid: " + this.fParentPID + " is no longer alive");
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    if (this.fNative.isPIDAlive(this.fParentPID)) continue;
                    PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Watchdog about to kill JVM as pid: " + this.fParentPID + " is no longer alive");
                    this.fNative.sendSIGKILL();
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }
}

