/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.fl.i18n.XMLMessageSystem;
import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.modules.ModuleCreationException;
import com.mathworks.toolbox.distcomp.control.ConfigRunner;
import com.mathworks.toolbox.distcomp.control.ControlExceptionFactory;
import com.mathworks.toolbox.distcomp.control.ControlMessage;
import com.mathworks.toolbox.distcomp.control.ServiceType;
import com.mathworks.toolbox.distcomp.control.Stopper;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.mjs.security.SharedSecretException;
import com.mathworks.toolbox.distcomp.service.DistcompService;
import com.mathworks.toolbox.distcomp.service.NodeInfo;
import com.mathworks.toolbox.distcomp.service.PersistenceDirException;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;
import com.mathworks.toolbox.distcomp.util.ActivationAdminWrapper;
import com.mathworks.toolbox.distcomp.util.ActivationSystemFinder;
import com.mathworks.toolbox.distcomp.util.ConfigFileWrapper;
import com.mathworks.toolbox.distcomp.util.ConfigurationFileServiceStarterException;
import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import com.mathworks.toolbox.distcomp.util.FormattableException;
import com.mathworks.toolbox.distcomp.util.LocalNetworkInfo;
import com.mathworks.toolbox.distcomp.util.LookupDiscoveryException;
import com.mathworks.toolbox.distcomp.util.NetworkConfigException;
import com.mathworks.toolbox.distcomp.util.NodeInfoAnalyzer;
import com.mathworks.toolbox.distcomp.util.PersistenceDirServiceStarterException;
import com.mathworks.toolbox.distcomp.util.PortUnavailableException;
import com.mathworks.toolbox.distcomp.util.ProxyCreationException;
import com.mathworks.toolbox.distcomp.util.ServiceExportException;
import com.mathworks.toolbox.distcomp.util.ServiceStarterException;
import com.mathworks.toolbox.distcomp.util.SystemPropertyNames;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;
import com.mathworks.toolbox.distcomp.worker.MatlabFailedToStartException;
import com.mathworks.toolbox.distcomp.worker.matlab.WorkerLicenseErrorException;
import com.sun.jini.start.ServiceDescriptor;
import com.sun.jini.start.SharedActivatableServiceDescriptor;
import com.sun.jini.system.FileSystem;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.server.ExportException;
import java.security.AccessControlException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.ConfigurationException;

public class Starter
implements ConfigRunner {
    private static final long serialVersionUID = 1L;
    private static final ControlExceptionFactory<ErrorKey> ERROR_FACTORY = new ControlExceptionFactory();
    private static final int TIME_TO_WAIT_FOR_CONNECTIONS = 2000;
    private static final int MAX_TIME_TO_WAIT_FOR_CONNECTIONS = 10000;
    private static final String sTxtTimeoutCreating = "timeout creating child process";
    private static final String sTxtOriginIsNonLocalHost = "origin is non-local host";

    private static boolean shouldStart(String string, ActivationAdminWrapper activationAdminWrapper) {
        return !ServiceType.isLookup(string) || !activationAdminWrapper.hasLookup();
    }

    private static void verifyServiceIsNotRunning(String string, String string2, ActivationAdminWrapper activationAdminWrapper) throws DistcompDiagnosticException {
        DistcompDiagnosticException distcompDiagnosticException = null;
        ErrorKey errorKey = null;
        if (ServiceType.isJobManager(string)) {
            if (activationAdminWrapper.hasJobManager(string2)) {
                errorKey = ErrorKey.PROBLEM_STARTING_JM;
                distcompDiagnosticException = ERROR_FACTORY.diagnoseWithServiceName(null, ErrorKey.JM_ALREADY_RUNNING, string2);
            }
        } else if (ServiceType.isLookup(string)) {
            if (activationAdminWrapper.hasLookup()) {
                errorKey = ErrorKey.PROBLEM_STARTING_LOOKUP;
                distcompDiagnosticException = ERROR_FACTORY.diagnose(null, ErrorKey.LOOKUP_ALREADY_RUNNING, new Object[0]);
            }
        } else if (ServiceType.isWorker(string)) {
            if (activationAdminWrapper.hasWorker(string2)) {
                errorKey = ErrorKey.PROBLEM_STARTING_WORKER;
                distcompDiagnosticException = ERROR_FACTORY.diagnoseWithServiceName(null, ErrorKey.WORKER_ALREADY_RUNNING, string2);
            }
        } else {
            errorKey = ErrorKey.PROBLEM_STARTING;
            distcompDiagnosticException = ERROR_FACTORY.diagnoseWithServiceType(null, ErrorKey.UNKNOWN_SERVICE_TYPE, string);
            throw ERROR_FACTORY.diagnoseWithServiceType(distcompDiagnosticException, errorKey, string);
        }
        if (distcompDiagnosticException != null) {
            throw ERROR_FACTORY.diagnose(distcompDiagnosticException, errorKey, new Object[0]);
        }
    }

    private static void verifySharedVMDirDoesNotExist(String string, String string2) throws DistcompDiagnosticException {
        File file = new File(string2);
        if (file.isDirectory()) {
            ErrorKey errorKey;
            DistcompDiagnosticException distcompDiagnosticException = ERROR_FACTORY.diagnoseWithDirPath(null, ErrorKey.SHARED_VM_DIR_ALREADY_EXISTS, string2);
            switch (ServiceType.getServiceType(string)) {
                case JOBMANAGER: {
                    errorKey = ErrorKey.SHARED_VM_DIR_ALREADY_EXISTS_JM;
                    break;
                }
                case LOOKUP: {
                    errorKey = ErrorKey.SHARED_VM_DIR_ALREADY_EXISTS_LOOKUP;
                    break;
                }
                case WORKER: {
                    errorKey = ErrorKey.SHARED_VM_DIR_ALREADY_EXISTS_WORKER;
                    break;
                }
                default: {
                    ErrorKey errorKey2 = ErrorKey.SHARED_VM_DIR_ALREADY_EXISTS;
                    throw ERROR_FACTORY.diagnoseWithServiceType(distcompDiagnosticException, errorKey2, string);
                }
            }
            throw ERROR_FACTORY.diagnose(distcompDiagnosticException, errorKey, new Object[0]);
        }
    }

    private static String warnIfPersistenceDirExists(String string, String string2) {
        File file = new File(string);
        return file.isDirectory() ? new PersistenceDirExistsMessage(string2).getLocalizedMessage() : "";
    }

    private static void ensureDir(String string) throws Exception {
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            FileSystem.ensureDir((String)string);
        }
        catch (Exception exception) {
            throw ERROR_FACTORY.diagnoseWithDirPath(exception, ErrorKey.PROBLEM_CREATING_DIR, string);
        }
    }

    private static void cleanDirectory(String string) throws DistcompDiagnosticException {
        if (string == null) {
            return;
        }
        try {
            FileSystem.destroy((File)new File(string), (boolean)false);
            System.out.println(new StarterCleanedCheckpointDataMessage(string).getLocalizedMessage());
        }
        catch (IOException iOException) {
            throw ERROR_FACTORY.diagnoseWithDirPath(iOException, ErrorKey.COULD_NOT_CLEAN_CHECKPT_DATA, string);
        }
    }

    @Override
    public boolean run(WarningAndNoteInfo warningAndNoteInfo, String[] stringArray) throws Exception {
        Object object;
        Object object2;
        ServiceDescriptor[] serviceDescriptorArray;
        ConfigFileWrapper configFileWrapper = new ConfigFileWrapper(stringArray);
        String string = configFileWrapper.getStringEntry("serviceType");
        String string2 = configFileWrapper.getStringEntry("persistenceDirectory");
        String string3 = configFileWrapper.getStringEntry("checkpointDirectory");
        String string4 = configFileWrapper.getStringEntry("logDirectory");
        String string5 = null;
        String string6 = configFileWrapper.getStringEntry("matlabroot");
        XMLMessageSystem.initializeXMLMessageSystem((String)string6);
        if (!string.equals("phoenix")) {
            serviceDescriptorArray = configFileWrapper.getStringEntry("act_sys_host");
            int n = configFileWrapper.getIntEntry("act_sys_port");
            ActivationSystemFinder activationSystemFinder = new ActivationSystemFinder((String)serviceDescriptorArray, n);
            activationSystemFinder.verifySystemTryManyTimes();
            ActivationAdminWrapper activationAdminWrapper = new ActivationAdminWrapper((String)serviceDescriptorArray, n);
            activationAdminWrapper.verifyAdminTryManyTimes();
            Object object3 = configFileWrapper.getStringEntry(SystemPropertyNames.SERVICE_NAME.getConfigKey());
            if (!Starter.shouldStart(string, activationAdminWrapper)) {
                return false;
            }
            Starter.verifyServiceIsNotRunning(string, (String)object3, activationAdminWrapper);
            object2 = configFileWrapper.getStringEntry(SystemPropertyNames.CLEAN_CHECKPOINT_INFO.getConfigKey());
            boolean bl = "true".equals(object2);
            string5 = configFileWrapper.getStringEntry("sharedVM_log");
            if (bl) {
                boolean bl2;
                Starter.cleanDirectory(string5);
                Starter.cleanDirectory(string2);
                if (string.equals("jobmanager") && !(bl2 = "true".equals(object = configFileWrapper.getStringEntry(SystemPropertyNames.PRESERVE_JOB_DATABASE.getConfigKey())))) {
                    String string7 = configFileWrapper.getStringEntry("databaseDirectory");
                    Starter.cleanDirectory(string7);
                }
            } else {
                Starter.verifySharedVMDirDoesNotExist(string, string5);
                warningAndNoteInfo.addWarning(Starter.warnIfPersistenceDirExists(string2, (String)object3));
            }
        }
        Starter.ensureDir(string3);
        Starter.ensureDir(string4);
        for (Object object3 : serviceDescriptorArray = (ServiceDescriptor[])configFileWrapper.getEntry("serviceDescriptors", ServiceDescriptor[].class)) {
            if (object3 == null) continue;
            object2 = Logger.getLogger("com.sun.jini.phoenix");
            Level level = ((Logger)object2).getLevel();
            if (ServiceType.isWorker(string)) {
                ((Logger)object2).setLevel(Level.SEVERE);
            }
            object = null;
            try {
                object = object3.create(configFileWrapper.getConfiguration());
            }
            catch (ActivationException activationException) {
                Stopper.killService(stringArray);
                Starter.cleanDirectory(string5);
                throw Starter.activationGetException(activationException, string);
            }
            catch (InvocationTargetException invocationTargetException) {
                Stopper.killService(stringArray);
                Starter.cleanDirectory(string5);
                throw Starter.invocationTargetGetException(invocationTargetException, string);
            }
            catch (RuntimeException runtimeException) {
                Stopper.killService(stringArray);
                Starter.cleanDirectory(string5);
                throw Starter.runtimeGetException(runtimeException, string);
            }
            catch (Throwable throwable) {
                Stopper.killService(stringArray);
                Starter.cleanDirectory(string5);
                throw Starter.throwableGetException(throwable, string);
            }
            finally {
                ((Logger)object2).setLevel(level);
            }
            Starter.addWarningsAndNotes(warningAndNoteInfo, object, string);
        }
        warningAndNoteInfo.printAllWarningsAndNotesToSystemOut();
        return true;
    }

    private static void addWarningsAndNotes(WarningAndNoteInfo warningAndNoteInfo, Object object, String string) {
        if (object instanceof SharedActivatableServiceDescriptor.Created) {
            SharedActivatableServiceDescriptor.Created created = (SharedActivatableServiceDescriptor.Created)object;
            if (created.proxy instanceof DistcompService) {
                try {
                    DistcompService distcompService = (DistcompService)created.proxy;
                    WarningAndNoteInfo warningAndNoteInfo2 = null;
                    boolean bl = true;
                    boolean bl2 = true;
                    long l = System.currentTimeMillis();
                    while (bl && bl2) {
                        warningAndNoteInfo2 = new WarningAndNoteInfo();
                        NodeInfo nodeInfo = distcompService.getNodeInfo();
                        NodeInfoAnalyzer.addWarningsAndNotes(warningAndNoteInfo2, nodeInfo, true);
                        bl = warningAndNoteInfo2.getAllWarnings() != null;
                        boolean bl3 = bl2 = System.currentTimeMillis() + 2000L - l <= 10000L;
                        if (!bl || !bl2) continue;
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    warningAndNoteInfo.addAll(warningAndNoteInfo2);
                }
                catch (RemoteException remoteException) {
                    warningAndNoteInfo.addWarning(Starter.getMsgFailedToGetNodeInfo(string));
                }
            }
        }
    }

    private static Exception throwableGetException(Throwable throwable, String string) {
        return Starter.undiagnosedProblemStartingGetException(string, throwable);
    }

    private static Exception runtimeGetException(RuntimeException runtimeException, String string) {
        Throwable throwable = runtimeException.getCause();
        if (throwable instanceof AccessControlException && sTxtOriginIsNonLocalHost.equals(throwable.getMessage())) {
            try {
                if (!LocalNetworkInfo.isLocalAddressOnNIC()) {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    String string2 = inetAddress.getHostName();
                    String string3 = inetAddress.getHostAddress();
                    FormattableException formattableException = ERROR_FACTORY.createFormattableException(null, ErrorKey.LOCALHOST_NOT_ON_NIC, string2, string3);
                    return Starter.problemStartingGetException(string, formattableException);
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        return Starter.undiagnosedProblemStartingGetException(string, runtimeException);
    }

    private static Exception activationGetException(ActivationException activationException, String string) {
        Throwable throwable = activationException.getCause();
        if (throwable instanceof InvocationTargetException) {
            return Starter.invocationTargetGetException((InvocationTargetException)throwable, string);
        }
        if (throwable instanceof IOException) {
            return Starter.ioGetException((IOException)throwable, string);
        }
        if (throwable == null && sTxtTimeoutCreating.equals(activationException.getMessage())) {
            return Starter.problemStartingGetException(string, activationException);
        }
        return Starter.undiagnosedProblemStartingGetException(string, activationException);
    }

    private static Exception invocationTargetGetException(InvocationTargetException invocationTargetException, String string) {
        Throwable throwable = invocationTargetException.getCause();
        if (throwable instanceof DistcompException) {
            return Starter.distcompGetException((DistcompException)throwable, string);
        }
        if (throwable instanceof ExportException) {
            return Starter.exportGetException((ExportException)throwable, string);
        }
        if (throwable instanceof IOException) {
            return Starter.ioGetException((IOException)throwable, string);
        }
        if (throwable instanceof ConfigurationException && ServiceType.isLookup(string)) {
            FormattableException formattableException = Starter.problemReadingConfigGetException(throwable, string);
            return Starter.problemStartingGetException(string, formattableException);
        }
        if (throwable instanceof ModuleCreationException) {
            return Starter.problemStartingGetException(string, throwable);
        }
        if (throwable instanceof SharedSecretException) {
            return Starter.problemStartingGetException(string, throwable);
        }
        return Starter.undiagnosedProblemStartingGetException(string, invocationTargetException);
    }

    private static FormattableException problemReadingConfigGetException(Throwable throwable, String string) {
        ErrorKey errorKey;
        switch (ServiceType.getServiceType(string)) {
            case JOBMANAGER: {
                errorKey = ErrorKey.PROBLEM_READING_CONFIGURATION_JM;
                break;
            }
            case LOOKUP: {
                errorKey = ErrorKey.PROBLEM_READING_CONFIGURATION_LOOKUP;
                break;
            }
            case WORKER: {
                errorKey = ErrorKey.PROBLEM_READING_CONFIGURATION_WORKER;
                break;
            }
            default: {
                ErrorKey errorKey2 = ErrorKey.PROBLEM_READING_CONFIGURATION;
                return ERROR_FACTORY.createFormattableException(throwable, errorKey2, string);
            }
        }
        return ERROR_FACTORY.createFormattableException(throwable, errorKey, new Object[0]);
    }

    private static Exception distcompGetException(DistcompException distcompException, String string) {
        Throwable throwable = distcompException.getCause();
        if (throwable instanceof ConfigurationFileServiceStarterException) {
            return Starter.configurationFileGetException((ConfigurationFileServiceStarterException)throwable, string);
        }
        if (throwable instanceof PersistenceDirServiceStarterException) {
            return Starter.persistenceDirGetException((PersistenceDirServiceStarterException)throwable, string);
        }
        if (throwable instanceof StorageInitException) {
            return Starter.databaseGetException((StorageInitException)throwable, string);
        }
        if (throwable instanceof ProxyCreationException) {
            return Starter.proxyCreationGetException((ProxyCreationException)throwable, string);
        }
        if (throwable instanceof LookupDiscoveryException) {
            return Starter.lookupDiscoveryGetException((LookupDiscoveryException)throwable, string);
        }
        if (throwable instanceof NetworkConfigException) {
            return Starter.networkConfigGetException((NetworkConfigException)throwable, string);
        }
        if (throwable instanceof ServiceExportException) {
            return Starter.serviceExportGetException((ServiceExportException)throwable, string);
        }
        if (throwable instanceof ServiceStarterException) {
            return Starter.problemStartingGetException(string, distcompException);
        }
        if (throwable instanceof WorkerLicenseErrorException && ServiceType.isWorker(string)) {
            return Starter.workerLicenseErrorGetException((WorkerLicenseErrorException)throwable);
        }
        if (throwable instanceof MatlabFailedToStartException && ServiceType.isWorker(string)) {
            return Starter.matlabFailedToStartGetException((MatlabFailedToStartException)throwable);
        }
        return Starter.undiagnosedProblemStartingGetException(string, distcompException);
    }

    private static Exception configurationFileGetException(ConfigurationFileServiceStarterException configurationFileServiceStarterException, String string) {
        Throwable throwable = configurationFileServiceStarterException.getCause();
        if (throwable instanceof ConfigurationException) {
            FormattableException formattableException = ERROR_FACTORY.createFormattableException(throwable, ErrorKey.UNABLE_TO_READ_CONFIGURATION, new Object[0]);
            return Starter.problemStartingGetException(string, formattableException);
        }
        if (throwable instanceof IOException) {
            FormattableException formattableException = ERROR_FACTORY.createFormattableException(throwable, ErrorKey.UNABLE_TO_READ_CONFIGURATION, new Object[0]);
            return Starter.undiagnosedProblemStartingGetException(string, formattableException);
        }
        if (throwable instanceof ClassNotFoundException) {
            FormattableException formattableException = ERROR_FACTORY.createFormattableException(configurationFileServiceStarterException, ErrorKey.CLASSPATH_INCORRECT, new Object[0]);
            return Starter.undiagnosedProblemStartingGetException(string, formattableException);
        }
        return Starter.undiagnosedProblemStartingGetException(string, configurationFileServiceStarterException);
    }

    private static Exception persistenceDirGetException(PersistenceDirServiceStarterException persistenceDirServiceStarterException, String string) {
        Throwable throwable = persistenceDirServiceStarterException.getCause();
        if (throwable instanceof PersistenceDirException) {
            String string2 = ((PersistenceDirException)throwable).getPersistenceDir();
            FormattableException formattableException = ERROR_FACTORY.createFormattableException(throwable, ErrorKey.PERSISTENCE_DIR_NOT_ACCESSIBLE, string2);
            return Starter.problemStartingGetException(string, formattableException);
        }
        return Starter.undiagnosedProblemStartingGetException(string, persistenceDirServiceStarterException);
    }

    private static Exception databaseGetException(StorageInitException storageInitException, String string) {
        return Starter.undiagnosedProblemStartingGetException(string, storageInitException);
    }

    private static Exception proxyCreationGetException(ProxyCreationException proxyCreationException, String string) {
        return Starter.undiagnosedProblemStartingGetException(string, proxyCreationException);
    }

    private static Exception lookupDiscoveryGetException(LookupDiscoveryException lookupDiscoveryException, String string) {
        return Starter.undiagnosedProblemStartingGetException(string, lookupDiscoveryException);
    }

    private static Exception networkConfigGetException(NetworkConfigException networkConfigException, String string) {
        Throwable throwable = networkConfigException.getCause();
        if (throwable instanceof UnknownHostException) {
            return Starter.undiagnosedProblemStartingGetException(string, networkConfigException);
        }
        if (throwable instanceof PortUnavailableException) {
            FormattableException formattableException = ERROR_FACTORY.createFormattableException(null, ErrorKey.NO_PORTS_AVAILABLE, new Object[0]);
            return Starter.problemStartingGetException(string, formattableException);
        }
        return Starter.undiagnosedProblemStartingGetException(string, networkConfigException);
    }

    private static Exception serviceExportGetException(ServiceExportException serviceExportException, String string) {
        Throwable throwable = serviceExportException.getCause();
        if (throwable instanceof ExportException) {
            return Starter.exportGetException((ExportException)throwable, string);
        }
        return Starter.undiagnosedProblemStartingGetException(string, serviceExportException);
    }

    private static Exception matlabFailedToStartGetException(MatlabFailedToStartException matlabFailedToStartException) {
        return ERROR_FACTORY.diagnose(matlabFailedToStartException, ErrorKey.FAILED_WITH_TIMEOUT_OR_CRASH, Starter.getMDCEHostName(), matlabFailedToStartException.getMatlabOutputFile(), Starter.getMDCELogFile());
    }

    private static Exception workerLicenseErrorGetException(WorkerLicenseErrorException workerLicenseErrorException) {
        return ERROR_FACTORY.diagnose(workerLicenseErrorException, ErrorKey.FAILED_LICENSING, workerLicenseErrorException.getLicenseErrorMessage());
    }

    private static Exception exportGetException(ExportException exportException, String string) {
        Throwable throwable = exportException.getCause();
        if (throwable instanceof BindException) {
            FormattableException formattableException = ERROR_FACTORY.createFormattableException(exportException, ErrorKey.LIKELY_NO_PORT_AVAILABLE, new Object[0]);
            return Starter.problemStartingGetException(string, formattableException);
        }
        return Starter.undiagnosedProblemStartingGetException(string, exportException);
    }

    private static Exception ioGetException(IOException iOException, String string) {
        if (ServiceType.isWorker(string)) {
            return Starter.exitedUnexpectedlyGetException(string, iOException);
        }
        if (ServiceType.isLookup(string) && iOException instanceof BindException) {
            FormattableException formattableException = ERROR_FACTORY.createFormattableException(null, ErrorKey.LIKELY_NO_PORT_AVAILABLE, new Object[0]);
            return Starter.exitedUnexpectedlyGetException(string, formattableException);
        }
        FormattableException formattableException = ERROR_FACTORY.createFormattableException(iOException, ErrorKey.CHECK_LOG, Starter.getMDCELogFile(), Starter.getMDCEHostName());
        DistcompDiagnosticException distcompDiagnosticException = Starter.exitedUnexpectedlyGetException(string, formattableException);
        return new ControlExceptionFactory.ControlFormattableException(formattableException, distcompDiagnosticException.getResourceKey(), distcompDiagnosticException.getParams());
    }

    public static void main(String[] stringArray) {
        ErrorPrinterImpl errorPrinterImpl = new ErrorPrinterImpl();
        try {
            Starter starter = new Starter();
            WarningAndNoteInfo warningAndNoteInfo = new WarningAndNoteInfo();
            starter.run(warningAndNoteInfo, stringArray);
            warningAndNoteInfo.printAllWarningsToSystemOut();
        }
        catch (Exception exception) {
            errorPrinterImpl.printError(exception);
        }
    }

    private static String getMDCELogFile() {
        String string = System.getProperty("com.mathworks.toolbox.distcomp.logdir", "");
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string + "mdce-service.log";
    }

    private static String getMDCEHostName() {
        return System.getProperty("com.mathworks.toolbox.distcomp.hostname", "");
    }

    private static DistcompDiagnosticException exitedUnexpectedlyGetException(String string, Throwable throwable) {
        ErrorKey errorKey;
        switch (ServiceType.getServiceType(string)) {
            case JOBMANAGER: {
                errorKey = ErrorKey.EXITED_UNEXPECTEDLY_JM;
                break;
            }
            case LOOKUP: {
                errorKey = ErrorKey.EXITED_UNEXPECTEDLY_LOOKUP;
                break;
            }
            case WORKER: {
                errorKey = ErrorKey.EXITED_UNEXPECTEDLY_WORKER;
                break;
            }
            default: {
                ErrorKey errorKey2 = ErrorKey.EXITED_UNEXPECTEDLY;
                return ERROR_FACTORY.diagnoseWithServiceType(throwable, errorKey2, string);
            }
        }
        return ERROR_FACTORY.diagnose(throwable, errorKey, new Object[0]);
    }

    private static DistcompDiagnosticException problemStartingGetException(String string, Throwable throwable) {
        ErrorKey errorKey;
        switch (ServiceType.getServiceType(string)) {
            case JOBMANAGER: {
                errorKey = ErrorKey.PROBLEM_STARTING_JM;
                break;
            }
            case LOOKUP: {
                errorKey = ErrorKey.PROBLEM_STARTING_LOOKUP;
                break;
            }
            case PHOENIX: {
                errorKey = ErrorKey.PROBLEM_STARTING_PHOENIX;
                break;
            }
            case WORKER: {
                errorKey = ErrorKey.PROBLEM_STARTING_WORKER;
                break;
            }
            default: {
                ErrorKey errorKey2 = ErrorKey.PROBLEM_STARTING;
                return ERROR_FACTORY.diagnoseWithServiceType(throwable, errorKey2, string);
            }
        }
        return ERROR_FACTORY.diagnose(throwable, errorKey, new Object[0]);
    }

    private static Exception undiagnosedProblemStartingGetException(String string, Throwable throwable) {
        ErrorKey errorKey;
        switch (ServiceType.getServiceType(string)) {
            case JOBMANAGER: {
                errorKey = ErrorKey.UNDIAGNOSED_PROBLEM_STARTING_JM;
                break;
            }
            case LOOKUP: {
                errorKey = ErrorKey.UNDIAGNOSED_PROBLEM_STARTING_LOOKUP;
                break;
            }
            case PHOENIX: {
                errorKey = ErrorKey.UNDIAGNOSED_PROBLEM_STARTING_PHOENIX;
                break;
            }
            case WORKER: {
                errorKey = ErrorKey.UNDIAGNOSED_PROBLEM_STARTING_WORKER;
                break;
            }
            default: {
                ErrorKey errorKey2 = ErrorKey.UNDIAGNOSED_PROBLEM_STARTING;
                return ERROR_FACTORY.createFormattableException(throwable, errorKey2, string);
            }
        }
        return ERROR_FACTORY.createFormattableException(throwable, errorKey, new Object[0]);
    }

    private static String getMsgFailedToGetNodeInfo(String string) {
        return ServiceType.getStringByServiceType(string, new FailedToGetJobManagerInfoMessage().getLocalizedMessage(), new FailedToGetLookupInfoMessage().getLocalizedMessage(), new FailedToGetWorkerInfoMessage().getLocalizedMessage(), new FailedToGetNodeInfoMessage(string).getLocalizedMessage());
    }

    private static final class FailedToGetNodeInfoMessage
    extends ControlStarterMessage {
        private final BaseMsgID fBaseMsgID;

        FailedToGetNodeInfoMessage(String string) {
            this.fBaseMsgID = new mjs.FailedToGetNodeInfo(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class StarterCleanedCheckpointDataMessage
    extends ControlStarterMessage {
        private final BaseMsgID fBaseMsgID;

        StarterCleanedCheckpointDataMessage(String string) {
            this.fBaseMsgID = new mjs.StarterCleanedCheckpointData(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class PersistenceDirExistsMessage
    extends ControlStarterMessage {
        private final BaseMsgID fBaseMsgID;

        PersistenceDirExistsMessage(String string) {
            this.fBaseMsgID = new mjs.PersistenceDirExists(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class FailedToGetWorkerInfoMessage
    extends ControlStarterMessage {
        private final BaseMsgID fBaseMsgID = new mjs.FailedToGetWorkerInfo();

        FailedToGetWorkerInfoMessage() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class FailedToGetJobManagerInfoMessage
    extends ControlStarterMessage {
        private final BaseMsgID fBaseMsgID = new mjs.FailedToGetJobManagerInfo();

        FailedToGetJobManagerInfoMessage() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class FailedToGetLookupInfoMessage
    extends ControlStarterMessage {
        private final BaseMsgID fBaseMsgID = new mjs.FailedToGetLookupInfo();

        FailedToGetLookupInfoMessage() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static abstract class ControlStarterMessage
    extends ControlMessage {
        ControlStarterMessage() {
        }
    }

    private static enum ErrorKey {
        PROBLEM_STARTING,
        PROBLEM_STARTING_JM,
        PROBLEM_STARTING_LOOKUP,
        PROBLEM_STARTING_WORKER,
        PROBLEM_STARTING_PHOENIX,
        JM_ALREADY_RUNNING,
        LOOKUP_ALREADY_RUNNING,
        WORKER_ALREADY_RUNNING,
        UNKNOWN_SERVICE_TYPE,
        SHOULD_DELETE_SHARED_VM_DIR,
        SHARED_VM_DIR_ALREADY_EXISTS,
        SHARED_VM_DIR_ALREADY_EXISTS_JM,
        SHARED_VM_DIR_ALREADY_EXISTS_LOOKUP,
        SHARED_VM_DIR_ALREADY_EXISTS_WORKER,
        PROBLEM_CREATING_DIR,
        COULD_NOT_CLEAN_CHECKPT_DATA,
        EXITED_UNEXPECTEDLY,
        EXITED_UNEXPECTEDLY_JM,
        EXITED_UNEXPECTEDLY_LOOKUP,
        EXITED_UNEXPECTEDLY_WORKER,
        FAILED_LICENSING,
        FAILED_WITH_TIMEOUT_OR_CRASH,
        LOCALHOST_NOT_ON_NIC,
        PROBLEM_READING_CONFIGURATION,
        PROBLEM_READING_CONFIGURATION_JM,
        PROBLEM_READING_CONFIGURATION_LOOKUP,
        PROBLEM_READING_CONFIGURATION_WORKER,
        UNABLE_TO_READ_CONFIGURATION,
        CLASSPATH_INCORRECT,
        PERSISTENCE_DIR_NOT_ACCESSIBLE,
        NO_PORTS_AVAILABLE,
        LIKELY_NO_PORT_AVAILABLE,
        UNDIAGNOSED_PROBLEM_STARTING,
        UNDIAGNOSED_PROBLEM_STARTING_JM,
        UNDIAGNOSED_PROBLEM_STARTING_LOOKUP,
        UNDIAGNOSED_PROBLEM_STARTING_WORKER,
        UNDIAGNOSED_PROBLEM_STARTING_PHOENIX,
        CHECK_LOG;

    }
}

