/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsMDCSOperation;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsRemoteExecutionException;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceControlError;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceControlException;

public abstract class RemoteMDCEOperationException
extends WindowsRemoteExecutionException {
    private final WindowsServiceControlError fError;
    private final String fCommandOutput;
    private final boolean fDoesCommandContainsOutput;

    RemoteMDCEOperationException(String string, WindowsMDCSOperation windowsMDCSOperation, WindowsServiceControlException windowsServiceControlException) {
        super(string, windowsMDCSOperation, windowsServiceControlException);
        this.fError = windowsServiceControlException.getError();
        this.fCommandOutput = windowsServiceControlException.getCommandOutput();
        this.fDoesCommandContainsOutput = true;
    }

    RemoteMDCEOperationException(String string, WindowsMDCSOperation windowsMDCSOperation, WindowsServiceControlError windowsServiceControlError) {
        super(string, windowsMDCSOperation);
        this.fError = windowsServiceControlError;
        this.fCommandOutput = null;
        this.fDoesCommandContainsOutput = false;
    }

    protected WindowsServiceControlError getError() {
        return this.fError;
    }

    protected String getCommandOutput() {
        return this.fCommandOutput;
    }

    protected boolean getOutputStatus() {
        return this.fDoesCommandContainsOutput;
    }

    protected BaseMsgID getErrorBasedBaseMsgID() {
        switch (this.fError) {
            case FAILED_TO_CONTACT_SERVER: {
                return this.runFailedToContactServer();
            }
            case SERVICE_ALREADY_INSTALLED: {
                return this.runServiceAlreadyInstalled();
            }
            case SERVICE_NOT_INSTALLED: {
                return this.runServiceNotInstalled();
            }
            case PERMISSION_DENIED: 
            case UNKNOWN_USER_OR_BAD_PASSWORD: {
                return this.runPermissionDeniedOrBadPassword();
            }
            case SERVICE_ALREADY_RUNNING: {
                return this.runServiceAlreadyRunning();
            }
        }
        return this.runDefault();
    }

    private BaseMsgID runFailedToContactServer() {
        if (this.fDoesCommandContainsOutput) {
            return new remote.FailedToContactMDCEServerScOutput(this.getMDCSOperation(), this.getRemoteHostName(), this.fCommandOutput);
        }
        return new remote.FailedToContactMDCEServerScNoOutput(this.getMDCSOperation(), this.getRemoteHostName());
    }

    private BaseMsgID runServiceAlreadyInstalled() {
        if (this.fDoesCommandContainsOutput) {
            return new remote.RemoteMDCSServiceAlreadyInstalledScOutput(this.getMDCSOperation(), this.getRemoteHostName(), this.fCommandOutput);
        }
        return new remote.RemoteMDCSServiceAlreadyInstalledScNoOutput(this.getMDCSOperation(), this.getRemoteHostName());
    }

    private BaseMsgID runServiceNotInstalled() {
        if (this.fDoesCommandContainsOutput) {
            return new remote.RemoteMDCSServiceNotInstalledScOutput(this.getMDCSOperation(), this.getRemoteHostName(), this.fCommandOutput);
        }
        return new remote.RemoteMDCSServiceNotInstalledScNoOutput(this.getMDCSOperation(), this.getRemoteHostName());
    }

    private BaseMsgID runPermissionDeniedOrBadPassword() {
        if (this.fDoesCommandContainsOutput) {
            return new remote.PermissionDeniedOnRemoteHostScOutput(this.getMDCSOperation(), this.getRemoteHostName(), this.fCommandOutput);
        }
        return new remote.PermissionDeniedOnRemoteHostScNoOutput(this.getMDCSOperation(), this.getRemoteHostName());
    }

    private BaseMsgID runServiceAlreadyRunning() {
        if (this.fDoesCommandContainsOutput) {
            return new remote.RemoteMDCEServiceAlreadyRunningScOutput(this.getMDCSOperation(), this.getRemoteHostName(), this.fCommandOutput);
        }
        return new remote.RemoteMDCEServiceAlreadyRunningScNoOutput(this.getMDCSOperation(), this.getRemoteHostName());
    }

    private BaseMsgID runDefault() {
        if (this.fDoesCommandContainsOutput) {
            return new remote.UnknownMDCSErrorScOutput(this.getMDCSOperation(), this.getRemoteHostName(), this.fCommandOutput);
        }
        return new remote.UnknownMDCSErrorScNoOutput(this.getMDCSOperation(), this.getRemoteHostName());
    }
}

