/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceControlError;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceControlException;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceControlOperation;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceControlProblemDiagnosedException;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.WindowsServiceState;
import com.mathworks.toolbox.distcomp.remote.util.StreamRedirector;
import com.mathworks.util.PlatformInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public final class WindowsServiceControl {
    private static final int WAIT_FOR_STATE_SLEEP_TIME_MILLIS = 500;
    private static final String SC_EXE = "sc.exe";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.resources.RES_errors");
    private final String fServer;

    public WindowsServiceControl(String string) {
        assert (PlatformInfo.isWindows()) : "WindowsServiceControl can only be used on Windows";
        this.fServer = string.equals("localhost") ? "" : "\\\\" + string;
    }

    public WindowsServiceControl() {
        assert (PlatformInfo.isWindows()) : "WindowsServiceControl can only be used on Windows";
        this.fServer = "";
    }

    public WindowsServiceState query(String string) throws WindowsServiceControlException {
        String string2;
        try {
            string2 = this.runServiceControlCommand(WindowsServiceControlOperation.QUERY, string);
        }
        catch (IOException iOException) {
            throw new CouldNotQueryServiceStateException(string, iOException);
        }
        WindowsServiceState windowsServiceState = WindowsServiceState.fromScQueryOutput(string2);
        if (windowsServiceState == WindowsServiceState.UNKNOWN) {
            Log.LOGGER.severe("'sc.exe query' command output: " + string2);
            throw WindowsServiceControl.diagnoseFailedServiceQuery(string2);
        }
        return windowsServiceState;
    }

    public void install(String string, String string2) throws WindowsServiceControlException {
        String string3;
        if (string2 == null) {
            throw new NullPointerException("binPath must not be null.");
        }
        if (string2.isEmpty()) {
            throw new IllegalArgumentException("binPath must not be empty.");
        }
        try {
            string3 = this.runServiceControlCommand(WindowsServiceControlOperation.INSTALL, string, "binPath=", string2);
        }
        catch (IOException iOException) {
            throw new CouldNotCreateWindowsServiceException(string, string2, iOException);
        }
        if (ScStrings.FAILED.containedBy(string3)) {
            Log.LOGGER.severe("'sc.exe create' command output: " + string3);
            throw WindowsServiceControl.disgnoseFailedServiceCreation(string3);
        }
    }

    public void start(String string) throws WindowsServiceControlException {
        WindowsServiceState windowsServiceState;
        String string2;
        try {
            string2 = this.runServiceControlCommand(WindowsServiceControlOperation.START, string);
        }
        catch (IOException iOException) {
            throw new FailedToStartServiceIOException(string, iOException);
        }
        if (ScStrings.FAILED.containedBy(string2)) {
            Log.LOGGER.severe("'sc.exe start' command output: " + string2);
            throw WindowsServiceControl.diagnoseFailedServiceStart(string2);
        }
        try {
            windowsServiceState = this.waitForNotState(string, WindowsServiceState.START_PENDING);
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedStartOfServiceException(string, interruptedException);
        }
        if (windowsServiceState != WindowsServiceState.RUNNING) {
            throw new ServiceNotRunningException(string);
        }
    }

    public void stop(String string) throws WindowsServiceControlException {
        WindowsServiceState windowsServiceState;
        String string2;
        try {
            string2 = this.runServiceControlCommand(WindowsServiceControlOperation.STOP, string);
        }
        catch (IOException iOException) {
            throw new FailedToStopServiceIOException(string, iOException);
        }
        if (ScStrings.FAILED.containedBy(string2)) {
            Log.LOGGER.severe("'sc.exe stop' command output: " + string2);
            throw WindowsServiceControl.diagnoseFailedServiceStop(string2);
        }
        try {
            windowsServiceState = this.waitForNotState(string, WindowsServiceState.STOP_PENDING);
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedStopOfServiceException(string, interruptedException);
        }
        if (windowsServiceState != WindowsServiceState.STOPPED) {
            throw new FailedToStopServiceException(string);
        }
    }

    public void uninstall(String string) throws WindowsServiceControlException {
        String string2;
        try {
            string2 = this.runServiceControlCommand(WindowsServiceControlOperation.UNINSTALL, string);
        }
        catch (IOException iOException) {
            throw new WindowsServiceUninstallFailedIOException(string, iOException);
        }
        if (ScStrings.FAILED.containedBy(string2)) {
            Log.LOGGER.severe("'sc.exe delete' command output: " + string2);
            throw WindowsServiceControl.diagnoseFailedServiceDeletion(string2);
        }
    }

    private String runServiceControlCommand(WindowsServiceControlOperation windowsServiceControlOperation, String ... stringArray) throws IOException {
        List<String> list = this.createServiceControlCommand(windowsServiceControlOperation, stringArray);
        Log.LOGGER.finest("About to start " + list);
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        processBuilder.redirectErrorStream(true);
        return WindowsServiceControl.runAndCaptureOutput(processBuilder);
    }

    private static String runAndCaptureOutput(ProcessBuilder processBuilder) throws IOException {
        Process process = processBuilder.start();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamRedirector streamRedirector = StreamRedirector.getInstance();
        InputStream inputStream = process.getInputStream();
        StreamRedirector.RedirectionPair redirectionPair = streamRedirector.addRedirect(inputStream, byteArrayOutputStream);
        while (true) {
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        streamRedirector.removeRedirect(redirectionPair);
        return byteArrayOutputStream.toString(Charset.defaultCharset().toString());
    }

    private List<String> createServiceControlCommand(WindowsServiceControlOperation windowsServiceControlOperation, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(SC_EXE, this.fServer));
        arrayList.add(windowsServiceControlOperation.getScCommandString());
        arrayList.addAll(Arrays.asList(stringArray));
        return arrayList;
    }

    public WindowsServiceState waitForState(String string, WindowsServiceState windowsServiceState, long l) throws WindowsServiceControlException, InterruptedException {
        long l2 = System.currentTimeMillis() + l;
        WindowsServiceState windowsServiceState2 = this.query(string);
        while (windowsServiceState2 != windowsServiceState && System.currentTimeMillis() < l2) {
            Thread.sleep(500L);
            windowsServiceState2 = this.query(string);
        }
        return windowsServiceState2;
    }

    private WindowsServiceState waitForNotState(String string, WindowsServiceState windowsServiceState) throws WindowsServiceControlException, InterruptedException {
        WindowsServiceState windowsServiceState2 = this.query(string);
        while (windowsServiceState2 == windowsServiceState) {
            Thread.sleep(500L);
            windowsServiceState2 = this.query(string);
        }
        return windowsServiceState2;
    }

    private static WindowsServiceControlException diagnoseFailedServiceQuery(String string) {
        WindowsServiceControlException windowsServiceControlException = WindowsServiceControl.diagnoseCommonFailures(string);
        if (windowsServiceControlException == null) {
            windowsServiceControlException = new WindowsServiceControlProblemDiagnosedException(WindowsServiceControlError.UNKNOWN, string);
        }
        return windowsServiceControlException;
    }

    private static WindowsServiceControlException disgnoseFailedServiceCreation(String string) {
        WindowsServiceControlException windowsServiceControlException = WindowsServiceControl.diagnoseCommonFailures(string);
        if (windowsServiceControlException == null) {
            windowsServiceControlException = ScStrings.FAILED_1073_SERVICE_ALREADY_INSTALLED.containedBy(string) ? new WindowsServiceControlProblemDiagnosedException(WindowsServiceControlError.SERVICE_ALREADY_INSTALLED, string) : new WindowsServiceControlProblemDiagnosedException(WindowsServiceControlError.UNKNOWN, string);
        }
        return windowsServiceControlException;
    }

    private static WindowsServiceControlException diagnoseFailedServiceStart(String string) {
        WindowsServiceControlException windowsServiceControlException = WindowsServiceControl.diagnoseCommonFailures(string);
        if (windowsServiceControlException == null) {
            windowsServiceControlException = ScStrings.FAILED_3_INVALID_BINPATH.containedBy(string) ? new WindowsServiceControlProblemDiagnosedException(WindowsServiceControlError.INVALID_BINPATH, string) : (ScStrings.FAILED_1060_SERVICE_NOT_INSTALLED.containedBy(string) ? new WindowsServiceControlProblemDiagnosedException(WindowsServiceControlError.SERVICE_NOT_INSTALLED, string) : (ScStrings.FAILED_2_CANNOT_FIND_FILE.containedBy(string) ? new WindowsServiceControlProblemDiagnosedException(WindowsServiceControlError.CANNOT_FIND_FILE, string) : (ScStrings.FAILED_1326_UNKNOWN_USER.containedBy(string) ? new WindowsServiceControlProblemDiagnosedException(WindowsServiceControlError.UNKNOWN_USER_OR_BAD_PASSWORD, string) : (ScStrings.FAILED_1053_DID_NOT_RESPOND_IN_TIMELY_FASHION.containedBy(string) ? new WindowsServiceControlProblemDiagnosedException(WindowsServiceControlError.DID_NOT_RESPOND_IN_TIMELY_FASHION, string) : new WindowsServiceControlProblemDiagnosedException(WindowsServiceControlError.UNKNOWN, string)))));
        }
        return windowsServiceControlException;
    }

    private static WindowsServiceControlException diagnoseFailedServiceStop(String string) {
        WindowsServiceControlException windowsServiceControlException = WindowsServiceControl.diagnoseCommonFailures(string);
        if (windowsServiceControlException == null) {
            windowsServiceControlException = ScStrings.FAILED_1060_SERVICE_NOT_INSTALLED.containedBy(string) ? new WindowsServiceControlProblemDiagnosedException(WindowsServiceControlError.SERVICE_NOT_INSTALLED, string) : new WindowsServiceControlProblemDiagnosedException(WindowsServiceControlError.UNKNOWN, string);
        }
        return windowsServiceControlException;
    }

    private static WindowsServiceControlException diagnoseFailedServiceDeletion(String string) {
        WindowsServiceControlException windowsServiceControlException = WindowsServiceControl.diagnoseCommonFailures(string);
        if (windowsServiceControlException == null) {
            windowsServiceControlException = ScStrings.FAILED_1060_SERVICE_NOT_INSTALLED.containedBy(string) ? new WindowsServiceControlProblemDiagnosedException(WindowsServiceControlError.SERVICE_NOT_INSTALLED, string) : new WindowsServiceControlProblemDiagnosedException(WindowsServiceControlError.UNKNOWN, string);
        }
        return windowsServiceControlException;
    }

    private static WindowsServiceControlException diagnoseCommonFailures(String string) {
        if (ScStrings.FAILED_1722_CANNOT_CONTACT_SERVER.containedBy(string)) {
            WindowsServiceControlError windowsServiceControlError = WindowsServiceControlError.FAILED_TO_CONTACT_SERVER;
            return new WindowsServiceControlProblemDiagnosedException(windowsServiceControlError, string);
        }
        if (ScStrings.FAILED_5_ACCESS_DENIED.containedBy(string)) {
            WindowsServiceControlError windowsServiceControlError = WindowsServiceControlError.PERMISSION_DENIED;
            return new WindowsServiceControlProblemDiagnosedException(windowsServiceControlError, string);
        }
        if (ScStrings.FAILED_1727_RPC_CALL_FAILED.containedBy(string)) {
            WindowsServiceControlError windowsServiceControlError = WindowsServiceControlError.RPC_CALL_FAILED;
            return new WindowsServiceControlProblemDiagnosedException(windowsServiceControlError, string);
        }
        if (ScStrings.FAILED_1072_MARKED_FOR_DELETION.containedBy(string)) {
            WindowsServiceControlError windowsServiceControlError = WindowsServiceControlError.MARKED_FOR_DELETION;
            return new WindowsServiceControlProblemDiagnosedException(windowsServiceControlError, string);
        }
        return null;
    }

    static /* synthetic */ ResourceBundle access$000() {
        return RESOURCE_BUNDLE;
    }

    private static final class WindowsServiceUninstallFailedIOException
    extends WindowsServiceControlException {
        private final BaseMsgID fBaseMsgID;

        WindowsServiceUninstallFailedIOException(String string, IOException iOException) {
            super(iOException);
            this.fBaseMsgID = new remote.WindowsServiceUninstallFailedIO(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class FailedToStopServiceException
    extends WindowsServiceControlException {
        private final BaseMsgID fBaseMsgID;

        FailedToStopServiceException(String string) {
            this.fBaseMsgID = new remote.FailedToStopService(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class InterruptedStopOfServiceException
    extends WindowsServiceControlException {
        private final BaseMsgID fBaseMsgID;

        InterruptedStopOfServiceException(String string, InterruptedException interruptedException) {
            super(interruptedException);
            this.fBaseMsgID = new remote.InterruptedStopOfService(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class FailedToStopServiceIOException
    extends WindowsServiceControlException {
        private final BaseMsgID fBaseMsgID;

        FailedToStopServiceIOException(String string, IOException iOException) {
            super(iOException);
            this.fBaseMsgID = new remote.FailedToStopServiceIO(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class InterruptedStartOfServiceException
    extends WindowsServiceControlException {
        private final BaseMsgID fBaseMsgID;

        InterruptedStartOfServiceException(String string, InterruptedException interruptedException) {
            super(interruptedException);
            this.fBaseMsgID = new remote.InterruptedStartOfService(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class ServiceNotRunningException
    extends WindowsServiceControlException {
        private final BaseMsgID fBaseMsgID;

        ServiceNotRunningException(String string) {
            this.fBaseMsgID = new remote.ServiceNotRunning(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class FailedToStartServiceIOException
    extends WindowsServiceControlException {
        private final BaseMsgID fBaseMsgID;

        FailedToStartServiceIOException(String string, IOException iOException) {
            super(iOException);
            this.fBaseMsgID = new remote.FailedToStartServiceIO(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class CouldNotCreateWindowsServiceException
    extends WindowsServiceControlException {
        private final BaseMsgID fBaseMsgID;

        CouldNotCreateWindowsServiceException(String string, String string2, IOException iOException) {
            super(iOException);
            this.fBaseMsgID = new remote.CouldNotCreateWindowsService(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class CouldNotQueryServiceStateException
    extends WindowsServiceControlException {
        private final BaseMsgID fBaseMsgID;

        CouldNotQueryServiceStateException(String string, IOException iOException) {
            super(iOException);
            this.fBaseMsgID = new remote.CouldNotQueryServiceState(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static enum ScStrings {
        FAILED,
        FAILED_2_CANNOT_FIND_FILE,
        FAILED_3_INVALID_BINPATH,
        FAILED_5_ACCESS_DENIED,
        FAILED_1053_DID_NOT_RESPOND_IN_TIMELY_FASHION,
        FAILED_1060_SERVICE_NOT_INSTALLED,
        FAILED_1072_MARKED_FOR_DELETION,
        FAILED_1326_UNKNOWN_USER,
        FAILED_1073_SERVICE_ALREADY_INSTALLED,
        FAILED_1722_CANNOT_CONTACT_SERVER,
        FAILED_1727_RPC_CALL_FAILED;

        private final String fString = WindowsServiceControl.access$000().getString("scString." + this.name());

        boolean containedBy(String string) {
            return string.contains(this.fString);
        }
    }
}

