/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.serviceinfo;

import com.mathworks.toolbox.distcomp.control.ServiceType;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerServiceInfo;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.util.ConfigUtil;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class CheckpointDirInfo {
    public static List<ServiceInfo> getStoppedServicesList(String string) {
        assert (string != null) : "The hostname must not be null";
        Vector<CheckpointDir> vector = new Vector<CheckpointDir>();
        for (Comparable<File> comparable : CheckpointDirInfo.getServiceFiles()) {
            try {
                vector.add(new CheckpointDir(comparable.getPath()));
            }
            catch (InvalidCheckpointDirException invalidCheckpointDirException) {
                // empty catch block
            }
        }
        Vector vector2 = new Vector();
        for (CheckpointDir checkpointDir : vector) {
            Comparable<File> comparable;
            comparable = checkpointDir.createServiceInfo(string);
            if (vector2.contains(comparable)) {
                vector2.remove(comparable);
                continue;
            }
            vector2.add(comparable);
        }
        Collections.sort(vector2);
        return vector2;
    }

    public static int getFirstAvailableNumber(String string) {
        int n;
        int n2;
        SortedSet<Integer> sortedSet = CheckpointDirInfo.getNumbersOfNamesContaining(string);
        Iterator iterator = sortedSet.iterator();
        for (n2 = 1; iterator.hasNext() && n2 == (n = ((Integer)iterator.next()).intValue()); ++n2) {
        }
        return n2;
    }

    public static int getLastAssignedNumber(String string) {
        SortedSet<Integer> sortedSet = CheckpointDirInfo.getNumbersOfNamesContaining(string);
        return sortedSet.size() == 0 ? 0 : sortedSet.last();
    }

    private static SortedSet<Integer> getNumbersOfNamesContaining(String string) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (File file : CheckpointDirInfo.getServiceFiles()) {
            String string2 = file.getName();
            if (string2.indexOf(string) < 0) continue;
            treeSet.add(CheckpointDirInfo.extractServiceNumber(string, string2));
        }
        return treeSet;
    }

    private static int extractServiceNumber(String string, String string2) {
        try {
            int n = string2.indexOf(string) + string.length();
            int n2 = string2.indexOf("_", n);
            return Integer.parseInt(string2.substring(n, n2));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static File[] getServiceFiles() {
        File file = new File(System.getProperty("com.mathworks.toolbox.distcomp.checkpointdir"));
        return file.listFiles();
    }

    private static class InvalidCheckpointDirException
    extends Exception {
        InvalidCheckpointDirException(String string) {
            super(string);
        }
    }

    private static class CheckpointDir {
        private static ServiceType[] serviceTypesToCheck = ServiceType.values();
        private String iMDCSHostname;
        private String iServiceName;
        private ServiceType iServiceType;

        CheckpointDir(String string) throws InvalidCheckpointDirException {
            File file = new File(string);
            if (!file.isDirectory()) {
                throw new InvalidCheckpointDirException("Path '" + string + " is no directory.");
            }
            String string2 = file.getName();
            String[] stringArray = string2.split("_", 2);
            if (stringArray.length != 2) {
                throw new InvalidCheckpointDirException("Cannot split hostname from dir '" + string2 + "'");
            }
            this.iMDCSHostname = stringArray[0];
            for (ServiceType serviceType : serviceTypesToCheck) {
                String string3 = ConfigUtil.getServicePostfix(serviceType.toString());
                int n = stringArray[1].lastIndexOf(string3);
                if (n >= 0) {
                    this.iServiceName = stringArray[1].substring(0, n);
                    this.iServiceType = serviceType;
                    break;
                }
                String string4 = ConfigUtil.getServiceSharedVMPostfix(serviceType.toString());
                int n2 = stringArray[1].lastIndexOf(string4);
                if (n2 < 0) continue;
                this.iServiceName = stringArray[1].substring(0, n2);
                this.iServiceType = serviceType;
                break;
            }
            if (this.iServiceType == null) {
                throw new InvalidCheckpointDirException("Dir '" + string2 + "' does not belong to a service of " + "checked types.");
            }
        }

        public ServiceInfo createServiceInfo(String string) {
            Host host = new Host(string, this.iMDCSHostname);
            if (this.iServiceType == ServiceType.JOBMANAGER) {
                return new JobManagerServiceInfo(this.iServiceName, host);
            }
            if (this.iServiceType == ServiceType.WORKER) {
                return new WorkerServiceInfo(this.iServiceName, host);
            }
            if (this.iServiceType == ServiceType.PHOENIX) {
                return MDCSServiceInfo.createStoppedInfo(host);
            }
            return null;
        }
    }
}

