/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.jobmanager.JobManagerClientOutputGroupFactory;
import com.mathworks.toolbox.distcomp.jobmanager.NonFatalErrorHandler;
import com.mathworks.toolbox.distcomp.jobmanager.PackageInfo;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.ExportedObjectRegistry;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.ObjectRegistry;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.PeerRmiDispatcher;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.PeerRmiExporterFactory;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.PeerRmiRuntime;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerConnector;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerDispatcher;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSession;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.Collections;
import java.util.HashSet;

public final class JobManagerProxyPeerSession {
    private final PeerInstance fPeerInstance;
    private final ServerSocketConnectInfo fConnectInfo;
    private final PeerRmiRuntime fPeerRmiRuntime;
    private PeerSession fPeerSession;
    private NonFatalErrorHandler fErrorHandler;

    public JobManagerProxyPeerSession(PeerInstance peerInstance, ServerSocketConnectInfo serverSocketConnectInfo) {
        this.fPeerInstance = peerInstance;
        this.fConnectInfo = serverSocketConnectInfo;
        this.fPeerRmiRuntime = new PeerRmiRuntimeImpl();
    }

    public synchronized void connectToServer() throws PeerMessagingException {
        assert (this.fPeerSession == null) : "Should not call connectToServer more than once";
        HashSet<PeerDispatcher<? extends Message>> hashSet = new HashSet<PeerDispatcher<? extends Message>>();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Adding PeerRmiDispatcher to PeerSession's dispatchers");
        hashSet.add(this.fPeerRmiRuntime.getPeerRmiDispatcher());
        PeerConnector peerConnector = new PeerConnector();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Actively connecting to " + this.fConnectInfo);
        Connection connection = peerConnector.activelyConnectTo(this.fConnectInfo, this.fPeerInstance);
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Creating new PeerSession connected to " + connection);
        this.fErrorHandler = new NonFatalErrorHandler();
        this.fPeerSession = new PeerSession(this.fConnectInfo, this.fPeerInstance, this.fErrorHandler, hashSet, Collections.singleton(connection));
    }

    private boolean isSessionSecure() {
        return this.fConnectInfo.getConnectorSecurityDescription().isSecure();
    }

    public synchronized boolean isConnected() {
        return this.fPeerSession != null;
    }

    public synchronized Throwable hasErrored() {
        if (this.fPeerSession == null) {
            return null;
        }
        assert (this.fErrorHandler != null) : "If the peer session exists the error handler cannot be null.";
        return this.fErrorHandler.hasErrored();
    }

    public synchronized void shutdown() {
        if (this.fPeerSession != null) {
            this.fPeerSession.normalShutdown();
        }
        this.fPeerSession = null;
        this.fErrorHandler = null;
    }

    public ExporterFactory createPeerRmiExporterFactory() {
        return new PeerRmiExporterFactory(this.fPeerRmiRuntime, this.fPeerInstance, new JobManagerClientOutputGroupFactory());
    }

    private class PeerRmiRuntimeImpl
    implements PeerRmiRuntime {
        private final ObjectRegistry fPeerRmiObjectRegistry = new ExportedObjectRegistry();
        private final PeerRmiDispatcher fPeerRmiDispatcher = new PeerRmiDispatcher(this.fPeerRmiObjectRegistry);

        PeerRmiRuntimeImpl() {
        }

        @Override
        public boolean isSecure() {
            return JobManagerProxyPeerSession.this.isSessionSecure();
        }

        @Override
        public ObjectRegistry getObjectRegistry() {
            return this.fPeerRmiObjectRegistry;
        }

        @Override
        public PeerRmiDispatcher getPeerRmiDispatcher() {
            return this.fPeerRmiDispatcher;
        }

        @Override
        public void startRuntime() throws PeerRmiRuntime.FailedToStartException {
            if (JobManagerProxyPeerSession.this.isConnected()) {
                return;
            }
            try {
                JobManagerProxyPeerSession.this.connectToServer();
            }
            catch (PeerMessagingException peerMessagingException) {
                throw new PeerRmiRuntime.FailedToStartException(peerMessagingException);
            }
        }
    }
}

