/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import com.mathworks.toolbox.distcomp.local.AbstractConcurrentJobCommand;
import com.mathworks.toolbox.distcomp.local.PackageInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ParallelJobCommand
extends AbstractConcurrentJobCommand {
    public static ParallelJobCommand getNewInstance(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, int[] nArray) throws IOException {
        if (nArray == null || nArray.length != 2) {
            throw new IllegalStateException("Invalid number of workers argument supplied");
        }
        return (ParallelJobCommand)ParallelJobCommand.addCommandToScheduler(new ParallelJobCommand(stringArray, stringArray2, stringArray3, string, nArray[0], nArray[1]));
    }

    private ParallelJobCommand(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, int n, int n2) throws IOException {
        super(stringArray, stringArray2, stringArray3, string, n, n2);
    }

    @Override
    protected void waitUntilJobShouldTerminate(Vector<Future<Integer>> vector) throws InterruptedException {
        do {
            boolean bl = false;
            try {
                for (Future<Integer> future : vector) {
                    bl = bl || future.isDone();
                }
                long l = bl ? 60L : 5L;
                for (Future<Integer> future : vector) {
                    int n = future.get(l, TimeUnit.SECONDS);
                    if (n == 0) continue;
                    return;
                }
                return;
            }
            catch (TimeoutException timeoutException) {
                if (!bl) continue;
                return;
            }
            catch (ExecutionException executionException) {
                return;
            }
            catch (CancellationException cancellationException) {
                return;
            }
            catch (InterruptedException interruptedException) {
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "ParallelJobCommand - wait got InterruptedException: ", interruptedException);
                throw interruptedException;
            }
        } while (!this.isCancelled() && !this.isDestroyed());
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "ParallelJobCommand - cancelled (" + this.isCancelled() + ") or destroyed (" + this.isDestroyed() + ")");
    }
}

