/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import com.mathworks.jmi.Matlab;
import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.job;
import com.mathworks.toolbox.distcomp.local.MpiexecException;
import com.mathworks.toolbox.distcomp.local.PackageInfo;
import com.mathworks.toolbox.distcomp.remote.util.StreamRedirector;
import com.mathworks.toolbox.distcomp.util.Pair;
import com.mathworks.toolbox.distcomp.util.ProcessBuilderUtils;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.io.NullOutputStream;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public final class SmpdDaemonManager {
    private static final String[] ZERO_LENGTH_STRING = new String[0];
    private static SmpdDaemonManager sSmpdManager = null;
    private Process fSmpdProcess = null;
    private int fSmpdPort;
    private File fSmpdFile;
    private StreamRedirector fRedirector;
    private StreamRedirector.RedirectionPair fInToken;
    private StreamRedirector.RedirectionPair fErrToken;
    private boolean fGotLaunchInformation = false;
    private String[] fCmdAndArgs;
    private String[] fEnvNames;
    private String[] fEnvValues;
    private int fUseCount = 0;

    public static synchronized SmpdDaemonManager getManager() {
        if (sSmpdManager == null) {
            sSmpdManager = new SmpdDaemonManager();
            Matlab.registerQuitListener((Runnable)new Runnable(){

                @Override
                public void run() {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SmpdDaemonManager quit listener about to stopSmpd().");
                    sSmpdManager.stopSmpd();
                }
            });
        }
        return sSmpdManager;
    }

    private SmpdDaemonManager() {
    }

    public synchronized int getPortAndIncrementUsage() throws MpiexecException {
        assert (this.fGotLaunchInformation);
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "SmpdDaemonManager.getPortAndIncrementUsage() entry");
        this.ensureSmpdProcess();
        ++this.fUseCount;
        return this.fSmpdPort;
    }

    public synchronized void releaseUsage() {
        --this.fUseCount;
        if (this.fUseCount < 0) {
            this.fUseCount = 0;
            assert (false);
        }
    }

    public synchronized boolean isDaemonInUse() {
        return this.fUseCount > 0;
    }

    public synchronized boolean supplyLaunchInformation(String[] stringArray, String[] stringArray2, String[] stringArray3, String string) throws MpiexecException, IllegalArgumentException {
        if (stringArray2 != null && stringArray3 != null) {
            if (stringArray2.length != stringArray3.length) {
                throw new IllegalArgumentException("Number of names must be the same as the number of values");
            }
            this.fEnvNames = Arrays.copyOf(stringArray2, stringArray2.length);
            this.fEnvValues = Arrays.copyOf(stringArray3, stringArray3.length);
        } else {
            if (stringArray2 != null || stringArray3 != null) {
                throw new IllegalArgumentException("Number of names must be the same as the number of values");
            }
            this.fEnvNames = ZERO_LENGTH_STRING;
            this.fEnvValues = ZERO_LENGTH_STRING;
        }
        this.fCmdAndArgs = Arrays.copyOf(stringArray, stringArray.length);
        this.fSmpdFile = new File(string);
        this.fGotLaunchInformation = true;
        this.ensureSmpdProcess();
        return true;
    }

    public synchronized void stopSmpd() {
        if (this.smpdProcessIsAlive()) {
            try {
                boolean bl = this.fSmpdFile.delete();
                if (!bl) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to delete the SMPD file: " + this.fSmpdFile);
                }
                this.fRedirector.removeRedirect(this.fInToken);
                this.fRedirector.removeRedirect(this.fErrToken);
            }
            catch (RuntimeException runtimeException) {
                PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Failure stopping SMPD process.", runtimeException);
            }
            this.fSmpdProcess.destroy();
        }
    }

    private synchronized void ensureSmpdProcess() throws MpiexecException {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "SmpdDaemonManager.ensureSmpdProcess() entry");
        if (!this.smpdProcessIsAlive()) {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "SmpdDaemonManager.ensureSmpdProcess() needs to build daemon");
            try {
                this.fSmpdPort = this.buildSmpdProcess();
            }
            catch (RuntimeException runtimeException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failure during buildSmpdProcess.", runtimeException);
                throw new MpiexecException((BaseMsgID)new job.SmpdLaunchFailed(), (Throwable)runtimeException);
            }
        }
    }

    private synchronized boolean smpdProcessIsAlive() {
        if (this.fSmpdProcess == null) {
            return false;
        }
        try {
            this.fSmpdProcess.exitValue();
            this.fSmpdProcess = null;
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    private synchronized void setSmpdProcessAndRedirect(Process process) {
        this.fSmpdProcess = process;
        NullOutputStream nullOutputStream = new NullOutputStream();
        this.fRedirector = StreamRedirector.getInstance();
        this.fInToken = this.fRedirector.addRedirect(process.getInputStream(), (OutputStream)nullOutputStream);
        this.fErrToken = this.fRedirector.addRedirect(process.getErrorStream(), (OutputStream)nullOutputStream);
    }

    private synchronized int buildSmpdProcess() throws MpiexecException {
        final ProcessBuilder processBuilder = new ProcessBuilder(this.fCmdAndArgs);
        Map<String, String> map = processBuilder.environment();
        for (int i = 0; i < this.fEnvNames.length; ++i) {
            if (this.fEnvNames[i] == null || this.fEnvValues[i] == null) {
                throw new IllegalArgumentException("Names and values must be non-null");
            }
            map.put(this.fEnvNames[i], this.fEnvValues[i]);
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " temporaryExecutor-"), (Logger)PackageInfo.LOGGER));
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "SmpdDaemonManager.buildSmpdProcess() about to submit Callable");
        Future<Pair<Integer, Process>> future = executorService.submit(new Callable<Pair<Integer, Process>>(){

            @Override
            public Pair<Integer, Process> call() throws IOException, InterruptedException {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "SmpdDaemonManager.buildSmpdProcess() about to build process");
                Process process = ProcessBuilderUtils.createProcessFromBuilderWithRetry(processBuilder, ProcessBuilderUtils.nullDelayer(), 5, 500);
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "SmpdDaemonManager.buildSmpdProcess() built process: " + process);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("US-ASCII")));
                String string = bufferedReader.readLine();
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "SmpdDaemonManager.buildSmpdProcess() read: " + string);
                int n = Integer.parseInt(string);
                return new Pair<Integer, Process>(n, process);
            }
        });
        try {
            Pair<Integer, Process> pair = future.get(120L, TimeUnit.SECONDS);
            this.setSmpdProcessAndRedirect(pair.getSecond());
            int n = pair.getFirst();
            return n;
        }
        catch (TimeoutException timeoutException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "SmpdDaemonManager.buildSmpdProcess() hit timeout.", timeoutException);
            this.stopSmpd();
            throw new MpiexecException((BaseMsgID)new job.SmpdLaunchTimeout(), (Throwable)timeoutException);
        }
        catch (Exception exception) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "SmpdDaemonManager.buildSmpdProcess() hit launchFailure.", exception);
            this.stopSmpd();
            throw new MpiexecException((BaseMsgID)new job.SmpdLaunchAndReadFailed(), (Throwable)exception);
        }
        finally {
            executorService.shutdown();
        }
    }
}

