/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.logging;

import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.workunit.TaskAccess;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompSimpleFormatter;
import java.rmi.RemoteException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.id.Uuid;

public class TaskHandler
extends Handler {
    private Uuid fTaskID;
    private TaskAccess fTaskAccess;
    private StringBuilder fLogMessageBuffer = new StringBuilder();
    private Executor fLogToTask;

    public TaskHandler(TaskAccess taskAccess) {
        this.fTaskAccess = taskAccess;
        this.setLevel(DistcompLevel.OFF);
        this.setFormatter((Formatter)new DistcompSimpleFormatter());
        Logger logger = Logger.getLogger(TaskHandler.class.getName());
        logger.setUseParentHandlers(false);
        this.fLogToTask = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " fLogToTask-"), (Logger)logger));
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        Level level = this.getLevel();
        Formatter formatter = this.getFormatter();
        String string = formatter.format(logRecord);
        if (string == null || string.equals("")) {
            return;
        }
        this.fLogMessageBuffer.append(string);
        if (level.equals(DistcompLevel.FOUR) || level.equals(DistcompLevel.FIVE) || level.equals(DistcompLevel.SIX)) {
            this.flush();
        }
    }

    public synchronized void setTaskAccess(TaskAccess taskAccess) {
        this.fTaskAccess = taskAccess;
    }

    public synchronized void setTaskIDAndLevel(Uuid uuid, int n) {
        this.fTaskID = uuid;
        Level level = DistcompLevel.getLevelFromValue((int)n);
        this.setLevel(level);
    }

    public synchronized void clearTaskIDAndLevel() {
        this.fTaskID = null;
        this.setLevel(DistcompLevel.OFF);
    }

    @Override
    public synchronized void flush() {
        if (this.fTaskAccess != null && this.fTaskID != null && this.fLogMessageBuffer.length() != 0) {
            this.fLogToTask.execute(new CallToLog(this.fTaskAccess, this.fTaskID, this.fLogMessageBuffer.toString()));
            this.fLogMessageBuffer = new StringBuilder();
        }
    }

    @Override
    public synchronized void close() {
        this.flush();
        this.clearTaskIDAndLevel();
        this.fTaskAccess = null;
        this.fLogMessageBuffer = null;
    }

    private static class CallToLog
    implements Runnable {
        private TaskAccess iTaskAccess;
        private Uuid iTaskID;
        private String iLogMessage;

        CallToLog(TaskAccess taskAccess, Uuid uuid, String string) {
            this.iTaskAccess = taskAccess;
            this.iTaskID = uuid;
            this.iLogMessage = string;
        }

        @Override
        public void run() {
            try {
                this.iTaskAccess.addToLogOutput(new Uuid[]{this.iTaskID}, new String[]{this.iLogMessage});
            }
            catch (RemoteException remoteException) {
            }
            catch (MJSException mJSException) {
                // empty catch block
            }
        }
    }
}

