/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.datastore;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.mjs.datastore.CallerDataStoreExceededException;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStore;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreItem;
import com.mathworks.toolbox.distcomp.util.UnavailableEphemeralPortsException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.ServerException;

public class DataStoreOutputStream
extends OutputStream {
    private DataStore fDataStore;
    private DataStoreItem fDataStoreItem;

    public DataStoreOutputStream(DataStore dataStore, DataStoreItem dataStoreItem) {
        this.fDataStore = dataStore;
        this.fDataStoreItem = dataStoreItem;
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.fDataStore.write(this.fDataStoreItem, byArray2);
        }
        catch (ConnectIOException connectIOException) {
            this.tryToDetectUnavailableEphemeralPorts(connectIOException);
        }
        catch (ServerException serverException) {
            this.tryToRecoverDistcompException(serverException);
        }
        catch (CallerDataStoreExceededException callerDataStoreExceededException) {
            throw new DistcompException(callerDataStoreExceededException);
        }
    }

    private void tryToRecoverDistcompException(ServerException serverException) throws RemoteException {
        if (serverException.getCause() instanceof DistcompException) {
            throw (DistcompException)serverException.getCause();
        }
        throw serverException;
    }

    private void tryToDetectUnavailableEphemeralPorts(ConnectIOException connectIOException) throws RemoteException {
        if (connectIOException.getCause() instanceof BindException) {
            throw new DistcompException(new UnavailableEphemeralPortsException());
        }
        throw connectIOException;
    }
}

