/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.peerrmi;

import com.mathworks.toolbox.distcomp.mjs.peerrmi.Log;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.ObjectRegistry;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ExportedObjectRegistry
implements ObjectRegistry {
    private static final String TAG = ExportedObjectRegistry.class.getSimpleName();
    private final Map<ObjectRegistry.ID, WeakReference<Remote>> fExportedObjects = Collections.synchronizedMap(new HashMap());

    @Override
    public ObjectRegistry.ID register(Remote remote2) {
        assert (remote2 != null) : "Can not export null object";
        ObjectRegistry.ID iD = new ObjectRegistry.ID();
        Log.LOGGER.fine(TAG + ": Registered object " + remote2 + " with ID " + iD);
        this.fExportedObjects.put(iD, new WeakReference<Remote>(remote2));
        return iD;
    }

    @Override
    public Remote lookup(ObjectRegistry.ID iD) {
        Log.LOGGER.fine(TAG + ": Looking up object with ID " + iD);
        WeakReference<Remote> weakReference = this.fExportedObjects.get(iD);
        if (weakReference != null) {
            Remote remote2 = (Remote)weakReference.get();
            if (remote2 == null) {
                Log.LOGGER.finest(TAG + ": " + "Object " + iD + " has been garbage collected - removing from registry.");
                this.unregister(iD);
            }
            return remote2;
        }
        Log.LOGGER.finest(TAG + ": Failed to look up object with ID " + iD);
        return null;
    }

    @Override
    public void unregister(ObjectRegistry.ID iD) {
        Log.LOGGER.fine(TAG + ": Unregistering object with ID " + iD);
        this.fExportedObjects.remove(iD);
    }
}

